/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.util;

import java.util.LinkedList;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;

public class BukkitMiscUtil {
    public static String getTime(long milliseconds) {
        String message = "";
        long days = milliseconds / 86400000L;
        long hours = milliseconds % 86400000L / 3600000L;
        long minutes = milliseconds % 86400000L % 3600000L / 60000L;
        long seconds = milliseconds % 86400000L % 3600000L % 60000L / 1000L;
        long milliSeconds2 = milliseconds % 86400000L % 3600000L % 60000L % 1000L;
        if (days > 0L) {
            message = days == 1L ? message + " 1 " + BukkitLang.get("timeDay") + "," : message + " " + days + " " + BukkitLang.get("timeDays") + ",";
        }
        if (hours > 0L) {
            message = hours == 1L ? message + " 1 " + BukkitLang.get("timeHour") + "," : message + " " + hours + " " + BukkitLang.get("timeHours") + ",";
        }
        if (minutes > 0L) {
            message = minutes == 1L ? message + " 1 " + BukkitLang.get("timeMinute") + "," : message + " " + minutes + " " + BukkitLang.get("timeMinutes") + ",";
        }
        if (seconds > 0L) {
            message = seconds == 1L ? message + " 1 " + BukkitLang.get("timeSecond") + "," : message + " " + seconds + " " + BukkitLang.get("timeSeconds") + ",";
        } else if (milliSeconds2 > 0L) {
            message = milliSeconds2 == 1L ? message + " 1 " + BukkitLang.get("timeMillisecond") + "," : message + " " + milliSeconds2 + " " + BukkitLang.get("timeMilliseconds") + ",";
        }
        message = !message.isEmpty() ? message.substring(1, message.length() - 1) : "-1 " + BukkitLang.get("timeSeconds");
        return message;
    }

    public static String getCapitalized(String input) {
        if (input.isEmpty()) {
            return input;
        }
        String firstLetter = input.substring(0, 1);
        String remainder = input.substring(1);
        return firstLetter.toUpperCase() + remainder.toLowerCase();
    }

    public static String getPrettyMobName(EntityType type) {
        String baseString = type.toString();
        String[] substrings = baseString.split("_");
        String prettyString = "";
        int size = 1;
        for (String s : substrings) {
            prettyString = prettyString.concat(BukkitMiscUtil.getCapitalized(s));
            if (size < substrings.length) {
                prettyString = prettyString.concat(" ");
            }
            ++size;
        }
        if (type.equals((Object)EntityType.OCELOT)) {
            prettyString = "Ocelot";
        }
        return prettyString;
    }

    public static String snakeCaseToUpperCamelCase(String input) {
        String name = input.toLowerCase();
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        int i = 0;
        while ((long)i < input.chars().filter(num -> num == 95).count()) {
            int index = name.indexOf(95);
            if (index != -1) {
                name = name.substring(0, index + 1) + Character.toUpperCase(name.charAt(index + 1)) + name.substring(index + 2);
                name = name.replaceFirst("_", "");
            }
            ++i;
        }
        return name;
    }

    public static EntityType getProperMobType(String properName) {
        properName = properName.replace("_", "").replace(" ", "").toUpperCase();
        for (EntityType et : EntityType.values()) {
            if (!et.name().replace("_", "").equalsIgnoreCase(properName)) continue;
            return et;
        }
        return null;
    }

    public static Biome getProperBiome(String properName) {
        properName = properName.replace("_", "").replace(" ", "").toUpperCase();
        for (Biome b : Biome.values()) {
            if (!b.name().replace("_", "").equalsIgnoreCase(properName)) continue;
            return b;
        }
        return null;
    }

    public static String getPrettyDyeColorName(DyeColor color) {
        if (color == null) {
            return "White";
        }
        if (!BukkitLang.get("COLOR_" + color.name()).equals("NULL")) {
            return BukkitLang.get("COLOR_" + color.name());
        }
        String baseString = color.toString();
        String[] substrings = baseString.split("_");
        String prettyString = "";
        int size = 1;
        for (String s : substrings) {
            prettyString = prettyString.concat(BukkitMiscUtil.getCapitalized(s));
            if (size < substrings.length) {
                prettyString = prettyString.concat(" ");
            }
            ++size;
        }
        return prettyString;
    }

    public static DyeColor getProperDyeColor(String properName) {
        properName = properName.replace("_", "").replace(" ", "").toUpperCase();
        for (DyeColor dc : DyeColor.values()) {
            if (!dc.name().replace("_", "").equalsIgnoreCase(properName)) continue;
            return dc;
        }
        return null;
    }

    public static Effect getProperEffect(String properName) {
        properName = properName.replace("_", "").replace(" ", "").toUpperCase();
        for (Effect eff : Effect.values()) {
            if (!eff.name().replace("_", "").equalsIgnoreCase(properName)) continue;
            return eff;
        }
        return null;
    }

    public static LinkedList<String> makeLines(String input, String wordDelimiter, int lineLength, ChatColor lineColor) {
        LinkedList<String> toReturn = new LinkedList<String>();
        String[] split = input.split(wordDelimiter);
        StringBuilder line = new StringBuilder();
        int currentLength = 0;
        for (String piece : split) {
            if (currentLength + piece.length() > lineLength + 1) {
                String s = line.toString().replaceAll("^" + wordDelimiter, "");
                if (lineColor != null) {
                    toReturn.add(lineColor + s);
                } else {
                    toReturn.add(s);
                }
                line = new StringBuilder(piece + wordDelimiter);
                currentLength = piece.length() + 1;
                continue;
            }
            line.append(piece).append(wordDelimiter);
            currentLength += piece.length() + 1;
        }
        if (!line.toString().isEmpty()) {
            if (lineColor != null) {
                toReturn.add(lineColor + line.toString());
            } else {
                toReturn.add(line.toString());
            }
        }
        return toReturn;
    }

    public static String capitalsToSpaces(String input) {
        int max = input.length();
        for (int i = 1; i < max; ++i) {
            if (!Character.isUpperCase(input.charAt(i))) continue;
            input = input.substring(0, i) + " " + input.substring(i);
            ++i;
            ++max;
        }
        return input;
    }

    public static String spaceToCapital(String input) {
        int index = input.indexOf(32);
        if (index == -1) {
            return null;
        }
        input = input.substring(0, index + 1) + Character.toUpperCase(input.charAt(index + 1)) + input.substring(index + 2);
        input = input.replaceFirst(" ", "");
        return input;
    }

    public static boolean isBelow113() {
        return BukkitMiscUtil._isBelow113(Bukkit.getServer().getBukkitVersion().split("-")[0]);
    }

    private static boolean _isBelow113(String bukkitVersion) {
        if (bukkitVersion.matches("^[0-9.]+$")) {
            switch (bukkitVersion) {
                case "1.12.2": 
                case "1.12.1": 
                case "1.12": 
                case "1.11.2": 
                case "1.11.1": 
                case "1.11": 
                case "1.10.2": 
                case "1.10.1": 
                case "1.10": 
                case "1.9.4": 
                case "1.9.3": 
                case "1.9.2": 
                case "1.9.1": 
                case "1.9": 
                case "1.8.9": 
                case "1.8.8": 
                case "1.8.7": 
                case "1.8.6": 
                case "1.8.5": 
                case "1.8.4": 
                case "1.8.3": 
                case "1.8.2": 
                case "1.8.1": 
                case "1.8": 
                case "1.7.10": 
                case "1.7.9": 
                case "1.7.2": {
                    return true;
                }
            }
            return false;
        }
        Bukkit.getLogger().severe("[Quests] Received invalid Bukkit version " + bukkitVersion);
        return false;
    }
}

