/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import me.pikamug.quests.BukkitQuestsPlugin;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BukkitUpdateChecker {
    private final BukkitQuestsPlugin plugin;
    private final int resourceId;

    public BukkitUpdateChecker(BukkitQuestsPlugin plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public void getVersion(Consumer<String> consumer) {
        if (this.plugin.getConfigSettings().canUpdateCheck()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                     Scanner scanner = new Scanner(inputStream);){
                    if (scanner.hasNext()) {
                        consumer.accept(scanner.next());
                    }
                }
                catch (IOException e) {
                    this.plugin.getLogger().info("Update check failed: " + e.getMessage());
                }
            });
        }
    }

    public static boolean compareVersions(String currentVersion, String compareVersion) {
        String[] compareParts;
        if (currentVersion == null || compareVersion == null) {
            return false;
        }
        String[] currentParts = currentVersion.split("\\.");
        int length = Math.max(currentParts.length, (compareParts = compareVersion.split("\\.")).length);
        if (length > 3) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            int currentPart = Integer.parseInt(currentParts[i]);
            int comparePart = Integer.parseInt(compareParts[i]);
            if (comparePart <= currentPart) continue;
            return true;
        }
        return false;
    }
}

