/*
 * Decompiled with CFR 0.152.
 */
package com.sleapplugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigUpdater {
    private final JavaPlugin plugin;
    private final Logger logger;
    private final String currentVersion;

    public ConfigUpdater(JavaPlugin plugin, String currentVersion) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.currentVersion = currentVersion;
    }

    public boolean updateConfig(String fileName, boolean saveComments) {
        File configFile = new File(this.plugin.getDataFolder(), fileName);
        if (!configFile.exists()) {
            this.plugin.saveResource(fileName, false);
            return true;
        }
        if (!this.needsUpdate(configFile, fileName)) {
            return false;
        }
        this.logger.info("Updating " + fileName + " to version " + this.currentVersion);
        YamlConfiguration currentConfig = YamlConfiguration.loadConfiguration((File)configFile);
        String oldVersion = currentConfig.getString("version", "unknown");
        InputStream defaultConfigStream = this.plugin.getResource(fileName);
        if (defaultConfigStream == null) {
            this.logger.warning("Could not find default " + fileName + " in plugin resources");
            return false;
        }
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultConfigStream));
        boolean updated = this.updateConfigValues((FileConfiguration)currentConfig, (FileConfiguration)defaultConfig, "", saveComments);
        if (updated) {
            currentConfig.set("version", (Object)this.currentVersion);
            try {
                currentConfig.save(configFile);
                this.logger.info("Successfully updated " + fileName + " from v" + oldVersion + " to v" + this.currentVersion);
                return true;
            }
            catch (IOException e) {
                this.logger.severe("Could not save updated " + fileName + ": " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    public boolean updateLanguageFile(String langCode) {
        String fileName = "lang/" + langCode + ".yml";
        File langFile = new File(this.plugin.getDataFolder(), fileName);
        File langDir = langFile.getParentFile();
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        if (!langFile.exists()) {
            this.plugin.saveResource(fileName, false);
            return true;
        }
        if (!this.needsUpdate(langFile, fileName)) {
            return false;
        }
        this.logger.info("Updating " + fileName + " to version " + this.currentVersion);
        YamlConfiguration currentLang = YamlConfiguration.loadConfiguration((File)langFile);
        InputStream defaultLangStream = this.plugin.getResource(fileName);
        if (defaultLangStream == null) {
            this.logger.warning("Could not find default " + fileName + " in plugin resources");
            return false;
        }
        YamlConfiguration defaultLang = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultLangStream));
        boolean updated = this.updateConfigValues((FileConfiguration)currentLang, (FileConfiguration)defaultLang, "", false);
        if (updated) {
            currentLang.set("version", (Object)this.currentVersion);
            try {
                currentLang.save(langFile);
                this.logger.info("Successfully updated " + fileName + " to v" + this.currentVersion);
                return true;
            }
            catch (IOException e) {
                this.logger.severe("Could not save updated " + fileName + ": " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    private boolean needsUpdate(File file, String resourcePath) {
        YamlConfiguration existingConfig = YamlConfiguration.loadConfiguration((File)file);
        String existingVersion = existingConfig.getString("version", "unknown");
        if (existingVersion.equals("unknown")) {
            return true;
        }
        InputStream defaultStream = this.plugin.getResource(resourcePath);
        if (defaultStream == null) {
            return false;
        }
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
        return this.hasMissingKeys((FileConfiguration)existingConfig, (FileConfiguration)defaultConfig, "");
    }

    private boolean hasMissingKeys(FileConfiguration target, FileConfiguration source, String path) {
        if (path.isEmpty()) {
            for (String key : source.getKeys(false)) {
                boolean missingInSection;
                if (key.equals("version")) continue;
                if (!target.contains(key)) {
                    return true;
                }
                if (!source.isConfigurationSection(key) || !(missingInSection = this.hasMissingKeys(target, source, key))) continue;
                return true;
            }
            return false;
        }
        ConfigurationSection sourceSection = source.getConfigurationSection(path);
        if (sourceSection == null) {
            return false;
        }
        for (String key : sourceSection.getKeys(false)) {
            boolean missingInSection;
            String fullPath = path + "." + key;
            if (!target.contains(fullPath)) {
                return true;
            }
            if (!source.isConfigurationSection(fullPath) || !(missingInSection = this.hasMissingKeys(target, source, fullPath))) continue;
            return true;
        }
        return false;
    }

    private boolean updateConfigValues(FileConfiguration target, FileConfiguration source, String path, boolean saveComments) {
        boolean updated = false;
        if (path.isEmpty()) {
            Set keys = source.getKeys(false);
            for (String key : keys) {
                if (key.equals("version")) continue;
                if (source.isConfigurationSection(key)) {
                    if (!target.isConfigurationSection(key)) {
                        target.createSection(key);
                        updated = true;
                    }
                    boolean sectionUpdated = this.updateConfigValues(target, source, key, saveComments);
                    updated = updated || sectionUpdated;
                    continue;
                }
                if (target.contains(key)) continue;
                target.set(key, source.get(key));
                updated = true;
                this.logger.info("Added new config option: " + key);
            }
        } else {
            ConfigurationSection sourceSection = source.getConfigurationSection(path);
            if (sourceSection == null) {
                return false;
            }
            for (String key : sourceSection.getKeys(false)) {
                String fullPath = path + "." + key;
                if (source.isConfigurationSection(fullPath)) {
                    if (!target.isConfigurationSection(fullPath)) {
                        target.createSection(fullPath);
                        updated = true;
                    }
                    boolean sectionUpdated = this.updateConfigValues(target, source, fullPath, saveComments);
                    updated = updated || sectionUpdated;
                    continue;
                }
                if (target.contains(fullPath)) continue;
                target.set(fullPath, source.get(fullPath));
                updated = true;
                this.logger.info("Added new config option: " + fullPath);
            }
        }
        return updated;
    }
}

