/*
 * Decompiled with CFR 0.152.
 */
package com.sleapplugin;

import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class MessageUtil {
    private static Boolean isPaperServer = null;

    private static boolean isPaper() {
        if (isPaperServer == null) {
            try {
                Class.forName("net.kyori.adventure.text.Component");
                isPaperServer = true;
            }
            catch (ClassNotFoundException e) {
                isPaperServer = false;
            }
        }
        return isPaperServer;
    }

    public static void sendMessage(Player player, String message, MessageColor color) {
        if (MessageUtil.isPaper()) {
            MessageUtil.sendPaperMessage(player, message, color);
        } else {
            MessageUtil.sendSpigotMessage(player, message, color);
        }
    }

    private static void sendPaperMessage(Player player, String message, MessageColor color) {
        try {
            Class<?> componentClass = Class.forName("net.kyori.adventure.text.Component");
            Class<?> namedTextColorClass = Class.forName("net.kyori.adventure.text.format.NamedTextColor");
            Class<?> textColorClass = Class.forName("net.kyori.adventure.text.format.TextColor");
            Object textComponent = componentClass.getMethod("text", String.class).invoke(null, message);
            Object colorValue = null;
            switch (color.ordinal()) {
                case 0: {
                    colorValue = namedTextColorClass.getField("YELLOW").get(null);
                    break;
                }
                case 1: {
                    colorValue = namedTextColorClass.getField("GREEN").get(null);
                    break;
                }
                case 2: {
                    colorValue = namedTextColorClass.getField("GOLD").get(null);
                    break;
                }
                case 3: {
                    colorValue = namedTextColorClass.getField("WHITE").get(null);
                }
            }
            if (colorValue != null) {
                textComponent = componentClass.getMethod("color", textColorClass).invoke(textComponent, colorValue);
            }
            player.getClass().getMethod("sendMessage", componentClass).invoke((Object)player, textComponent);
        }
        catch (Exception e) {
            MessageUtil.sendSpigotMessage(player, message, color);
        }
    }

    private static void sendSpigotMessage(Player player, String message, MessageColor color) {
        player.sendMessage(String.valueOf(switch (color.ordinal()) {
            case 0 -> ChatColor.YELLOW;
            case 1 -> ChatColor.GREEN;
            case 2 -> ChatColor.GOLD;
            default -> ChatColor.WHITE;
        }) + message);
    }

    public static enum MessageColor {
        YELLOW,
        GREEN,
        GOLD,
        WHITE;

    }
}

