/*
 * Decompiled with CFR 0.152.
 */
package com.sleapplugin;

import com.sleapplugin.ConfigUpdater;
import com.sleapplugin.LanguageManager;
import com.sleapplugin.MessageUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SleepPlugin
extends JavaPlugin
implements Listener {
    private final Map<World, Set<Player>> sleepingPlayers = new HashMap<World, Set<Player>>();
    private final Map<World, BukkitRunnable> sleepTasks = new HashMap<World, BukkitRunnable>();
    private final Map<UUID, Long> lastProgressMessageTime = new ConcurrentHashMap<UUID, Long>();
    private LanguageManager lang;
    private int skipDelay;
    private int morningTime;
    private String messageMode;
    private int minPlayersRequired;
    private boolean ignoreNetherEndPlayers;
    private boolean skipStorms;
    private boolean smoothTimeEnabled;
    private int smoothTimeDuration;
    private int smoothTimeSteps;
    private static final long PROGRESS_MESSAGE_COOLDOWN = 3000L;
    private static final String PLUGIN_VERSION = "1.0.3";

    public void onEnable() {
        this.saveDefaultConfig();
        ConfigUpdater configUpdater = new ConfigUpdater(this, PLUGIN_VERSION);
        boolean configUpdated = configUpdater.updateConfig("config.yml", true);
        if (configUpdated) {
            String oldVersion = this.getConfig().getString("version", "1.0.1");
            this.getLogger().info("Configuration updated from v" + oldVersion + " to v1.0.3");
            this.getLogger().info("New settings have been added while preserving your existing configuration.");
        }
        String language = this.getConfig().getString("language", "en_EN");
        this.skipDelay = this.getConfig().getInt("skip-delay", 3);
        this.morningTime = this.getConfig().getInt("morning-time", 1000);
        this.messageMode = this.getConfig().getString("message-mode", "normal");
        this.minPlayersRequired = this.getConfig().getInt("min-players-required", 2);
        this.ignoreNetherEndPlayers = this.getConfig().getBoolean("ignore-nether-end-players", true);
        this.skipStorms = this.getConfig().getBoolean("storm-settings.skip-storms", true);
        this.smoothTimeEnabled = this.getConfig().getBoolean("smooth-time-transition.enabled", true);
        this.smoothTimeDuration = this.getConfig().getInt("smooth-time-transition.duration-ticks", 60);
        this.smoothTimeSteps = this.getConfig().getInt("smooth-time-transition.steps", 60);
        this.updateLanguageFiles(configUpdater);
        this.lang = new LanguageManager(this, language);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.displayPluginInfo();
        this.getLogger().info(this.lang.getMessage("plugin_enabled"));
    }

    private void updateLanguageFiles(ConfigUpdater configUpdater) {
        String[] bundledLanguages;
        File templateFile;
        File langDir = new File(this.getDataFolder(), "lang");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        if (!(templateFile = new File(langDir, "template.yml")).exists()) {
            this.saveResource("lang/template.yml", false);
            this.getLogger().info("Created template.yml for custom translations");
        }
        for (String langCode : bundledLanguages = new String[]{"en_EN", "ru_RU"}) {
            boolean updated = configUpdater.updateLanguageFile(langCode);
            if (!updated) continue;
            this.getLogger().info("Language file " + langCode + ".yml has been updated to v1.0.3");
        }
        File[] langFiles = langDir.listFiles((dir, name) -> name.endsWith(".yml"));
        if (langFiles != null) {
            for (File langFile : langFiles) {
                String fileName = langFile.getName();
                String langCode = fileName.replace(".yml", "");
                boolean isBundled = false;
                for (String bundled : bundledLanguages) {
                    if (!bundled.equals(langCode)) continue;
                    isBundled = true;
                    break;
                }
                if (isBundled || langCode.equals("template")) continue;
                this.getLogger().info("Found custom language file: " + langCode + ".yml");
            }
        }
    }

    public void onDisable() {
        for (BukkitRunnable task : this.sleepTasks.values()) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
        this.sleepTasks.clear();
        this.sleepingPlayers.clear();
        this.getLogger().info(this.lang.getMessage("plugin_disabled"));
    }

    @EventHandler
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (event.getBedEnterResult() != PlayerBedEnterEvent.BedEnterResult.OK) {
            return;
        }
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (!this.isNightOrStorm(world)) {
            return;
        }
        this.sleepingPlayers.computeIfAbsent(world, k -> new HashSet()).add(player);
        this.checkSleepRequirement(world);
    }

    @EventHandler
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        Set<Player> sleeping = this.sleepingPlayers.get(world);
        if (sleeping != null) {
            sleeping.remove(player);
            if (sleeping.isEmpty()) {
                this.sleepingPlayers.remove(world);
            }
        }
        int onlinePlayersInWorld = (int)Bukkit.getOnlinePlayers().stream().filter(p -> p.getWorld().equals((Object)world)).filter(p -> !p.isSleepingIgnored()).filter(p -> !this.shouldIgnorePlayer((Player)p)).count();
        int requiredSleeping = this.calculateRequiredSleeping(onlinePlayersInWorld);
        int currentSleeping = sleeping != null ? sleeping.size() : 0;
        BukkitRunnable task = this.sleepTasks.get(world);
        if (task != null && !task.isCancelled() && currentSleeping < requiredSleeping) {
            task.cancel();
            this.sleepTasks.remove(world);
            if (!this.messageMode.equals("silent")) {
                String messageKey = this.messageMode.equals("minimal") ? "sleep_canceled_minimal" : "sleep_canceled";
                this.broadcastToWorld(world, this.lang.getMessage(messageKey), MessageUtil.MessageColor.YELLOW);
            }
        }
    }

    private void checkSleepRequirement(World world) {
        Set<Player> sleeping = this.sleepingPlayers.get(world);
        if (sleeping == null || sleeping.isEmpty()) {
            return;
        }
        int onlinePlayersInWorld = (int)Bukkit.getOnlinePlayers().stream().filter(p -> p.getWorld().equals((Object)world)).filter(p -> !p.isSleepingIgnored()).filter(p -> !this.shouldIgnorePlayer((Player)p)).count();
        if (onlinePlayersInWorld == 0) {
            return;
        }
        if (onlinePlayersInWorld < this.minPlayersRequired) {
            return;
        }
        int requiredSleeping = this.calculateRequiredSleeping(onlinePlayersInWorld);
        int currentSleeping = sleeping.size();
        if (currentSleeping >= requiredSleeping) {
            this.startNightSkip(world, currentSleeping, onlinePlayersInWorld);
        } else if (!this.messageMode.equals("silent")) {
            UUID worldId = world.getUID();
            long currentTime = System.currentTimeMillis();
            if (!this.lastProgressMessageTime.containsKey(worldId) || currentTime - this.lastProgressMessageTime.get(worldId) > 3000L) {
                this.lastProgressMessageTime.put(worldId, currentTime);
                String messageKey = this.isOnlyStorm(world) ? "storm_progress" : "sleep_progress";
                String message = this.lang.getMessage(messageKey, currentSleeping, requiredSleeping);
                this.sendMessageToWorld(world, message);
            }
        }
    }

    private int calculateRequiredSleeping(int onlinePlayers) {
        if (onlinePlayers <= 1) {
            return Integer.MAX_VALUE;
        }
        if (onlinePlayers % 2 == 1) {
            return (onlinePlayers - 1) / 2;
        }
        return onlinePlayers / 2;
    }

    private void startNightSkip(final World world, int sleepingCount, int totalCount) {
        BukkitRunnable existingTask = this.sleepTasks.get(world);
        if (existingTask != null && !existingTask.isCancelled()) {
            existingTask.cancel();
        }
        if (!this.messageMode.equals("silent")) {
            UUID worldId = world.getUID();
            long currentTime = System.currentTimeMillis();
            if (!this.lastProgressMessageTime.containsKey(worldId) || currentTime - this.lastProgressMessageTime.get(worldId) > 3000L) {
                this.lastProgressMessageTime.put(worldId, currentTime);
                String baseKey = this.isOnlyStorm(world) ? "storm" : "sleep";
                String messageKey = this.messageMode.equals("minimal") ? baseKey + "_countdown_minimal" : baseKey + "_countdown";
                String message = this.messageMode.equals("minimal") ? this.lang.getMessage(messageKey, sleepingCount, totalCount) : this.lang.getMessage(messageKey, this.skipDelay, sleepingCount, totalCount);
                this.broadcastToWorld(world, message, MessageUtil.MessageColor.GREEN);
            }
        }
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                Set<Player> currentSleeping = SleepPlugin.this.sleepingPlayers.get(world);
                if (currentSleeping == null || currentSleeping.isEmpty()) {
                    SleepPlugin.this.sleepTasks.remove(world);
                    return;
                }
                int currentOnline = (int)world.getPlayers().stream().filter(p -> !p.isSleepingIgnored()).count();
                if (currentSleeping.size() >= SleepPlugin.this.calculateRequiredSleeping(currentOnline)) {
                    String baseKey;
                    boolean wasStorm;
                    boolean wasNight = SleepPlugin.this.isNight(world);
                    boolean bl = wasStorm = world.isThundering() || world.hasStorm();
                    if (world.isThundering()) {
                        world.setThundering(false);
                        world.setStorm(false);
                    }
                    if (wasNight) {
                        if (SleepPlugin.this.smoothTimeEnabled) {
                            SleepPlugin.this.smoothlySetTime(world, SleepPlugin.this.morningTime);
                        } else {
                            world.setTime((long)SleepPlugin.this.morningTime);
                        }
                    }
                    if (!SleepPlugin.this.messageMode.equals("silent") && (baseKey = wasNight ? "sleep" : (wasStorm ? "storm" : null)) != null) {
                        UUID worldId = world.getUID();
                        long currentTime = System.currentTimeMillis();
                        if (!SleepPlugin.this.lastProgressMessageTime.containsKey(worldId) || currentTime - SleepPlugin.this.lastProgressMessageTime.get(worldId) > 3000L) {
                            SleepPlugin.this.lastProgressMessageTime.put(worldId, currentTime);
                            Object messageKey = wasNight && SleepPlugin.this.smoothTimeEnabled && baseKey.equals("sleep") ? (SleepPlugin.this.messageMode.equals("minimal") ? "sleep_skipping_smooth_minimal" : "sleep_skipping_smooth") : (SleepPlugin.this.messageMode.equals("minimal") ? baseKey + "_success_minimal" : baseKey + "_success");
                            SleepPlugin.this.broadcastToWorld(world, SleepPlugin.this.lang.getMessage((String)messageKey), MessageUtil.MessageColor.GOLD);
                        }
                    }
                    SleepPlugin.this.sleepingPlayers.remove(world);
                }
                SleepPlugin.this.sleepTasks.remove(world);
            }
        };
        task.runTaskLater((Plugin)this, (long)this.skipDelay * 20L);
        this.sleepTasks.put(world, task);
    }

    private boolean isNightOrStorm(World world) {
        boolean night = this.isNight(world);
        boolean storm = this.skipStorms && world.hasStorm();
        return night || storm;
    }

    private boolean isOnlyStorm(World world) {
        return this.skipStorms && world.hasStorm() && !this.isNight(world);
    }

    private boolean shouldIgnorePlayer(Player player) {
        if (!this.ignoreNetherEndPlayers) {
            return false;
        }
        World.Environment env = player.getWorld().getEnvironment();
        return env == World.Environment.NETHER || env == World.Environment.THE_END;
    }

    private boolean isNight(World world) {
        long time = world.getTime();
        return time >= 12541L && time <= 23458L;
    }

    private void broadcastToWorld(World world, String message, MessageUtil.MessageColor color) {
        for (Player player : world.getPlayers()) {
            MessageUtil.sendMessage(player, message, color);
        }
    }

    private void sendMessageToWorld(World world, String message) {
        for (Player player : world.getPlayers()) {
            MessageUtil.sendMessage(player, message, MessageUtil.MessageColor.WHITE);
        }
    }

    private void smoothlySetTime(World world, long targetTime) {
        long currentTime = world.getTime();
        long diff = (targetTime - currentTime + 24000L) % 24000L;
        if (diff < 100L) {
            world.setTime(targetTime);
            return;
        }
        int stepCount = this.smoothTimeSteps;
        int ticksPerStep = Math.max(1, this.smoothTimeDuration / stepCount);
        for (int i = 0; i < stepCount; ++i) {
            int step = i;
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                double progress = (double)(step + 1) / (double)stepCount;
                double smoothProgress = (1.0 - Math.cos(Math.PI * progress)) / 2.0;
                long newTime = (currentTime + (long)((double)diff * smoothProgress)) % 24000L;
                world.setTime(newTime);
                if (step == stepCount - 1) {
                    world.setTime(targetTime);
                }
            }, (long)(ticksPerStep * i));
        }
    }

    private void displayPluginInfo() {
        String[] infoLines;
        for (String line : infoLines = new String[]{"\n", "  \u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557", "  \u2551                    SleepPlugin v1.0.3                   \u2551", "  \u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563", "  \u2551  Author: NovaDAndrew                                    \u2551", "  \u2551  Modrinth: https://modrinth.com/plugin/sleep-plugin     \u2551", "  \u2551  GitHub: https://github.com/NovaDAndrew/sleep-plugin    \u2551", "  \u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563", "  \u2551  Features:                                              \u2551", "  \u2551  \u2022 Skip night with only half of players sleeping        \u2551", "  \u2551  \u2022 Multiple message modes (normal/minimal/silent)       \u2551", "  \u2551  \u2022 Configurable minimum player requirement              \u2551", "  \u2551  \u2022 Smooth time transition (day/night)                   \u2551", "  \u2551  \u2022 Multi-language support (EN/RU + custom langs)        \u2551", "  \u2551  \u2022 Compatible with both Paper and Spigot servers        \u2551", "  \u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d", ""}) {
            this.getLogger().info(line);
        }
    }
}

