/*
 * Decompiled with CFR 0.152.
 */
package com.sleapplugin;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class LanguageManager {
    private final JavaPlugin plugin;
    private final String language;
    private YamlConfiguration langConfig;

    public LanguageManager(JavaPlugin plugin, String language) {
        this.plugin = plugin;
        this.language = language;
        this.loadLanguage();
    }

    private void loadLanguage() {
        String fileName = this.language + ".yml";
        try {
            InputStream defaultLangStream;
            File langFile = new File(this.plugin.getDataFolder(), "lang" + File.separator + fileName);
            if (!langFile.exists()) {
                langFile.getParentFile().mkdirs();
                defaultLangStream = this.plugin.getResource("lang/" + fileName);
                if (defaultLangStream != null) {
                    this.plugin.saveResource("lang/" + fileName, false);
                } else {
                    this.plugin.getLogger().warning("Could not find default language file: " + fileName);
                }
            }
            if (langFile.exists()) {
                this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
                defaultLangStream = this.plugin.getResource("lang/" + fileName);
                if (defaultLangStream != null) {
                    YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultLangStream, StandardCharsets.UTF_8));
                    this.langConfig.setDefaults((Configuration)defaultConfig);
                }
            } else {
                defaultLangStream = this.plugin.getResource("lang/" + fileName);
                if (defaultLangStream != null) {
                    this.langConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultLangStream, StandardCharsets.UTF_8));
                } else {
                    this.langConfig = new YamlConfiguration();
                    this.plugin.getLogger().severe("Failed to load language file: " + fileName);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error loading language file", e);
            this.langConfig = new YamlConfiguration();
        }
    }

    public String getMessage(String key) {
        if (this.langConfig.contains(key)) {
            return this.langConfig.getString(key);
        }
        this.plugin.getLogger().warning("Missing language key: " + key);
        return "Missing text for: " + key;
    }

    public String getMessage(String key, Object ... args) {
        String message = this.getMessage(key);
        if (message != null && args != null && args.length > 0) {
            return String.format(message, args);
        }
        return message;
    }
}

