/*
 * Decompiled with CFR 0.152.
 */
package com.sleapplugin;

import com.sleapplugin.LanguageManager;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SleepPlugin
extends JavaPlugin
implements Listener {
    private final Map<World, Set<Player>> sleepingPlayers = new HashMap<World, Set<Player>>();
    private final Map<World, BukkitRunnable> sleepTasks = new HashMap<World, BukkitRunnable>();
    private LanguageManager lang;
    private int skipDelay;
    private int morningTime;

    public void onEnable() {
        this.saveDefaultConfig();
        String language = this.getConfig().getString("language", "en_EN");
        this.skipDelay = this.getConfig().getInt("skip-delay", 3);
        this.morningTime = this.getConfig().getInt("morning-time", 1000);
        this.saveLanguageFiles();
        this.lang = new LanguageManager(this, language);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info(this.lang.getMessage("plugin_enabled"));
    }

    private void saveLanguageFiles() {
        String[] supportedLanguages = new String[]{"en_EN", "ru_RU"};
        File langDir = new File(this.getDataFolder(), "lang");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        for (String langCode : supportedLanguages) {
            String fileName = "lang/" + langCode + ".yml";
            if (this.getResource(fileName) == null) continue;
            this.saveResource(fileName, false);
            this.getLogger().info("Language file " + langCode + ".yml has been initialized");
        }
    }

    public void onDisable() {
        for (BukkitRunnable task : this.sleepTasks.values()) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
        this.sleepTasks.clear();
        this.sleepingPlayers.clear();
        this.getLogger().info(this.lang.getMessage("plugin_disabled"));
    }

    @EventHandler
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (event.getBedEnterResult() != PlayerBedEnterEvent.BedEnterResult.OK) {
            return;
        }
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (!this.isNightOrStorm(world)) {
            return;
        }
        this.sleepingPlayers.computeIfAbsent(world, k -> new HashSet()).add(player);
        this.checkSleepRequirement(world);
    }

    @EventHandler
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        BukkitRunnable task;
        Player player = event.getPlayer();
        World world = player.getWorld();
        Set<Player> sleeping = this.sleepingPlayers.get(world);
        if (sleeping != null) {
            sleeping.remove(player);
            if (sleeping.isEmpty()) {
                this.sleepingPlayers.remove(world);
            }
        }
        if ((task = this.sleepTasks.get(world)) != null && !task.isCancelled()) {
            task.cancel();
            this.sleepTasks.remove(world);
            this.broadcastToWorld(world, (Component)Component.text((String)this.lang.getMessage("sleep_canceled"), (TextColor)NamedTextColor.YELLOW));
        }
    }

    private void checkSleepRequirement(World world) {
        Set<Player> sleeping = this.sleepingPlayers.get(world);
        if (sleeping == null || sleeping.isEmpty()) {
            return;
        }
        int onlinePlayersInWorld = (int)world.getPlayers().stream().filter(p -> !p.isSleepingIgnored()).count();
        if (onlinePlayersInWorld == 0) {
            return;
        }
        int requiredSleeping = this.calculateRequiredSleeping(onlinePlayersInWorld);
        int currentSleeping = sleeping.size();
        if (currentSleeping >= requiredSleeping) {
            this.startNightSkip(world, currentSleeping, onlinePlayersInWorld);
        } else {
            String message = this.lang.getMessage("sleep_progress", currentSleeping, requiredSleeping);
            this.broadcastToWorld(world, (Component)Component.text((String)message, (TextColor)NamedTextColor.AQUA));
        }
    }

    private int calculateRequiredSleeping(int onlinePlayers) {
        if (onlinePlayers == 2) {
            return 1;
        }
        if (onlinePlayers % 2 == 1) {
            return (onlinePlayers - 1) / 2;
        }
        return onlinePlayers / 2;
    }

    private void startNightSkip(final World world, int sleepingCount, int totalCount) {
        BukkitRunnable existingTask = this.sleepTasks.get(world);
        if (existingTask != null && !existingTask.isCancelled()) {
            existingTask.cancel();
        }
        String message = this.lang.getMessage("sleep_countdown", sleepingCount, totalCount);
        this.broadcastToWorld(world, (Component)Component.text((String)message, (TextColor)NamedTextColor.GREEN));
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                Set<Player> currentSleeping = SleepPlugin.this.sleepingPlayers.get(world);
                if (currentSleeping == null || currentSleeping.isEmpty()) {
                    SleepPlugin.this.sleepTasks.remove(world);
                    return;
                }
                int currentOnline = (int)world.getPlayers().stream().filter(p -> !p.isSleepingIgnored()).count();
                if (currentSleeping.size() >= SleepPlugin.this.calculateRequiredSleeping(currentOnline)) {
                    if (world.isThundering()) {
                        world.setThundering(false);
                        world.setStorm(false);
                    }
                    if (SleepPlugin.this.isNight(world)) {
                        world.setTime((long)SleepPlugin.this.morningTime);
                    }
                    SleepPlugin.this.broadcastToWorld(world, (Component)Component.text((String)SleepPlugin.this.lang.getMessage("sleep_success"), (TextColor)NamedTextColor.GOLD));
                    SleepPlugin.this.sleepingPlayers.remove(world);
                }
                SleepPlugin.this.sleepTasks.remove(world);
            }
        };
        task.runTaskLater((Plugin)this, (long)this.skipDelay * 20L);
        this.sleepTasks.put(world, task);
    }

    private boolean isNightOrStorm(World world) {
        return this.isNight(world) || world.hasStorm();
    }

    private boolean isNight(World world) {
        long time = world.getTime();
        return time >= 12541L && time <= 23458L;
    }

    private void broadcastToWorld(World world, Component message) {
        for (Player player : world.getPlayers()) {
            player.sendMessage(message);
        }
    }
}

