/*
 * Decompiled with CFR 0.152.
 */
package com.sleapplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SleepPlugin
extends JavaPlugin
implements Listener {
    private final Map<World, Set<Player>> sleepingPlayers = new HashMap<World, Set<Player>>();
    private final Map<World, BukkitRunnable> sleepTasks = new HashMap<World, BukkitRunnable>();

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("SleepPlugin \u0432\u043a\u043b\u044e\u0447\u0435\u043d! \u0422\u0435\u043f\u0435\u0440\u044c \u0434\u043b\u044f \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430 \u043d\u043e\u0447\u0438 \u043d\u0443\u0436\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0430 \u0438\u0433\u0440\u043e\u043a\u043e\u0432.");
    }

    public void onDisable() {
        for (BukkitRunnable task : this.sleepTasks.values()) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
        this.sleepTasks.clear();
        this.sleepingPlayers.clear();
        this.getLogger().info("SleepPlugin \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
    }

    @EventHandler
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (event.getBedEnterResult() != PlayerBedEnterEvent.BedEnterResult.OK) {
            return;
        }
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (!this.isNightOrStorm(world)) {
            return;
        }
        this.sleepingPlayers.computeIfAbsent(world, k -> new HashSet()).add(player);
        this.checkSleepRequirement(world);
    }

    @EventHandler
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        BukkitRunnable task;
        Player player = event.getPlayer();
        World world = player.getWorld();
        Set<Player> sleeping = this.sleepingPlayers.get(world);
        if (sleeping != null) {
            sleeping.remove(player);
            if (sleeping.isEmpty()) {
                this.sleepingPlayers.remove(world);
            }
        }
        if ((task = this.sleepTasks.get(world)) != null && !task.isCancelled()) {
            task.cancel();
            this.sleepTasks.remove(world);
            this.broadcastToWorld(world, (Component)Component.text((String)"\u041f\u0440\u043e\u043f\u0443\u0441\u043a \u043d\u043e\u0447\u0438 \u043e\u0442\u043c\u0435\u043d\u0435\u043d - \u0438\u0433\u0440\u043e\u043a \u043f\u0440\u043e\u0441\u043d\u0443\u043b\u0441\u044f!", (TextColor)NamedTextColor.YELLOW));
        }
    }

    private void checkSleepRequirement(World world) {
        Set<Player> sleeping = this.sleepingPlayers.get(world);
        if (sleeping == null || sleeping.isEmpty()) {
            return;
        }
        int onlinePlayersInWorld = (int)world.getPlayers().stream().filter(p -> !p.isSleepingIgnored()).count();
        if (onlinePlayersInWorld == 0) {
            return;
        }
        int requiredSleeping = this.calculateRequiredSleeping(onlinePlayersInWorld);
        int currentSleeping = sleeping.size();
        if (currentSleeping >= requiredSleeping) {
            this.startNightSkip(world, currentSleeping, onlinePlayersInWorld);
        } else {
            String message = String.format("\u0421\u043f\u044f\u0442 %d \u0438\u0437 %d \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0434\u043b\u044f \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430 \u043d\u043e\u0447\u0438", currentSleeping, requiredSleeping);
            this.broadcastToWorld(world, (Component)Component.text((String)message, (TextColor)NamedTextColor.AQUA));
        }
    }

    private int calculateRequiredSleeping(int onlinePlayers) {
        if (onlinePlayers == 2) {
            return 1;
        }
        if (onlinePlayers % 2 == 1) {
            return (onlinePlayers - 1) / 2;
        }
        return onlinePlayers / 2;
    }

    private void startNightSkip(final World world, int sleepingCount, int totalCount) {
        BukkitRunnable existingTask = this.sleepTasks.get(world);
        if (existingTask != null && !existingTask.isCancelled()) {
            existingTask.cancel();
        }
        String message = String.format("\u041f\u0440\u043e\u043f\u0443\u0441\u043a \u043d\u043e\u0447\u0438 \u0447\u0435\u0440\u0435\u0437 3 \u0441\u0435\u043a\u0443\u043d\u0434\u044b... (%d/%d \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0441\u043f\u044f\u0442)", sleepingCount, totalCount);
        this.broadcastToWorld(world, (Component)Component.text((String)message, (TextColor)NamedTextColor.GREEN));
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                Set<Player> currentSleeping = SleepPlugin.this.sleepingPlayers.get(world);
                if (currentSleeping == null || currentSleeping.isEmpty()) {
                    SleepPlugin.this.sleepTasks.remove(world);
                    return;
                }
                int currentOnline = (int)world.getPlayers().stream().filter(p -> !p.isSleepingIgnored()).count();
                if (currentSleeping.size() >= SleepPlugin.this.calculateRequiredSleeping(currentOnline)) {
                    if (world.isThundering()) {
                        world.setThundering(false);
                        world.setStorm(false);
                    }
                    if (SleepPlugin.this.isNight(world)) {
                        world.setTime(1000L);
                    }
                    SleepPlugin.this.broadcastToWorld(world, (Component)Component.text((String)"\u041d\u043e\u0447\u044c \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430! \u0414\u043e\u0431\u0440\u043e\u0435 \u0443\u0442\u0440\u043e!", (TextColor)NamedTextColor.GOLD));
                    SleepPlugin.this.sleepingPlayers.remove(world);
                }
                SleepPlugin.this.sleepTasks.remove(world);
            }
        };
        task.runTaskLater((Plugin)this, 60L);
        this.sleepTasks.put(world, task);
    }

    private boolean isNightOrStorm(World world) {
        return this.isNight(world) || world.hasStorm();
    }

    private boolean isNight(World world) {
        long time = world.getTime();
        return time >= 12541L && time <= 23458L;
    }

    private void broadcastToWorld(World world, Component message) {
        for (Player player : world.getPlayers()) {
            player.sendMessage(message);
        }
    }
}

