/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.healthcommand.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tristankechlo.healthcommand.config.ConfigManager;
import com.tristankechlo.healthcommand.config.HealthCommandConfig;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class HealthCommand {
    private static final class_2960 ATTRIBUTE_ID = class_2960.method_60655((String)"healthcommand", (String)"main");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"health").requires(player -> {
            int level = HealthCommandConfig.get().permissionLevel();
            return player.method_9259(level);
        })).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(source -> HealthCommand.addHealth((class_2168)source.getSource(), class_2186.method_9317((CommandContext)source, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)source, (String)"amount"))))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(source -> HealthCommand.setHealth((class_2168)source.getSource(), class_2186.method_9317((CommandContext)source, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)source, (String)"amount"))))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(source -> HealthCommand.getHealth((class_2168)source.getSource(), class_2186.method_9317((CommandContext)source, (String)"targets")))))).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(source -> HealthCommand.resetHealth((class_2168)source.getSource(), class_2186.method_9317((CommandContext)source, (String)"targets"))))));
        ConfigManager.LOGGER.info("Command '/health' registered");
    }

    private static int addHealth(class_2168 source, Collection<? extends class_1297> targets, int amount) {
        int i = 0;
        class_1309 lastModified = null;
        for (class_1297 class_12972 : targets) {
            class_1309 livingEntity;
            class_3222 player;
            if (!(class_12972 instanceof class_1309) || class_12972 instanceof class_3222 && ((player = (class_3222)class_12972).method_68878() || player.method_7325())) continue;
            lastModified = livingEntity = (class_1309)class_12972;
            if (!HealthCommand.setHealthSingle(livingEntity, livingEntity.method_6032() + (float)amount, HealthCommandConfig.get()::goBeyondMaxHealthForAdding)) continue;
            ++i;
        }
        if (i == 0) {
            source.method_9213((class_2561)class_2561.method_43470((String)"There were no entities with a health attribute in your selection."));
        } else if (i == 1 && lastModified != null) {
            m = "New health of " + lastModified.method_5477().getString() + " is " + lastModified.method_6032();
            source.method_9226(() -> class_2561.method_43470((String)m), false);
        } else {
            m = "Health of " + i + " entities is increased by " + amount;
            source.method_9226(() -> class_2561.method_43470((String)m), false);
        }
        return i;
    }

    private static int setHealth(class_2168 source, Collection<? extends class_1297> targets, int amount) {
        int i = 0;
        class_1309 lastModified = null;
        for (class_1297 class_12972 : targets) {
            class_1309 livingEntity;
            class_3222 player;
            if (!(class_12972 instanceof class_1309) || class_12972 instanceof class_3222 && ((player = (class_3222)class_12972).method_68878() || player.method_7325())) continue;
            lastModified = livingEntity = (class_1309)class_12972;
            if (!HealthCommand.setHealthSingle(livingEntity, amount, HealthCommandConfig.get()::goBeyondMaxHealthForSetting)) continue;
            ++i;
        }
        if (i == 0) {
            source.method_9213((class_2561)class_2561.method_43470((String)"There were no entities with a health attribute in your selection."));
        } else if (i == 1 && lastModified != null) {
            m = "New health of " + lastModified.method_5477().getString() + " is " + lastModified.method_6032();
            source.method_9226(() -> class_2561.method_43470((String)m), false);
        } else {
            m = "New health of " + i + " entities is now " + amount;
            source.method_9226(() -> class_2561.method_43470((String)m), false);
        }
        return i;
    }

    private static int getHealth(class_2168 source, Collection<? extends class_1297> targets) {
        for (class_1297 class_12972 : targets) {
            if (!(class_12972 instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)class_12972;
            float health = livingEntity.method_6032();
            String m = livingEntity.method_5477().getString() + " has " + health + " health left.";
            source.method_9226(() -> class_2561.method_43470((String)m), false);
        }
        return 1;
    }

    private static int resetHealth(class_2168 source, Collection<? extends class_1297> targets) {
        for (class_1297 class_12972 : targets) {
            if (!(class_12972 instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)class_12972;
            class_1324 attribute = livingEntity.method_5996(class_5134.field_23716);
            attribute.method_6200(ATTRIBUTE_ID);
            float health = livingEntity.method_6032();
            livingEntity.method_6033(health);
            String m = "Resetted the health of " + livingEntity.method_5477().getString();
            source.method_9226(() -> class_2561.method_43470((String)m), false);
        }
        return 1;
    }

    private static boolean setHealthSingle(class_1309 livingEntity, float newHealth, Supplier<Boolean> goBeyondMaxHealth) {
        class_1324 attribute = livingEntity.method_5996(class_5134.field_23716);
        if (newHealth <= livingEntity.method_6063()) {
            livingEntity.method_6033(newHealth);
            attribute.method_6200(ATTRIBUTE_ID);
            double amount = (double)newHealth - attribute.method_6201();
            attribute.method_26837(new class_1322(ATTRIBUTE_ID, amount, class_1322.class_1323.field_6328));
        } else {
            boolean increaseBeyond = goBeyondMaxHealth.get();
            if (increaseBeyond) {
                attribute.method_6200(ATTRIBUTE_ID);
                double amount = (double)newHealth - attribute.method_6201();
                attribute.method_26837(new class_1322(ATTRIBUTE_ID, amount, class_1322.class_1323.field_6328));
                livingEntity.method_6033(newHealth);
            } else {
                livingEntity.method_6033(livingEntity.method_6063());
            }
        }
        return true;
    }
}

