/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.healthcommand.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tristankechlo.healthcommand.config.ConfigManager;
import com.tristankechlo.healthcommand.config.HealthCommandConfig;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class HealthCommand {
    private static final ResourceLocation ATTRIBUTE_ID = ResourceLocation.fromNamespaceAndPath((String)"healthcommand", (String)"main");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"health").requires(player -> {
            int level = HealthCommandConfig.get().permissionLevel();
            return player.hasPermission(level);
        })).then(Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(source -> HealthCommand.addHealth((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)source, (String)"amount"))))))).then(Commands.literal((String)"set").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(source -> HealthCommand.setHealth((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)source, (String)"amount"))))))).then(Commands.literal((String)"get").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(source -> HealthCommand.getHealth((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"targets")))))).then(Commands.literal((String)"reset").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(source -> HealthCommand.resetHealth((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"targets"))))));
        ConfigManager.LOGGER.info("Command '/health' registered");
    }

    private static int addHealth(CommandSourceStack source, Collection<? extends Entity> targets, int amount) {
        int i = 0;
        LivingEntity lastModified = null;
        for (Entity entity : targets) {
            LivingEntity livingEntity;
            ServerPlayer player;
            if (!(entity instanceof LivingEntity) || entity instanceof ServerPlayer && ((player = (ServerPlayer)entity).isCreative() || player.isSpectator())) continue;
            lastModified = livingEntity = (LivingEntity)entity;
            if (!HealthCommand.setHealthSingle(livingEntity, livingEntity.getHealth() + (float)amount, HealthCommandConfig.get()::goBeyondMaxHealthForAdding)) continue;
            ++i;
        }
        if (i == 0) {
            source.sendFailure((Component)Component.literal((String)"There were no entities with a health attribute in your selection."));
        } else if (i == 1 && lastModified != null) {
            m = "New health of " + lastModified.getName().getString() + " is " + lastModified.getHealth();
            source.sendSuccess(() -> Component.literal((String)m), false);
        } else {
            m = "Health of " + i + " entities is increased by " + amount;
            source.sendSuccess(() -> Component.literal((String)m), false);
        }
        return i;
    }

    private static int setHealth(CommandSourceStack source, Collection<? extends Entity> targets, int amount) {
        int i = 0;
        LivingEntity lastModified = null;
        for (Entity entity : targets) {
            LivingEntity livingEntity;
            ServerPlayer player;
            if (!(entity instanceof LivingEntity) || entity instanceof ServerPlayer && ((player = (ServerPlayer)entity).isCreative() || player.isSpectator())) continue;
            lastModified = livingEntity = (LivingEntity)entity;
            if (!HealthCommand.setHealthSingle(livingEntity, amount, HealthCommandConfig.get()::goBeyondMaxHealthForSetting)) continue;
            ++i;
        }
        if (i == 0) {
            source.sendFailure((Component)Component.literal((String)"There were no entities with a health attribute in your selection."));
        } else if (i == 1 && lastModified != null) {
            m = "New health of " + lastModified.getName().getString() + " is " + lastModified.getHealth();
            source.sendSuccess(() -> Component.literal((String)m), false);
        } else {
            m = "New health of " + i + " entities is now " + amount;
            source.sendSuccess(() -> Component.literal((String)m), false);
        }
        return i;
    }

    private static int getHealth(CommandSourceStack source, Collection<? extends Entity> targets) {
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            float health = livingEntity.getHealth();
            String m = livingEntity.getName().getString() + " has " + health + " health left.";
            source.sendSuccess(() -> Component.literal((String)m), false);
        }
        return 1;
    }

    private static int resetHealth(CommandSourceStack source, Collection<? extends Entity> targets) {
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            AttributeInstance attribute = livingEntity.getAttribute(Attributes.MAX_HEALTH);
            attribute.removeModifier(ATTRIBUTE_ID);
            float health = livingEntity.getHealth();
            livingEntity.setHealth(health);
            String m = "Resetted the health of " + livingEntity.getName().getString();
            source.sendSuccess(() -> Component.literal((String)m), false);
        }
        return 1;
    }

    private static boolean setHealthSingle(LivingEntity livingEntity, float newHealth, Supplier<Boolean> goBeyondMaxHealth) {
        AttributeInstance attribute = livingEntity.getAttribute(Attributes.MAX_HEALTH);
        if (newHealth <= livingEntity.getMaxHealth()) {
            livingEntity.setHealth(newHealth);
            attribute.removeModifier(ATTRIBUTE_ID);
            double amount = (double)newHealth - attribute.getBaseValue();
            attribute.addPermanentModifier(new AttributeModifier(ATTRIBUTE_ID, amount, AttributeModifier.Operation.ADD_VALUE));
        } else {
            boolean increaseBeyond = goBeyondMaxHealth.get();
            if (increaseBeyond) {
                attribute.removeModifier(ATTRIBUTE_ID);
                double amount = (double)newHealth - attribute.getBaseValue();
                attribute.addPermanentModifier(new AttributeModifier(ATTRIBUTE_ID, amount, AttributeModifier.Operation.ADD_VALUE));
                livingEntity.setHealth(newHealth);
            } else {
                livingEntity.setHealth(livingEntity.getMaxHealth());
            }
        }
        return true;
    }
}

