/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.healthcommand.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tristankechlo.healthcommand.commands.ProjectLinks;
import com.tristankechlo.healthcommand.config.ConfigManager;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ModCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"healthcommand").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"config").requires(source -> source.hasPermission(3))).then(Commands.literal((String)"reload").executes(ModCommand::configReload))).then(Commands.literal((String)"show").executes(ModCommand::configShow))).then(Commands.literal((String)"reset").executes(ModCommand::configReset)))).then(Commands.literal((String)"github").executes(ProjectLinks.GITHUB::execute))).then(Commands.literal((String)"issue").executes(ProjectLinks.ISSUE::execute))).then(Commands.literal((String)"discord").executes(ProjectLinks.DISCORD::execute))).then(Commands.literal((String)"curseforge").executes(ProjectLinks.CURSEFORGE::execute))).then(Commands.literal((String)"modrinth").executes(ProjectLinks.MODRINTH::execute));
        dispatcher.register(command);
        ConfigManager.LOGGER.info("Command '/healthcommand' registered");
    }

    private static int configReload(CommandContext<CommandSourceStack> context) {
        ConfigManager.reloadConfig();
        MutableComponent message = Component.literal((String)"Config was successfully reloaded.");
        ModCommand.sendMessage((CommandSourceStack)context.getSource(), (Component)message.withStyle(ChatFormatting.WHITE), true);
        return 1;
    }

    private static int configShow(CommandContext<CommandSourceStack> context) {
        MutableComponent clickableFile = ModCommand.clickableConfig();
        MutableComponent message = Component.literal((String)"Config-file can be found here: ").append((Component)clickableFile);
        ModCommand.sendMessage((CommandSourceStack)context.getSource(), (Component)message.withStyle(ChatFormatting.WHITE), false);
        return 1;
    }

    private static int configReset(CommandContext<CommandSourceStack> context) {
        ConfigManager.resetConfig();
        MutableComponent message = Component.literal((String)"Config was successfully set to default.");
        ModCommand.sendMessage((CommandSourceStack)context.getSource(), (Component)message.withStyle(ChatFormatting.WHITE), true);
        return 1;
    }

    private static MutableComponent start() {
        return Component.literal((String)"[HealthCommand] ").withStyle(ChatFormatting.GOLD);
    }

    public static void sendMessage(CommandSourceStack source, Component message, boolean broadcastToOps) {
        MutableComponent start = ModCommand.start().append(message);
        source.sendSuccess(() -> start, broadcastToOps);
    }

    private static MutableComponent clickableConfig() {
        String fileName = "healthcommand.json";
        String filePath = ConfigManager.getConfigPath();
        MutableComponent mutableComponent = Component.literal((String)fileName);
        mutableComponent.withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE});
        mutableComponent.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenFile(filePath)));
        return mutableComponent;
    }

    private static MutableComponent clickableLink(URI url, String displayText) {
        MutableComponent mutableComponent = Component.literal((String)displayText);
        mutableComponent.withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE});
        mutableComponent.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(url)));
        return mutableComponent;
    }

    public static MutableComponent clickableLink(String url) throws URISyntaxException {
        return ModCommand.clickableLink(new URI(url), url);
    }
}

