/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.healthcommand.commands;

import com.mojang.brigadier.context.CommandContext;
import com.tristankechlo.healthcommand.commands.ModCommand;
import com.tristankechlo.healthcommand.config.ConfigManager;
import java.net.URISyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum ProjectLinks {
    GITHUB("https://github.com/tristankechlo/HealthCommand", "Check out the source code on GitHub: "),
    ISSUE(ProjectLinks.GITHUB.url + "/issues", "If you found an issue, submit it here: "),
    DISCORD("https://discord.gg/bhUaWhq", "Join the Discord here: "),
    CURSEFORGE("https://curseforge.com/minecraft/mc-mods/health-command", "Check out the CurseForge page here: "),
    MODRINTH("https://modrinth.com/mod/health-command", "Check out the Modrinth page here: ");

    private final String url;
    private final String message;

    private ProjectLinks(String url, String message) {
        this.url = url;
        this.message = message;
    }

    public int execute(CommandContext<CommandSourceStack> context) {
        try {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            MutableComponent link = ModCommand.clickableLink(this.url);
            MutableComponent message = Component.literal((String)this.message).withStyle(ChatFormatting.WHITE).append((Component)link);
            ModCommand.sendMessage(source, (Component)message, false);
        }
        catch (URISyntaxException e) {
            ConfigManager.LOGGER.error((Object)e);
            ModCommand.sendMessage((CommandSourceStack)context.getSource(), (Component)Component.literal((String)"An error occurred! Please check the server console!").withStyle(ChatFormatting.RED), true);
        }
        return 1;
    }
}

