/*
 * Decompiled with CFR 0.152.
 */
package de.tr7zw.nbtapi.plugin.tests.compounds;

import de.tr7zw.nbtapi.NBT;
import de.tr7zw.nbtapi.NBTType;
import de.tr7zw.nbtapi.NbtApiException;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import de.tr7zw.nbtapi.iface.ReadWriteNBTCompoundList;
import de.tr7zw.nbtapi.iface.ReadableNBTList;
import de.tr7zw.nbtapi.plugin.tests.Test;
import java.util.Arrays;
import java.util.UUID;

public class ListTest
implements Test {
    @Override
    public void test() throws Exception {
        ReadWriteNBT comp = NBT.createNBTObject();
        ReadableNBTList list = comp.getStringList("testlist");
        list.add("test1");
        list.add("test2");
        list.add("test3");
        list.add("test4");
        list.set(2, "test42");
        list.remove(1);
        if (!((String)list.get(1)).equals("test42") || list.size() != 3) {
            throw new NbtApiException("The String-list did not match what it should have looked like.");
        }
        ReadWriteNBTCompoundList taglist = comp.getCompoundList("complist");
        ReadWriteNBT lcomp = taglist.addCompound();
        lcomp.setDouble("double1", 0.3333);
        lcomp.setInteger("int1", 42);
        lcomp.setString("test1", "test1");
        lcomp.setString("test2", "test2");
        lcomp.removeKey("test1");
        ReadWriteNBT subsubcomp = lcomp.getOrCreateCompound("listsubkey");
        subsubcomp.setString("deep", "String");
        subsubcomp.getCompoundList("deeplist").addCompound().setString("test", "test");
        subsubcomp.getCompoundList("clonelist").addCompound(comp);
        taglist = null;
        lcomp = null;
        subsubcomp = null;
        taglist = comp.getCompoundList("complist");
        if (taglist.size() == 1) {
            lcomp = (ReadWriteNBT)taglist.get(0);
            ReadWriteNBT sublist = lcomp.getCompound("listsubkey");
            if (lcomp.getKeys().size() != 4) {
                throw new NbtApiException("Wrong key amount in Taglist (" + lcomp.getKeys().size() + ")!");
            }
            if (sublist == null) {
                throw new NbtApiException("The sublist is null! The Item-NBT-API may not work!");
            }
            if (lcomp.getDouble("double1") != 0.3333 || lcomp.getInteger("int1") != 42 || !lcomp.getString("test2").equals("test2") || lcomp.hasTag("test1")) {
                throw new NbtApiException("One key in the Taglist changed! The Item-NBT-API may not work!");
            }
            if (!"String".equals(sublist.getString("deep"))) {
                throw new NbtApiException("The Compound nested in the listcompound was not correct! The Item-NBT-API may not work!");
            }
            if (sublist.getType("deep") != NBTType.NBTTagString) {
                throw new NbtApiException("The nested key's type wasn't correct! The Item-NBT-API may not work!");
            }
            if (sublist.getType("deeplist") != NBTType.NBTTagList) {
                throw new NbtApiException("The nested list's type wasn't correct '" + (Object)((Object)sublist.getType("deeplist")) + "'! The Item-NBT-API may not work!");
            }
        } else {
            throw new NbtApiException("Taglist is empty! The Item-NBT-API may not work!");
        }
        if (comp.getListType("complist") != NBTType.NBTTagCompound) {
            throw new NbtApiException("complist had the wrong type(" + (Object)((Object)comp.getListType("complist")) + ")! The Item-NBT-API may not work!");
        }
        ReadableNBTList intlist = comp.getIntegerList("inttest");
        intlist.add(42);
        intlist.add(69);
        if (intlist.size() != 2 || (Integer)intlist.get(0) != 42 || (Integer)intlist.get(1) != 69) {
            throw new NbtApiException("IntList is not correct! " + Arrays.toString((Object[])intlist.toArray(new Integer[0])));
        }
        if (comp.getListType("inttest") != NBTType.NBTTagInt) {
            throw new NbtApiException("inttest had the wrong type! The Item-NBT-API may not work!");
        }
        ReadableNBTList doublelist = comp.getDoubleList("doubletest");
        doublelist.add(42.23);
        doublelist.add(69.69);
        if (doublelist.size() != 2 || (Double)doublelist.get(0) != 42.23 || (Double)doublelist.get(1) != 69.69) {
            throw new NbtApiException("DoubleList is not correct! " + Arrays.toString((Object[])doublelist.toArray(new Double[0])));
        }
        if (comp.getListType("doubletest") != NBTType.NBTTagDouble) {
            throw new NbtApiException("doubletest had the wrong type! The Item-NBT-API may not work!");
        }
        ReadableNBTList floatlist = comp.getFloatList("floattest");
        floatlist.add(Float.valueOf(42.23f));
        floatlist.add(Float.valueOf(69.69f));
        if (floatlist.size() != 2 || ((Float)floatlist.get(0)).floatValue() != 42.23f || ((Float)floatlist.get(1)).floatValue() != 69.69f) {
            throw new NbtApiException("FloatList is not correct! " + Arrays.toString((Object[])floatlist.toArray(new Float[0])));
        }
        if (comp.getListType("floattest") != NBTType.NBTTagFloat) {
            throw new NbtApiException("floattest had the wrong type! The Item-NBT-API may not work!");
        }
        ReadableNBTList longlist = comp.getLongList("longtest");
        longlist.add(1241234124124L);
        longlist.add(1231454321312L);
        if (longlist.size() != 2 || (Long)longlist.get(0) != 1241234124124L || (Long)longlist.get(1) != 1231454321312L) {
            throw new NbtApiException("LongList is not correct! " + Arrays.toString((Object[])longlist.toArray(new Long[0])));
        }
        if (comp.getListType("longtest") != NBTType.NBTTagLong) {
            throw new NbtApiException("longtest had the wrong type! The Item-NBT-API may not work!");
        }
        ReadableNBTList intArrayList = comp.getIntArrayList("intatest");
        intArrayList.add(new int[]{1, 2, 3});
        intArrayList.add(new int[]{4, 2, 0});
        if (intArrayList.size() != 2 || !Arrays.equals(new int[]{1, 2, 3}, (int[])intArrayList.get(0)) || !Arrays.equals(new int[]{4, 2, 0}, (int[])intArrayList.get(1))) {
            throw new NbtApiException("IntArrayList is not correct! " + intArrayList);
        }
        if (comp.getListType("intatest") != NBTType.NBTTagIntArray) {
            throw new NbtApiException("intatest had the wrong type! The Item-NBT-API may not work!");
        }
        ReadableNBTList uuidList = comp.getUUIDList("uuidtest");
        uuidList.add(UUID.fromString("fce0323d-7f50-4317-9720-5f6b14cf78ea"));
        uuidList.add(UUID.fromString("853c80ef-3c37-49fd-aa49-938b674adae6"));
        if (uuidList.size() != 2 || !UUID.fromString("fce0323d-7f50-4317-9720-5f6b14cf78ea").equals(uuidList.get(0)) || !UUID.fromString("853c80ef-3c37-49fd-aa49-938b674adae6").equals(uuidList.get(1))) {
            throw new NbtApiException("UUIDList is not correct! " + uuidList);
        }
        if (comp.getListType("uuidtest") != NBTType.NBTTagIntArray) {
            throw new NbtApiException("uuidtest had the wrong type! The Item-NBT-API may not work!");
        }
    }
}

