/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.reflection;

import fr.skytasul.reflection.ReflectionAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransparentReflectionAccessor
implements ReflectionAccessor {
    private final Map<String, MappedClassTransparent> classes = new HashMap<String, MappedClassTransparent>();

    @Override
    @NotNull
    public ReflectionAccessor.ClassAccessor getClass(@NotNull String name) throws ClassNotFoundException {
        MappedClassTransparent clazz = this.classes.get(name);
        if (clazz == null) {
            clazz = new MappedClassTransparent(Class.forName(name));
            this.classes.put(name, clazz);
        }
        return clazz;
    }

    protected Class<?>[] getClassesFromUserTypes(Type[] handles) throws ClassNotFoundException {
        Class[] array = new Class[handles.length];
        for (int i = 0; i < handles.length; ++i) {
            Class<?> type;
            Type type2 = handles[i];
            if (type2 instanceof Class) {
                Class<?> clazz;
                type = clazz = (Class<?>)type2;
            } else {
                type2 = handles[i];
                if (type2 instanceof MappedClassTransparent) {
                    MappedClassTransparent mapped = (MappedClassTransparent)type2;
                    type = mapped.getClassInstance();
                } else {
                    throw new IllegalArgumentException();
                }
            }
            array[i] = type;
        }
        return array;
    }

    private class MappedClassTransparent
    implements ReflectionAccessor.ClassAccessor {
        @NotNull
        private final Class<?> clazz;
        private final List<TransparentField> fields = new ArrayList<TransparentField>();
        private final List<TransparentMethod> methods = new ArrayList<TransparentMethod>();

        protected MappedClassTransparent(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        @NotNull
        public String getTypeName() {
            return this.clazz.getTypeName();
        }

        @Override
        @NotNull
        public Type getArrayType() {
            return this.clazz.arrayType();
        }

        @Override
        @NotNull
        public Class<?> getClassInstance() throws ClassNotFoundException {
            return this.clazz;
        }

        @Override
        @NotNull
        public ReflectionAccessor.ClassAccessor.FieldAccessor getField(@NotNull String original) throws NoSuchFieldException {
            for (TransparentField field : this.fields) {
                if (!field.field.getName().equals(original)) continue;
                return field;
            }
            TransparentField field = new TransparentField(this.clazz.getDeclaredField(original));
            this.fields.add(field);
            return field;
        }

        @Override
        @NotNull
        public ReflectionAccessor.ClassAccessor.MethodAccessor getMethod(@NotNull String original, Type ... parameterTypes) throws NoSuchMethodException, ClassNotFoundException {
            for (TransparentMethod method : this.methods) {
                if (!method.getMethodInstance().getName().equals(original) || !ReflectionAccessor.areSameParameters(parameterTypes, method.getMethodInstance().getParameterTypes())) continue;
                return method;
            }
            TransparentMethod method = new TransparentMethod(this.clazz.getDeclaredMethod(original, TransparentReflectionAccessor.this.getClassesFromUserTypes(parameterTypes)));
            this.methods.add(method);
            return method;
        }

        @Override
        @NotNull
        public ReflectionAccessor.ClassAccessor.ConstructorAccessor getConstructor(Type ... parameterTypes) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
            Constructor<?> constructor = this.clazz.getDeclaredConstructor(TransparentReflectionAccessor.this.getClassesFromUserTypes(parameterTypes));
            return new TransparentConstructor(constructor);
        }
    }

    protected static class TransparentConstructor
    implements ReflectionAccessor.ClassAccessor.ConstructorAccessor {
        @NotNull
        private final Constructor<?> constructor;

        public TransparentConstructor(@NotNull Constructor<?> constructor) {
            this.constructor = constructor;
            constructor.setAccessible(true);
        }

        @Override
        public Constructor<?> getConstructorInstance() {
            return this.constructor;
        }

        @Override
        public Object newInstance(Object ... args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.constructor.newInstance(args);
        }
    }

    protected static class TransparentMethod
    implements ReflectionAccessor.ClassAccessor.MethodAccessor {
        @NotNull
        private final Method method;

        public TransparentMethod(@NotNull Method method) {
            this.method = method;
            method.setAccessible(true);
        }

        @Override
        public Method getMethodInstance() {
            return this.method;
        }

        @Override
        public Object invoke(@Nullable Object instance, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.method.invoke(instance, args);
        }
    }

    protected static class TransparentField
    implements ReflectionAccessor.ClassAccessor.FieldAccessor {
        @NotNull
        private final Field field;

        public TransparentField(@NotNull Field field) {
            this.field = field;
            field.setAccessible(true);
        }

        @Override
        public Field getFieldInstance() {
            return this.field;
        }

        @Override
        public Object get(@Nullable Object instance) throws IllegalArgumentException, IllegalAccessException {
            return this.field.get(instance);
        }

        @Override
        public void set(@Nullable Object instance, Object value) throws IllegalArgumentException, IllegalAccessException {
            this.field.set(instance, value);
        }
    }
}

