/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.reflection.mappings;

import fr.skytasul.reflection.ReflectionAccessor;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public interface Mappings {
    public Collection<? extends ClassMapping> getClasses();

    @NotNull
    public static String getStringForMethod(@NotNull String methodName, Type ... parameterTypes) {
        return methodName + Stream.of(parameterTypes).map(Type::getTypeName).collect(Collectors.joining(", ", "(", ")"));
    }

    public static interface ClassMapping
    extends MappedObject,
    Type {
        @Override
        @NotNull
        default public String getTypeName() {
            return this.getOriginalName();
        }

        @NotNull
        default public ClassArrayType getArrayType() {
            return new ClassArrayType(this);
        }

        public Collection<? extends FieldMapping> getFields();

        public Collection<? extends MethodMapping> getMethods();

        public record ClassArrayType(@NotNull Type componentMapping) implements Type
        {
            @Override
            @NotNull
            public String getTypeName() {
                return this.componentMapping().getTypeName() + "[]";
            }
        }

        public static interface MethodMapping
        extends MappedObject {
            @NotNull
            public @NotNull Type @NotNull [] getParameterTypes();

            default public boolean isSameParameters(@NotNull @NotNull Type @NotNull [] types) {
                return ReflectionAccessor.areSameParameters(this.getParameterTypes(), types);
            }
        }

        public static interface FieldMapping
        extends MappedObject {
        }
    }

    public static interface MappedObject {
        @NotNull
        public String getOriginalName();

        @NotNull
        public String getMappedName();
    }
}

