/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz;

import fr.skytasul.glowingentities.GlowingEntities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.nagasonic.alkatraz.Metrics;
import me.nagasonic.alkatraz.commands.AlkatrazCommand;
import me.nagasonic.alkatraz.commands.SpellsCommand;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.config.ConfigUpdater;
import me.nagasonic.alkatraz.config.Configs;
import me.nagasonic.alkatraz.dom.MinecraftVersion;
import me.nagasonic.alkatraz.gui.SpellsGUI;
import me.nagasonic.alkatraz.gui.StatsGUI;
import me.nagasonic.alkatraz.items.wands.Wand;
import me.nagasonic.alkatraz.items.wands.WandListeners;
import me.nagasonic.alkatraz.items.wands.WandRegistry;
import me.nagasonic.alkatraz.nms.NMS;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.spells.SpellRegistry;
import me.nagasonic.alkatraz.util.UpdateChecker;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Alkatraz
extends JavaPlugin {
    private static GlowingEntities glowingEntities;
    private static Alkatraz instance;
    private static YamlConfiguration pluginConfig;
    private static NMS nms;
    private static boolean enabled;

    public Alkatraz() {
        instance = this;
    }

    public void onLoad() {
        pluginConfig = this.saveAndUpdateConfig("config.yml");
        this.saveConfig("playerdata/playerdata.yml");
        this.saveSpellConfigs();
        this.saveConfig("wands/wooden_wand.yml");
        if (!this.setupNMS()) {
            enabled = false;
            return;
        }
        String lang = pluginConfig.getString("language", "en-us");
    }

    public void onEnable() {
        if (((Boolean)Configs.CHECK_UPDATES.get()).booleanValue()) {
            UpdateChecker.checkUpdate();
        }
        if (!enabled) {
            Alkatraz.logSevere("This version of Minecraft is not compatible with Alkatraz.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        nms.onEnable();
        Metrics metrics = new Metrics((Plugin)this, 27657);
        glowingEntities = new GlowingEntities((Plugin)instance);
        WandRegistry.registerWands();
        SpellRegistry.registerSpells();
        this.registerListener(new WandListeners());
        this.registerListener(new DataManager());
        this.registerListener(new SpellsGUI());
        this.registerListener(new StatsGUI());
        Alkatraz.logInfo("NMS version " + nms.getClass().getSimpleName() + " registered!");
        this.getCommand("spells").setExecutor((CommandExecutor)new SpellsCommand());
        this.getCommand("alkatraz").setExecutor((CommandExecutor)new AlkatrazCommand());
        this.getCommand("alkatraz").setTabCompleter((TabCompleter)new AlkatrazCommand());
        DataManager.addManaPerSecond();
    }

    public void onDisable() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            ItemStack wand = p.getInventory().getItem(p.getInventory().getHeldItemSlot());
            if (wand == null || wand.getType() == Material.AIR || wand.getAmount() == 0 || !Wand.isWand(wand)) continue;
            WandListeners.switchFrom(p);
        }
        DataManager.saveAll();
    }

    public static Alkatraz getInstance() {
        return instance;
    }

    public static void logInfo(String message) {
        instance.getServer().getLogger().info("[Alkatraz] " + message);
    }

    public static void logWarning(String warning) {
        instance.getServer().getLogger().warning("[Alkatraz] " + warning);
    }

    public static void logFine(String warning) {
        instance.getServer().getLogger().fine("[Alkatraz] " + warning);
        Utils.sendMessage((CommandSender)instance.getServer().getConsoleSender(), "&a[Alkatraz] " + warning);
    }

    public static void logSevere(String help) {
        instance.getServer().getLogger().severe("[Alkatraz] " + help);
    }

    private void registerListener(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    private boolean setupNMS() {
        try {
            String nmsVersion = MinecraftVersion.getServerVersion().getNmsVersion();
            if (nmsVersion == null) {
                return false;
            }
            Class<?> clazz = Class.forName("me.nagasonic.alkatraz.nms.NMS_" + nmsVersion);
            if (NMS.class.isAssignableFrom(clazz)) {
                nms = (NMS)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return nms != null;
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static NMS getNms() {
        return nms;
    }

    public YamlConfiguration saveConfig(String name) {
        this.save(name);
        return ConfigManager.saveConfig(name).get();
    }

    public void save(String name) {
        File file = new File(this.getDataFolder(), name);
        if (!file.exists()) {
            this.saveResource(name, false);
        }
    }

    private void updateConfig(String name) {
        File configFile = new File(this.getDataFolder(), name);
        try {
            ConfigUpdater.update((Plugin)instance, name, configFile, new ArrayList<String>());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateConfig(String name, List<String> excludedSections) {
        File configFile = new File(this.getDataFolder(), name);
        try {
            ConfigUpdater.update((Plugin)instance, name, configFile, excludedSections);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private YamlConfiguration saveAndUpdateConfig(String config) {
        this.save(config);
        this.updateConfig(config);
        return this.saveConfig(config);
    }

    private YamlConfiguration saveAndUpdateConfig(String config, List<String> excludedSections) {
        this.save(config);
        this.updateConfig(config, excludedSections);
        return this.saveConfig(config);
    }

    public static YamlConfiguration getPluginConfig() {
        return pluginConfig;
    }

    private void saveSpellConfigs() {
        this.saveConfig("spells/magic_missile.yml");
        this.saveConfig("spells/fireball.yml");
        this.saveConfig("spells/water_sphere.yml");
        this.saveConfig("spells/air_burst.yml");
        this.saveConfig("spells/earth_throw.yml");
        this.saveConfig("spells/lesser_heal.yml");
        this.saveConfig("spells/fire_blast.yml");
        this.saveConfig("spells/detect.yml");
        this.saveConfig("spells/stealth.yml");
        this.saveConfig("spells/disguise.yml");
    }

    public static GlowingEntities getGlowingEntities() {
        return glowingEntities;
    }

    static {
        nms = null;
        enabled = true;
    }
}

