/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.nagasonic.alkatraz.dom.Permission;
import me.nagasonic.alkatraz.gui.StatsGUI;
import me.nagasonic.alkatraz.items.wands.Wand;
import me.nagasonic.alkatraz.items.wands.WandRegistry;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.playerdata.PlayerData;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.spells.SpellRegistry;
import me.nagasonic.alkatraz.util.ColorFormat;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlkatrazCommand
implements CommandExecutor,
TabCompleter {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 0) {
            sender.sendMessage(ColorFormat.format("&cPlease add an argument. e.g /alkatraz reload"));
            return true;
        }
        if (args[0].equals("discoverspell")) {
            OfflinePlayer p;
            if (!Permission.hasPermission((Permissible)sender, Permission.COMMAND_DISCOVER)) {
                sender.sendMessage(ColorFormat.format("&cYou do not have permission to use this command."));
                return true;
            }
            if (args.length < 2 || args.length > 3) {
                sender.sendMessage(ColorFormat.format("&cThere are too many/few arguments: /alkatraz discoverspell <spell> <player>"));
                return true;
            }
            Spell spell = SpellRegistry.getSpellFromName(args[1]);
            if (spell == null) {
                sender.sendMessage(ColorFormat.format("&cThere is no spell named " + args[1]));
                return true;
            }
            OfflinePlayer offlinePlayer = p = args.length == 3 ? Bukkit.getOfflinePlayer((String)args[2]) : (OfflinePlayer)sender;
            if (p == null) {
                sender.sendMessage(ColorFormat.format("&cCouldn't find a player named " + args[2] + ". Make sure they are online."));
                return true;
            }
            PlayerData data = p.isOnline() ? DataManager.getPlayerData(p) : DataManager.getConfigData(p);
            data.setDiscovered(spell, true);
            if (p.isOnline()) return true;
            DataManager.savePlayerData(p, data);
            return true;
        }
        if (args[0].equals("undiscoverspell")) {
            OfflinePlayer p;
            if (!Permission.hasPermission((Permissible)sender, Permission.COMMAND_UNDISCOVER)) {
                sender.sendMessage(ColorFormat.format("&cYou do not have permission to use this command."));
                return true;
            }
            if (args.length < 2 || args.length > 3) {
                sender.sendMessage(ColorFormat.format("&cThere are too many/few arguments: /alkatraz discoverspell <spell> <player>"));
                return true;
            }
            Spell spell = SpellRegistry.getSpellFromName(args[1]);
            if (spell == null) {
                sender.sendMessage(ColorFormat.format("&cThere is no spell named " + args[1]));
                return true;
            }
            OfflinePlayer offlinePlayer = p = args.length == 3 ? Bukkit.getOfflinePlayer((String)args[2]) : (OfflinePlayer)sender;
            if (p == null) {
                sender.sendMessage(ColorFormat.format("&cCouldn't find a player named " + args[2] + ". Make sure they are online."));
                return true;
            }
            PlayerData data = p.isOnline() ? DataManager.getPlayerData(p) : DataManager.getConfigData(p);
            data.setDiscovered(spell, false);
            if (p.isOnline()) return true;
            DataManager.savePlayerData(p, data);
            return true;
        }
        if (args[0].equals("give")) {
            Player p;
            if (!Permission.hasPermission((Permissible)sender, Permission.COMMAND_GIVE)) {
                sender.sendMessage(ColorFormat.format("&cYou do not have permission to use this command."));
                return true;
            }
            if (args.length < 2 || args.length > 3) {
                sender.sendMessage(ColorFormat.format("&cThere are too many/few arguments: /alkatraz give <item> <player>"));
                return true;
            }
            Wand wand = WandRegistry.getWand(args[1].toUpperCase());
            Player player = p = args.length == 3 ? Bukkit.getPlayer((String)args[2]) : (Player)sender;
            if (p == null) {
                sender.sendMessage(ColorFormat.format("&cCouldn't find a player named " + args[2] + ". Make sure they are online."));
                return true;
            }
            p.getInventory().addItem(new ItemStack[]{wand.getItem()});
            sender.sendMessage(ColorFormat.format("&aGave " + wand.getName() + " to " + p.getName()));
            return true;
        }
        if (args[0].equals("experience")) {
            PlayerData data;
            if (!Permission.hasPermission((Permissible)sender, Permission.COMMAND_EXPERIENCE)) {
                sender.sendMessage(ColorFormat.format("&cYou do not have permission to use this command."));
                return true;
            }
            if (args.length < 3 || args.length > 4) {
                sender.sendMessage(ColorFormat.format("&cThere are too many/few arguments: /alkatraz experience set|add <number> <player>"));
                return true;
            }
            if (args[1].equals("set")) {
                PlayerData data2;
                OfflinePlayer p = args.length == 3 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[3]);
                PlayerData playerData = data2 = p.isOnline() ? DataManager.getPlayerData(p) : DataManager.getConfigData(p);
                if (Double.parseDouble(args[2]) > (double)DataManager.requiredExperience(data2.getCircle() + 1).longValue() && data2.getCircle() < 9) {
                    sender.sendMessage("&cCannot set beyond the required experience threshold.");
                    return true;
                }
                data2.setExperience(Double.parseDouble(args[2]));
                sender.sendMessage(ColorFormat.format("&aSet magic experience of " + p.getName() + " to " + args[2]));
                return true;
            }
            if (!args[1].equals("add")) {
                sender.sendMessage(ColorFormat.format("&cPlease choose a valid operator: set/add."));
                return true;
            }
            OfflinePlayer p = args.length == 3 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[3]);
            PlayerData playerData = data = p.isOnline() ? DataManager.getPlayerData(p) : DataManager.getConfigData(p);
            if (data.getExperience() + Double.parseDouble(args[2]) < 0.0) {
                sender.sendMessage("&cCannot have negative experience, please change circle level with /alkatraz circle.");
                return true;
            }
            DataManager.addExperience(p, Double.parseDouble(args[2]));
            sender.sendMessage(ColorFormat.format("&aAdded " + args[2] + " to magic experience of " + p.getName() + ". (Total: " + data.getExperience() + ")"));
            return true;
        }
        if (args[0].equals("circle")) {
            PlayerData data;
            if (!Permission.hasPermission((Permissible)sender, Permission.COMMAND_CIRCLE)) {
                sender.sendMessage(ColorFormat.format("&cYou do not have permission to use this command."));
                return true;
            }
            if (args.length < 3 || args.length > 4) {
                sender.sendMessage(ColorFormat.format("&cThere are too many/few arguments: /alkatraz circle set|add <number> <player>"));
                return true;
            }
            if (args[1].equals("set")) {
                PlayerData data3;
                OfflinePlayer p = args.length == 3 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[3]);
                PlayerData playerData = data3 = p.isOnline() ? DataManager.getPlayerData(p) : DataManager.getConfigData(p);
                if (Integer.parseInt(args[2]) >= 0 && Integer.parseInt(args[2]) <= 9) {
                    DataManager.addCircle(p.getPlayer(), Integer.parseInt(args[2]) - data3.getCircle());
                    sender.sendMessage(ColorFormat.format("&aSet circle level of " + p.getName() + " to " + args[2]));
                    if (p.isOnline()) return true;
                    DataManager.savePlayerData(p, data3);
                    return true;
                }
                sender.sendMessage("&cCannot set beyond the circle threshold (0-9).");
                return true;
            }
            if (!args[1].equals("add")) {
                sender.sendMessage(ColorFormat.format("&cPlease choose a valid operator: set/add."));
                return true;
            }
            OfflinePlayer p = args.length == 3 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[3]);
            PlayerData playerData = data = p.isOnline() ? DataManager.getPlayerData(p) : DataManager.getConfigData(p);
            if (data.getCircle() + Integer.parseInt(args[2]) >= 0 && data.getCircle() + Integer.parseInt(args[2]) <= 9) {
                DataManager.addCircle(p.getPlayer(), Integer.parseInt(args[2]));
                sender.sendMessage(ColorFormat.format("&aAdded " + args[2] + " to circle level of " + p.getName() + ". (New: " + data.getCircle() + ")"));
                if (p.isOnline()) return true;
                DataManager.savePlayerData(p, data);
                return true;
            }
            sender.sendMessage("&cCannot add beyond the circle threshold. (0-9)");
            return true;
        }
        if (args[0].equals("mastery")) {
            if (!Permission.hasPermission((Permissible)sender, Permission.COMMAND_MASTERY)) return true;
            if (args.length < 4 || args.length > 5) {
                sender.sendMessage(ColorFormat.format("&cThere are too many/few arguments: /alkatraz mastery <spell> add|set <number> <player>"));
                return true;
            }
            Spell spell = SpellRegistry.getSpellFromName(args[1]);
            if (spell == null) {
                sender.sendMessage(ColorFormat.format("&cThere is no spell named " + args[1]));
                return true;
            }
            OfflinePlayer p = args.length == 4 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[3]);
            PlayerData data = p.isOnline() ? DataManager.getPlayerData(p) : DataManager.getConfigData(p);
            double amount = Double.parseDouble(args[3]);
            if (args[2].equals("add")) {
                if (amount + (double)data.getSpellMastery(spell) > (double)spell.getMaxMastery()) {
                    data.setSpellMastery(spell, spell.getMaxMastery());
                    sender.sendMessage(ColorFormat.format("&a" + p.getName() + "'s spell mastery of " + spell.getDisplayName() + " &ais now " + data.getSpellMastery(spell)));
                    return true;
                }
                if (amount + (double)data.getSpellMastery(spell) < 0.0) {
                    sender.sendMessage(ColorFormat.format("&cSpell Mastery cannot be less than 0."));
                    return true;
                }
                DataManager.addSpellMastery(p, spell, (int)amount);
                sender.sendMessage(ColorFormat.format("&aAdded " + amount + " to " + p.getName() + "'s mastery of " + spell.getDisplayName()));
                return true;
            }
            if (!args[2].equals("set")) return true;
            if (amount > (double)spell.getMaxMastery()) {
                data.setSpellMastery(spell, spell.getMaxMastery());
                sender.sendMessage(ColorFormat.format("&a" + p.getName() + "'s spell mastery of " + spell.getDisplayName() + " &ais now " + data.getSpellMastery(spell)));
                return true;
            }
            if (amount < 0.0) {
                sender.sendMessage(ColorFormat.format("&cSpell Mastery cannot be less than 0."));
                return true;
            }
            data.setSpellMastery(spell, (int)amount);
            sender.sendMessage(ColorFormat.format("&a" + p.getName() + "'s spell mastery of " + spell.getDisplayName() + " &ais now " + data.getSpellMastery(spell)));
            return true;
        }
        if (!args[0].equals("stats")) {
            if (!args[0].equals("reload")) return true;
            if (!Permission.hasPermission((Permissible)sender, Permission.COMMAND_RELOAD)) return true;
            if (args.length != 1) return true;
            SpellRegistry.reload();
            sender.sendMessage(ColorFormat.format("&aReloaded configs."));
            return true;
        }
        if (args.length != 1) {
            if (args.length != 2) return true;
        }
        Player p = (Player)sender;
        if (args.length != 2) {
            StatsGUI.createGUI(p, (OfflinePlayer)p);
            return true;
        }
        if (Permission.hasPermission((Permissible)p, Permission.COMMAND_STATS_OTHER)) {
            StatsGUI.createGUI(p, (OfflinePlayer)Objects.requireNonNull(Bukkit.getPlayer((String)args[1])));
            return true;
        }
        p.sendMessage(ColorFormat.format("&cYou do not have permission to see another player's stats."));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            if (Permission.hasPermission((Permissible)sender, Permission.COMMAND_DISCOVER)) {
                list.add("discoverspell");
            }
            if (Permission.hasPermission((Permissible)sender, Permission.COMMAND_UNDISCOVER)) {
                list.add("undiscoverspell");
            }
            if (Permission.hasPermission((Permissible)sender, Permission.COMMAND_GIVE)) {
                list.add("give");
            }
            if (Permission.hasPermission((Permissible)sender, Permission.COMMAND_EXPERIENCE)) {
                list.add("experience");
            }
            if (Permission.hasPermission((Permissible)sender, Permission.COMMAND_CIRCLE)) {
                list.add("circle");
            }
            if (Permission.hasPermission((Permissible)sender, Permission.COMMAND_MASTERY)) {
                list.add("mastery");
            }
            list.add("stats");
            return list;
        }
        if (args.length == 2) {
            if (args[0].equals("discoverspell") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_DISCOVER)) {
                ArrayList<String> list = new ArrayList<String>();
                for (Spell spell : SpellRegistry.getAllSpells().values()) {
                    list.add(spell.getId());
                }
                return list;
            }
            if (args[0].equals("undiscoverspell") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_UNDISCOVER)) {
                ArrayList<String> list = new ArrayList<String>();
                for (Spell spell : SpellRegistry.getAllSpells().values()) {
                    list.add(spell.getId());
                }
                return list;
            }
            if (args[0].equals("give") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_GIVE)) {
                ArrayList<String> list = new ArrayList<String>();
                for (Wand wand : WandRegistry.getAllWands().values()) {
                    list.add(wand.getId());
                }
                return list;
            }
            if (args[0].equals("experience") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_EXPERIENCE)) {
                return List.of("add", "set");
            }
            if (args[0].equals("circle") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_CIRCLE)) {
                return List.of("add", "set");
            }
            if (args[0].equals("mastery") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_MASTERY)) {
                ArrayList<String> list = new ArrayList<String>();
                for (Spell spell : SpellRegistry.getAllSpells().values()) {
                    list.add(spell.getId());
                }
                return list;
            }
            if (args[0].equals("stats") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_STATS_OTHER)) {
                ArrayList<String> list = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    list.add(p.getName());
                }
                return list;
            }
        } else if (args.length == 3) {
            if (args[0].equals("discoverspell") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_DISCOVER)) {
                ArrayList<String> list = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    list.add(p.getName());
                }
                return list;
            }
            if (args[0].equals("undiscoverspell") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_UNDISCOVER)) {
                ArrayList<String> list = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    list.add(p.getName());
                }
                return list;
            }
            if (args[0].equals("give") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_GIVE)) {
                ArrayList<String> list = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    list.add(p.getName());
                }
                return list;
            }
            if (args[0].equals("experience") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_EXPERIENCE)) {
                return List.of("");
            }
            if (args[0].equals("circle") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_CIRCLE)) {
                return List.of("");
            }
            if (args[0].equals("mastery") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_MASTERY)) {
                return List.of("set", "add");
            }
        } else if (args.length == 4) {
            if (args[0].equals("experience") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_EXPERIENCE)) {
                ArrayList<String> list = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    list.add(p.getName());
                }
                return list;
            }
            if (args[0].equals("circle") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_CIRCLE)) {
                ArrayList<String> list = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    list.add(p.getName());
                }
                return list;
            }
            if (args[0].equals("mastery") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_MASTERY)) {
                return List.of();
            }
        } else if (args.length == 5 && args[0].equals("mastery") && Permission.hasPermission((Permissible)sender, Permission.COMMAND_MASTERY)) {
            ArrayList<String> list = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                list.add(p.getName());
            }
            return list;
        }
        return List.of();
    }
}

