/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.items.wands;

import de.tr7zw.nbtapi.NBT;
import java.util.ArrayList;
import java.util.List;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.spells.Element;
import me.nagasonic.alkatraz.util.ColorFormat;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Wand
implements Listener {
    protected final String type;
    protected String id;
    protected Material material;
    protected String name;
    protected List<String> lore;
    protected double power;
    protected double castTime;
    protected double fireDamage;
    protected double airDamage;
    protected double earthDamage;
    protected double waterDamage;
    protected double lightDamage;
    protected double darkDamage;

    public Wand(String type) {
        this.type = type;
    }

    public abstract void loadConfiguration();

    public void loadCommonConfig(YamlConfiguration wandConfig) {
        this.id = wandConfig.getString("id");
        this.name = wandConfig.getString("item_name");
        this.material = Utils.materialFromString(wandConfig.getString("material"));
        this.lore = wandConfig.getStringList("lore");
        this.power = wandConfig.getDouble("power");
        this.castTime = wandConfig.getDouble("cast_time");
        this.fireDamage = wandConfig.getDouble("fire_damage");
        this.airDamage = wandConfig.getDouble("air_damage");
        this.earthDamage = wandConfig.getDouble("earth_damage");
        this.waterDamage = wandConfig.getDouble("water_damage");
        this.lightDamage = wandConfig.getDouble("light_damage");
        this.darkDamage = wandConfig.getDouble("dark_damage");
    }

    public ItemStack getItem() {
        ItemStack item = new ItemStack(this.getMaterial());
        ItemMeta meta = item.getItemMeta();
        Alkatraz.logInfo(this.getName());
        meta.setDisplayName(ColorFormat.format(this.getName()));
        ArrayList<String> lore = new ArrayList<String>();
        lore.addAll(this.getFormmattedLore());
        lore.addAll(this.createAttributeLore());
        meta.setLore(lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        this.setNBT(item);
        return item;
    }

    public List<String> getFormmattedLore() {
        List<String> lore = this.getLore();
        ArrayList<String> formattedLore = new ArrayList<String>();
        for (String str : lore) {
            formattedLore.add(ColorFormat.format(str));
        }
        return formattedLore;
    }

    private List<String> createAttributeLore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ColorFormat.format("&9Magic Power: " + this.getPower()));
        lore.add(ColorFormat.format("&9Casting Time: " + this.getCastTime()));
        if (this.getFireDamage() != 0.0) {
            lore.add(ColorFormat.format(Element.FIRE.getColor() + "Fire Damage: " + this.getFireDamage()));
        }
        if (this.getAirDamage() != 0.0) {
            lore.add(ColorFormat.format(Element.AIR.getColor() + "Air Damage: " + this.getAirDamage()));
        }
        if (this.getEarthDamage() != 0.0) {
            lore.add(ColorFormat.format(Element.EARTH.getColor() + "Earth Damage: " + this.getEarthDamage()));
        }
        if (this.getWaterDamage() != 0.0) {
            lore.add(ColorFormat.format(Element.WATER.getColor() + "Water Damage: " + this.getWaterDamage()));
        }
        if (this.getLightDamage() != 0.0) {
            lore.add(ColorFormat.format(Element.LIGHT.getColor() + "Light Damage: " + this.getLightDamage()));
        }
        if (this.getDarkDamage() != 0.0) {
            lore.add(ColorFormat.format(Element.DARK.getColor() + "Dark Damage: " + this.getDarkDamage()));
        }
        return lore;
    }

    private void setNBT(ItemStack item) {
        NBT.modify(item, nbt -> {
            nbt.setBoolean("wand", true);
            nbt.setString("cast_code", "");
            nbt.setDouble("magic_power", this.getPower());
            nbt.setDouble("casting_time", this.getCastTime());
            if (this.getFireDamage() != 0.0) {
                nbt.setDouble("fire_damage", this.getFireDamage());
            }
            if (this.getAirDamage() != 0.0) {
                nbt.setDouble("air_damage", this.getAirDamage());
            }
            if (this.getEarthDamage() != 0.0) {
                nbt.setDouble("earth_damage", this.getEarthDamage());
            }
            if (this.getWaterDamage() != 0.0) {
                nbt.setDouble("water_damage", this.getWaterDamage());
            }
            if (this.getLightDamage() != 0.0) {
                nbt.setDouble("light_damage", this.getLightDamage());
            }
            if (this.getDarkDamage() != 0.0) {
                nbt.setDouble("dark_damage", this.getDarkDamage());
            }
        });
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public double getPower() {
        return this.power;
    }

    public double getCastTime() {
        return this.castTime;
    }

    public double getFireDamage() {
        return this.fireDamage;
    }

    public double getAirDamage() {
        return this.airDamage;
    }

    public double getEarthDamage() {
        return this.earthDamage;
    }

    public double getWaterDamage() {
        return this.waterDamage;
    }

    public double getLightDamage() {
        return this.lightDamage;
    }

    public double getDarkDamage() {
        return this.darkDamage;
    }

    public static boolean isWand(ItemStack item) {
        return NBT.get(item, nbt -> nbt.getBoolean("wand"));
    }
}

