/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.nms;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.nms.NMS;
import me.nagasonic.alkatraz.util.Skin;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.RelativeMovement;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public final class NMS_v1_20_R3
implements NMS {
    @Override
    public void setInvisible(Entity target, boolean invis) {
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        if (invis) {
            livingTarget.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false, false, false));
        } else {
            livingTarget.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
    }

    @Override
    public void setTransparent(Entity e, Player target, boolean trans) {
        if (!(e instanceof Player)) {
            return;
        }
        Player entityPlayer = (Player)e;
        Scoreboard scoreboard = target.getScoreboard();
        Team team = scoreboard.getTeam(String.valueOf(e.getUniqueId()) + "_stealth");
        if (team == null) {
            team = scoreboard.registerNewTeam(String.valueOf(e.getUniqueId()) + "_stealth");
            team.setCanSeeFriendlyInvisibles(true);
        }
        if (trans) {
            team.addEntry(target.getName());
            team.addEntry(entityPlayer.getName());
        } else {
            if (team.hasEntry(target.getName())) {
                team.removeEntry(target.getName());
            }
            if (team.hasEntry(entityPlayer.getName())) {
                team.removeEntry(entityPlayer.getName());
            }
        }
    }

    @Override
    public void fakeArmor(HumanEntity e, Player target, ItemStack helmet, ItemStack chest, ItemStack legs, ItemStack boots) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)e).getHandle();
        EntityPlayer viewer = ((CraftPlayer)target).getHandle();
        ArrayList<Pair> equipmentList = new ArrayList<Pair>();
        Function<ItemStack, net.minecraft.world.item.ItemStack> toNms = item -> item != null ? CraftItemStack.asNMSCopy((ItemStack)item) : net.minecraft.world.item.ItemStack.f;
        equipmentList.add(new Pair((Object)EnumItemSlot.f, (Object)toNms.apply(helmet)));
        equipmentList.add(new Pair((Object)EnumItemSlot.e, (Object)toNms.apply(chest)));
        equipmentList.add(new Pair((Object)EnumItemSlot.d, (Object)toNms.apply(legs)));
        equipmentList.add(new Pair((Object)EnumItemSlot.c, (Object)toNms.apply(boots)));
        PacketPlayOutEntityEquipment packet = new PacketPlayOutEntityEquipment(nmsEntity.aj(), equipmentList);
        viewer.c.b((Packet)packet);
    }

    @Override
    public void fakeExp(Player player, float progress, int level, int totalExp) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        PacketPlayOutExperience packet = new PacketPlayOutExperience(progress, totalExp, level);
        nmsPlayer.c.b((Packet)packet);
    }

    @Override
    public void changeSkin(Player player, List<Player> viewers, Skin skin) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        GameProfile profile = nmsPlayer.fR();
        profile.getProperties().removeAll((Object)"textures");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", skin.getTexture(), skin.getSignature()));
        for (Player other : viewers) {
            if (other == player) continue;
            this.hideAndShow(other, player);
        }
        this.refresh(player);
    }

    public void refresh(Player player) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        this.resendInfoPackets(player, player);
        CommonPlayerSpawnInfo info = nmsPlayer.d(nmsPlayer.z());
        nmsPlayer.c.b((Packet)new PacketPlayOutRespawn(info, 0));
        Location l = player.getLocation();
        EnumSet<RelativeMovement> relative = EnumSet.noneOf(RelativeMovement.class);
        int teleportId = nmsPlayer.dM().o().ai();
        PacketPlayOutPosition pos = new PacketPlayOutPosition(l.getX(), l.getY(), l.getZ(), l.getYaw(), l.getPitch(), relative, teleportId);
        nmsPlayer.c.b((Packet)pos);
        nmsPlayer.c.b((Packet)new PacketPlayOutHeldItemSlot(player.getInventory().getHeldItemSlot()));
        ((CraftPlayer)player).updateScaledHealth();
        player.updateInventory();
    }

    public void resendInfoPackets(Player toResend, Player toSendTo) {
        EntityPlayer nmsPlayer = ((CraftPlayer)toResend).getHandle();
        EntityPlayer nmsViewer = ((CraftPlayer)toSendTo).getHandle();
        ClientboundPlayerInfoRemovePacket removePacket = new ClientboundPlayerInfoRemovePacket(Collections.singletonList(nmsPlayer.cw()));
        ClientboundPlayerInfoUpdatePacket addPacket = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.a, nmsPlayer);
        nmsViewer.c.b((Packet)removePacket);
        nmsViewer.c.b((Packet)addPacket);
    }

    private void hideAndShow(Player player, Player other) {
        try {
            player.hidePlayer((Plugin)Alkatraz.getInstance(), other);
        }
        catch (NoSuchMethodError ignored) {
            player.hidePlayer(other);
        }
        try {
            player.showPlayer((Plugin)Alkatraz.getInstance(), other);
        }
        catch (NoSuchMethodError ignored) {
            player.showPlayer(other);
        }
    }

    @Override
    public void onEnable() {
        NMS.super.onEnable();
    }
}

