/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells;

import de.tr7zw.nbtapi.NBT;
import java.util.List;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.events.PlayerCastEvent;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.playerdata.PlayerData;
import me.nagasonic.alkatraz.spells.Element;
import me.nagasonic.alkatraz.util.ColorFormat;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class Spell {
    protected final String type;
    protected String id;
    protected String displayName;
    protected List<String> description;
    protected Element element;
    protected String code;
    protected BarColor masteryBarColor;
    protected Material guiItem;
    protected int cost;
    protected double castTime;
    protected int level;
    protected boolean enabled;
    protected int maxMastery;

    public Spell(String type) {
        this.type = type;
    }

    public abstract void loadConfiguration();

    public abstract void castAction(Player var1, ItemStack var2);

    public abstract int circleAction(Player var1);

    public void cast(Player p, ItemStack wand) {
        Float castTime = this.getFullCastTime(wand, this.getCastTime());
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
        if (data.getCircle() >= this.getLevel()) {
            if (data.getMana() >= (double)this.getCost()) {
                PlayerCastEvent event;
                if (!p.isDead() && !(event = new PlayerCastEvent(p, this, wand)).isCancelled()) {
                    data.setCasting(true);
                    DataManager.subMana(p, this.getCost());
                    DataManager.addExperience((OfflinePlayer)p, Utils.getExp(this.getLevel()));
                    Utils.sendActionBar(p, ColorFormat.format("Casted: " + this.getDisplayName()));
                    int d = this.circleAction(p);
                    Float v = Float.valueOf(castTime.floatValue() * 20.0f);
                    Long finalCastTime = v.longValue();
                    if (data.getSpellMastery(this) >= this.getMaxMastery()) {
                        finalCastTime = (long)((double)castTime.floatValue() * 1.25);
                    }
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Alkatraz.getInstance(), () -> {
                        if (!event.isCancelled()) {
                            data.setCasting(false);
                            Bukkit.getServer().getScheduler().cancelTask(d);
                            this.castAction(p, wand);
                        }
                    }, finalCastTime.longValue());
                    if (data.getSpellMastery(this) < this.getMaxMastery()) {
                        DataManager.addSpellMastery((OfflinePlayer)p, this, 1);
                    }
                }
            } else {
                Utils.sendActionBar(p, "&cNot Enough Mana");
            }
        } else {
            Utils.sendActionBar(p, "&cToo low Magic Circle");
        }
    }

    public void loadCommonConfig(YamlConfiguration spellConfig) {
        this.id = spellConfig.getString("id");
        this.displayName = spellConfig.getString("display_name");
        this.description = spellConfig.getStringList("description");
        this.element = Element.valueOf(spellConfig.getString("element"));
        this.code = spellConfig.getString("code");
        this.castTime = spellConfig.getDouble("cast_time");
        this.cost = spellConfig.getInt("mana_cost");
        this.level = spellConfig.getInt("level");
        this.enabled = spellConfig.getBoolean("enabled");
        this.maxMastery = spellConfig.getInt("maximum_mastery");
        this.masteryBarColor = BarColor.valueOf((String)spellConfig.getString("mastery_bar_color"));
        this.guiItem = Material.valueOf((String)spellConfig.getString("gui_item"));
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Element getElement() {
        return this.element;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public String getCode() {
        return this.code;
    }

    public int getCost() {
        return this.cost;
    }

    public double getCastTime() {
        return this.castTime;
    }

    public int getMaxMastery() {
        return this.maxMastery;
    }

    public int getLevel() {
        return this.level;
    }

    public BarColor getMasteryBarColor() {
        return this.masteryBarColor;
    }

    public Material getGuiItem() {
        return this.guiItem;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Float getFullCastTime(ItemStack wand, Double spellCastTime) {
        Double wandCastTime = NBT.get(wand, nbt -> nbt.getDouble("casting_time"));
        Float wCastTime = Float.valueOf(wandCastTime.floatValue());
        return Float.valueOf(wCastTime.floatValue() * spellCastTime.floatValue());
    }

    public double calcDamage(double base, LivingEntity target, Player caster) {
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)caster);
        double caffinity = data.getAffinity(this.getElement());
        if (this.getElement() != Element.NONE) {
            caffinity += data.getMagicAffinity();
        }
        double tres = 0.0;
        if (target instanceof Player) {
            Player t = (Player)target;
            PlayerData tdata = DataManager.getPlayerData((OfflinePlayer)t);
            tres = tdata.getResistance(this.getElement());
            if (this.getElement() != Element.NONE) {
                tres += tdata.getMagicResistance();
            }
        } else {
            tres = Utils.getEntityResistance(this.getElement(), target);
            if (this.getElement() != Element.NONE) {
                tres += Utils.getEntityResistance(Element.NONE, target);
            }
        }
        return base * (1.0 + (caffinity - tres) / 100.0);
    }
}

