/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells.implementation;

import de.tr7zw.nbtapi.NBT;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.config.Configs;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.util.ParticleUtils;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class AirBurst
extends Spell {
    private double power;
    private int taskID;

    public AirBurst(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        Alkatraz.getInstance().save("spells/air_burst.yml");
        YamlConfiguration spellConfig = ConfigManager.getConfig("spells/air_burst.yml").get();
        this.loadCommonConfig(spellConfig);
    }

    @Override
    public void castAction(Player p, ItemStack wand) {
        if (!p.isDead()) {
            this.power = NBT.get(wand, nbt -> nbt.getDouble("magic_power"));
            AtomicInteger l = new AtomicInteger(0);
            List<Location> lineLocs = ParticleUtils.line(2.0, p.getEyeLocation(), p.getEyeLocation().add(p.getEyeLocation().getDirection().multiply(40)));
            Vector v = p.getEyeLocation().getDirection();
            float yaw = p.getEyeLocation().getYaw();
            float pitch = p.getEyeLocation().getPitch();
            this.taskID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
                if (l.get() < lineLocs.size()) {
                    Location a = null;
                    try {
                        a = (Location)lineLocs.get(l.get());
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (a != null) {
                        List<Location> locs = ParticleUtils.circle(a, 1.5, 16.0, yaw, -pitch + 90.0f);
                        for (Location loc : locs) {
                            loc.getWorld().spawnParticle(Particle.CLOUD, loc, 2, 0.0, 0.0, 0.0, 0.2);
                        }
                        for (Entity entity : a.getNearbyEntities(1.0, 1.0, 1.0)) {
                            if (entity.isDead() || entity == p || !(entity instanceof LivingEntity)) continue;
                            entity.setVelocity(v.multiply(this.calcDamage(1.5, (LivingEntity)entity, p)));
                        }
                        l.addAndGet(1);
                    }
                } else {
                    this.stopCast();
                }
            }, 0L, 1L);
        }
    }

    private void stopCast() {
        Bukkit.getServer().getScheduler().cancelTask(this.taskID);
    }

    @Override
    public int circleAction(Player p) {
        int d = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
            Location playerLoc = p.getEyeLocation();
            float yaw = playerLoc.getYaw();
            float pitch = playerLoc.getPitch();
            Vector forward = playerLoc.getDirection().normalize().multiply(1.5);
            List<Location> magicCirclePoints = ParticleUtils.magicCircle(playerLoc, yaw, pitch, forward, 2.0, 0.0);
            for (int i = 0; i < 100; ++i) {
                for (Location loc : magicCirclePoints) {
                    loc.getWorld().spawnParticle(Utils.DUST, loc, 0, (Object)new Particle.DustOptions(Color.WHITE, 0.4f));
                }
            }
        }, 0L, ((Long)Configs.CIRCLE_TICKS.get()).longValue());
        return d;
    }
}

