/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells.implementation;

import com.google.common.util.concurrent.AtomicDouble;
import fr.skytasul.glowingentities.GlowingEntities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.config.Configs;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.playerdata.PlayerData;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.util.ParticleUtils;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Detect
extends Spell {
    private Map<Integer, Double> ranges = new HashMap<Integer, Double>();
    private List<LivingEntity> entities = new ArrayList<LivingEntity>();
    private long duration;
    private int taskID;

    public Detect(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        Alkatraz.getInstance().save("spells/detect.yml");
        YamlConfiguration spellConfig = ConfigManager.getConfig("spells/detect.yml").get();
        for (int i = 2; i <= 9; ++i) {
            this.ranges.put(i, spellConfig.getDouble("range.circle_" + i));
        }
        this.duration = spellConfig.getLong("detect_duration");
        this.loadCommonConfig(spellConfig);
    }

    @Override
    public void castAction(Player p, ItemStack wand) {
        if (!p.isDead()) {
            AtomicDouble l = new AtomicDouble(1.0);
            Location a = p.getLocation();
            PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
            GlowingEntities ge = Alkatraz.getGlowingEntities();
            double range = this.ranges.get(data.getCircle());
            int r = 20;
            this.taskID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
                if (l.get() < (double)r) {
                    List<Location> locs = ParticleUtils.circle(a, l.get(), 4.0 / l.get(), 0.0f, 0.0f);
                    for (Location loc : locs) {
                        loc.getWorld().spawnParticle(Utils.DUST, loc, 0, (Object)new Particle.DustOptions(Color.WHITE, 0.4f));
                    }
                    l.addAndGet(0.5);
                    if (l.get() == (double)r / 2.0) {
                        for (Entity entity : a.getNearbyEntities(range, range, range)) {
                            if (entity.isDead() || entity == p || !(entity instanceof LivingEntity)) continue;
                            LivingEntity le = (LivingEntity)entity;
                            try {
                                ChatColor color = ChatColor.WHITE;
                                if (le instanceof Monster) {
                                    color = ChatColor.RED;
                                } else if (le instanceof Player) {
                                    color = ChatColor.YELLOW;
                                }
                                if (le instanceof Player) {
                                    Player target = (Player)le;
                                    PlayerData tdata = DataManager.getPlayerData((OfflinePlayer)target);
                                    if (data.getCircle() < tdata.getCircle()) continue;
                                    if (tdata.isStealth()) {
                                        ge.setGlowing((Entity)target, p, ChatColor.DARK_GRAY);
                                    } else {
                                        ge.setGlowing((Entity)target, p, color);
                                    }
                                    if (this.entities.contains(le)) continue;
                                    this.entities.add(le);
                                    continue;
                                }
                                ge.setGlowing((Entity)le, p, color);
                                if (this.entities.contains(le)) continue;
                                this.entities.add(le);
                            }
                            catch (ReflectiveOperationException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                } else {
                    this.stopCast();
                }
            }, 0L, 1L);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Alkatraz.getInstance(), () -> {
                for (LivingEntity le : this.entities) {
                    try {
                        ge.unsetGlowing((Entity)le, p);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, this.duration * 20L);
        }
    }

    private void stopCast() {
        Bukkit.getServer().getScheduler().cancelTask(this.taskID);
    }

    @Override
    public int circleAction(Player p) {
        int d = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
            Location playerLoc = p.getEyeLocation();
            float yaw = playerLoc.getYaw();
            float pitch = playerLoc.getPitch();
            Vector forward = playerLoc.getDirection().normalize().multiply(1.5);
            List<Location> magicCirclePoints = ParticleUtils.magicCircle(playerLoc, yaw, pitch, forward, 2.0, 0.0);
            for (int i = 0; i < 100; ++i) {
                for (Location loc : magicCirclePoints) {
                    loc.getWorld().spawnParticle(Utils.DUST, loc, 0, (Object)new Particle.DustOptions(Color.WHITE, 0.4f));
                }
            }
        }, 0L, ((Long)Configs.CIRCLE_TICKS.get()).longValue());
        return d;
    }
}

