/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells.implementation;

import de.tr7zw.nbtapi.NBT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.config.Configs;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.spells.SpellRegistry;
import me.nagasonic.alkatraz.util.ColorFormat;
import me.nagasonic.alkatraz.util.ItemUtils;
import me.nagasonic.alkatraz.util.ParticleUtils;
import me.nagasonic.alkatraz.util.Skin;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Disguise
extends Spell
implements Listener {
    private boolean selected = false;
    private Inventory gui;
    private Map<Integer, List<Player>> guiPages = new HashMap<Integer, List<Player>>();

    public Disguise(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        Alkatraz.getInstance().save("spells/disguise.yml");
        YamlConfiguration spellConfig = ConfigManager.getConfig("spells/disguise.yml").get();
        this.loadCommonConfig(spellConfig);
        Alkatraz.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Alkatraz.getInstance());
    }

    @Override
    public void castAction(Player p, ItemStack wand) {
        this.openGUI(p);
    }

    @Override
    public int circleAction(Player p) {
        int d = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
            Location playerLoc = p.getEyeLocation();
            float yaw = playerLoc.getYaw();
            float pitch = playerLoc.getPitch();
            Vector forward = playerLoc.getDirection().normalize().multiply(1.5);
            List<Location> magicCirclePoints = ParticleUtils.magicCircle(playerLoc, yaw, pitch, forward, 2.0, 0.0);
            for (int i = 0; i < 100; ++i) {
                for (Location loc : magicCirclePoints) {
                    loc.getWorld().spawnParticle(Utils.DUST, loc, 0, (Object)new Particle.DustOptions(Color.WHITE, 0.4f));
                }
            }
        }, 0L, ((Long)Configs.CIRCLE_TICKS.get()).longValue());
        return d;
    }

    public void openGUI(Player player) {
        Collection<Spell> spells = SpellRegistry.getAllSpells().values();
        int i = 1;
        int p = 1;
        int pageNumbers = (int)Math.ceil((double)spells.size() / 36.0);
        ArrayList<Player> pagePlayers = new ArrayList<Player>();
        for (Player p1 : Bukkit.getServer().getOnlinePlayers()) {
            if (i < 36) {
                pagePlayers.add(p1);
                ++i;
                continue;
            }
            this.guiPages.put(p, pagePlayers);
            i = 1;
            ++p;
            pagePlayers.clear();
        }
        this.guiPages.put(p, pagePlayers);
        this.createGUI(1, player, pageNumbers);
    }

    public void createGUI(int page, Player player, int totalPages) {
        ArrayList<String> lore;
        ItemMeta meta;
        int i;
        this.gui = Bukkit.createInventory(null, (int)54, (String)"Disguise Target");
        for (i = 0; i < 9; ++i) {
            this.gui.setItem(i, Utils.getBlank());
        }
        for (i = 45; i < 54; ++i) {
            this.gui.setItem(i, Utils.getBlank());
        }
        if (page < totalPages) {
            ItemStack next = new ItemStack(Material.ARROW);
            meta = next.getItemMeta();
            meta.setDisplayName(ColorFormat.format("&fNext Page"));
            lore = new ArrayList<String>();
            lore.add(ColorFormat.format("&ePage " + (page + 1)));
            meta.setLore(lore);
            next.setItemMeta(meta);
            NBT.modify(next, nbt -> {
                nbt.setInteger("page", page + 1);
                nbt.setString("player", player.getUniqueId().toString());
                nbt.setInteger("total_pages", totalPages);
            });
            this.gui.setItem(53, next);
        }
        if (page > 1) {
            ItemStack prev = new ItemStack(Material.ARROW);
            meta = prev.getItemMeta();
            meta.setDisplayName(ColorFormat.format("&fPrevious Page"));
            lore = new ArrayList();
            lore.add(ColorFormat.format("&ePage " + (page - 1)));
            meta.setLore(lore);
            prev.setItemMeta(meta);
            NBT.modify(prev, nbt -> {
                nbt.setInteger("page", page - 1);
                nbt.setString("player", player.getUniqueId().toString());
                nbt.setInteger("total_pages", totalPages);
            });
            this.gui.setItem(45, prev);
        }
        List<Player> players = this.guiPages.get(page);
        int s = 0;
        for (int i2 = 9; i2 < 45; ++i2) {
            if (s >= players.size()) continue;
            Player p = players.get(s);
            ItemStack item = ItemUtils.headFromUuid(p.getUniqueId().toString());
            ItemMeta meta2 = item.getItemMeta();
            meta2.setDisplayName(p.getName());
            ArrayList<String> lore2 = new ArrayList<String>();
            lore2.add(ColorFormat.format("&aClick to disguise as " + p.getName()));
            meta2.setLore(lore2);
            item.setItemMeta(meta2);
            this.gui.setItem(i2, item);
            ++s;
        }
        player.openInventory(this.gui);
    }

    @EventHandler
    private void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory().equals((Object)this.gui)) {
            e.setCancelled(true);
            ItemStack item = e.getCurrentItem();
            if (item != null && item.getType() != Material.AIR && item.getAmount() > 0) {
                ItemMeta meta = item.getItemMeta();
                if (meta.getDisplayName().equals(ColorFormat.format("&fNext Page"))) {
                    int newPage = NBT.get(item, nbt -> nbt.getInteger("page"));
                    Player p = Bukkit.getPlayer((UUID)UUID.fromString(NBT.get(item, nbt -> nbt.getString("player"))));
                    int totalPages = NBT.get(item, nbt -> nbt.getInteger("total_pages"));
                    this.createGUI(newPage, p, totalPages);
                } else if (meta.getDisplayName().equals(ColorFormat.format("&fPrevious Page"))) {
                    int newPage = NBT.get(item, nbt -> nbt.getInteger("page"));
                    Player p = Bukkit.getPlayer((UUID)UUID.fromString(NBT.get(item, nbt -> nbt.getString("player"))));
                    int totalPages = NBT.get(item, nbt -> nbt.getInteger("total_pages"));
                    this.createGUI(newPage, p, totalPages);
                } else if (item.getType().equals((Object)Material.PLAYER_HEAD)) {
                    Player target = Bukkit.getPlayer((String)meta.getDisplayName());
                    Player p = (Player)e.getView().getPlayer();
                    if (target != null) {
                        Skin skin = Skin.fromURL("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(target.getUniqueId()) + "?unsigned=false");
                        Alkatraz.getNms().changeSkin(p, List.copyOf(Bukkit.getOnlinePlayers()), skin);
                        this.selected = true;
                        p.closeInventory();
                    } else {
                        p.sendMessage(ColorFormat.format("&cCouldn't find this player. Player must be online."));
                    }
                }
            }
        }
    }

    @EventHandler
    private void onInventoryClose(InventoryCloseEvent e) {
        if (e.getInventory().equals((Object)this.gui) && !this.selected) {
            Player p = (Player)e.getPlayer();
            p.openInventory(this.gui);
        }
    }
}

