/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells.implementation;

import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.config.Configs;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.playerdata.PlayerData;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.util.ParticleUtils;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Stealth
extends Spell
implements Listener {
    private Map<Integer, Double> costs = new HashMap<Integer, Double>();
    private int taskID;

    public Stealth(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        Alkatraz.getInstance().save("spells/stealth.yml");
        YamlConfiguration spellConfig = ConfigManager.getConfig("spells/stealth.yml").get();
        for (int i = 2; i <= 9; ++i) {
            this.costs.put(i, spellConfig.getDouble("cost_over_time.circle_" + i));
        }
        this.loadCommonConfig(spellConfig);
        Alkatraz.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Alkatraz.getInstance());
    }

    @Override
    public void castAction(Player p, ItemStack wand) {
        if (!p.isDead()) {
            PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
            if (data.isStealth()) {
                data.setStealth(false);
                DataManager.addMana(p, this.getCost());
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Alkatraz.getNms().setInvisible((Entity)p, false);
                    Alkatraz.getNms().fakeArmor((HumanEntity)p, player, p.getInventory().getHelmet(), p.getInventory().getChestplate(), p.getInventory().getLeggings(), p.getInventory().getBoots());
                    Alkatraz.getNms().setTransparent((Entity)p, player, false);
                }
            } else {
                data.setStealth(true);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player != p) {
                        PlayerData td = DataManager.getPlayerData((OfflinePlayer)player);
                        if (td.getCircle() <= data.getCircle()) {
                            Alkatraz.getNms().setInvisible((Entity)p, true);
                            Alkatraz.getNms().fakeArmor((HumanEntity)p, player, null, null, null, null);
                            continue;
                        }
                        Alkatraz.getNms().setTransparent((Entity)p, player, true);
                        continue;
                    }
                    Alkatraz.getNms().setInvisible((Entity)p, true);
                    Alkatraz.getNms().fakeArmor((HumanEntity)p, player, null, null, null, null);
                }
                this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
                    if (!data.isStealth()) {
                        this.stop();
                    }
                    if (!p.isDead()) {
                        double cost = this.costs.get(data.getCircle());
                        if (data.getMana() >= cost) {
                            DataManager.subMana(p, cost);
                            for (Player player : Bukkit.getOnlinePlayers()) {
                                PlayerData td;
                                if (player == p || (td = DataManager.getPlayerData((OfflinePlayer)player)).getCircle() > data.getCircle()) continue;
                                player.spawnParticle(Particle.ASH, p.getLocation(), td.getCircle() - data.getCircle() + 11);
                            }
                        } else {
                            data.setStealth(false);
                            for (Player player : Bukkit.getOnlinePlayers()) {
                                Alkatraz.getNms().setInvisible((Entity)p, false);
                                Alkatraz.getNms().fakeArmor((HumanEntity)p, player, p.getInventory().getHelmet(), p.getInventory().getChestplate(), p.getInventory().getLeggings(), p.getInventory().getBoots());
                                Alkatraz.getNms().setTransparent((Entity)p, player, false);
                            }
                            this.stop();
                        }
                    } else {
                        data.setStealth(false);
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            Alkatraz.getNms().setInvisible((Entity)p, false);
                            Alkatraz.getNms().fakeArmor((HumanEntity)p, player, p.getInventory().getHelmet(), p.getInventory().getChestplate(), p.getInventory().getLeggings(), p.getInventory().getBoots());
                            Alkatraz.getNms().setTransparent((Entity)p, player, false);
                        }
                        this.stop();
                    }
                }, 0L, 20L);
            }
        }
    }

    @Override
    public int circleAction(Player p) {
        int d = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
            Location playerLoc = p.getEyeLocation();
            float yaw = playerLoc.getYaw();
            float pitch = playerLoc.getPitch();
            Vector forward = playerLoc.getDirection().normalize().multiply(1.5);
            List<Location> magicCirclePoints = ParticleUtils.magicCircle(playerLoc, yaw, pitch, forward, 2.0, 0.0);
            for (int i = 0; i < 100; ++i) {
                for (Location loc : magicCirclePoints) {
                    loc.getWorld().spawnParticle(Utils.DUST, loc, 0, (Object)new Particle.DustOptions(Color.GRAY, 0.4f));
                }
            }
        }, 0L, ((Long)Configs.CIRCLE_TICKS.get()).longValue());
        return d;
    }

    private void stop() {
        Bukkit.getServer().getScheduler().cancelTask(this.taskID);
    }

    @EventHandler
    private void onArmorEquip(PlayerArmorChangeEvent e) {
        Player p = e.getPlayer();
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
        if (data.isStealth()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Alkatraz.getNms().fakeArmor((HumanEntity)p, player, null, null, null, null);
            }
        }
    }

    @EventHandler
    private void onInventoryClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
        if (data.isStealth()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Alkatraz.getNms().fakeArmor((HumanEntity)p, player, null, null, null, null);
            }
        }
    }

    @EventHandler
    private void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        PlayerData td = DataManager.getPlayerData((OfflinePlayer)player);
        for (Player p : Bukkit.getOnlinePlayers()) {
            PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
            if (player != p) {
                if (td.getCircle() <= data.getCircle()) {
                    Alkatraz.getNms().setInvisible((Entity)p, true);
                    Alkatraz.getNms().fakeArmor((HumanEntity)p, player, null, null, null, null);
                    continue;
                }
                Alkatraz.getNms().setTransparent((Entity)p, player, true);
                continue;
            }
            Alkatraz.getNms().setInvisible((Entity)p, true);
            Alkatraz.getNms().fakeArmor((HumanEntity)p, player, null, null, null, null);
        }
    }
}

