/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.util;

import java.util.ArrayList;
import java.util.List;
import me.nagasonic.alkatraz.util.LocationUtils;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ParticleUtils {
    public static List<Location> line(double frequency, Location loc1, Location loc2) {
        ArrayList<Location> locs = new ArrayList<Location>();
        Location loc = loc1;
        Vector line = LocationUtils.getDirectionBetweenLocations(loc1, loc2);
        for (double i = 1.0; i <= loc1.distance(loc2); i += frequency) {
            line.multiply(i);
            loc.add(line);
            locs.add(loc.clone());
            loc.subtract(line);
            line.normalize();
        }
        return locs;
    }

    public static List<Location> circle(Location center, double radius, double frequency, float yaw, float pitch) {
        ArrayList<Location> locations = new ArrayList<Location>();
        double yawRad = Math.toRadians(-yaw);
        double pitchRad = Math.toRadians(-pitch);
        int points = (int)(360.0 / frequency);
        for (int i = 0; i < points; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)points;
            double x = Math.cos(angle) * radius;
            double y = 0.0;
            double z = Math.sin(angle) * radius;
            Vector v = new Vector(x, y, z);
            v.rotateAroundX(pitchRad);
            v.rotateAroundY(yawRad);
            Location point = center.clone().add(v);
            locations.add(point);
        }
        return locations;
    }

    public static List<Location> createHelix(Location center, int loops, double radius, double height, int pointsPerLoop) {
        ArrayList<Location> locations = new ArrayList<Location>();
        int totalPoints = loops * pointsPerLoop;
        double heightStep = height / (double)totalPoints;
        double angleStep = Math.PI * 2 / (double)pointsPerLoop;
        for (int i = 0; i < totalPoints; ++i) {
            double angle = (double)i * angleStep;
            double x = radius * Math.cos(angle);
            double z = radius * Math.sin(angle);
            double y = (double)i * heightStep;
            Location particleLocation = center.clone().add(x, y, z);
            locations.add(particleLocation);
        }
        return locations;
    }

    public static List<Location> regularPolygon(Location center, int sides, double radius, int frequency, float yaw, float pitch, float rotationOffsetDegrees) {
        int i;
        ArrayList<Location> points = new ArrayList<Location>();
        if (sides < 3) {
            sides = 3;
        }
        double angleStep = Math.PI * 2 / (double)sides;
        double rotationOffset = Math.toRadians(rotationOffsetDegrees);
        ArrayList<Vector> vertices = new ArrayList<Vector>();
        for (i = 0; i < sides; ++i) {
            double angle = (double)i * angleStep + rotationOffset;
            double x = radius * Math.cos(angle);
            double y = radius * Math.sin(angle);
            vertices.add(new Vector(x, y, 0.0));
        }
        for (i = 0; i < sides; ++i) {
            Vector start = (Vector)vertices.get(i);
            Vector end = (Vector)vertices.get((i + 1) % sides);
            for (int f = 0; f < frequency; ++f) {
                double t = (double)f / (double)frequency;
                Vector point = LocationUtils.lerp(start, end, t);
                Vector rotated = LocationUtils.rotateVector(point, yaw, pitch);
                points.add(center.clone().add(rotated));
            }
        }
        return points;
    }

    public static List<Location> basicSphere(Location center, double radius, double yawStepSize, double pitchStepSize) {
        ArrayList<Location> points = new ArrayList<Location>();
        for (double pitchDeg = 0.0; pitchDeg <= 180.0; pitchDeg += pitchStepSize) {
            double phi = Math.toRadians(pitchDeg);
            for (double yawDeg = 0.0; yawDeg < 360.0; yawDeg += yawStepSize) {
                double theta = Math.toRadians(yawDeg);
                double x = radius * Math.sin(phi) * Math.cos(theta);
                double y = radius * Math.cos(phi);
                double z = radius * Math.sin(phi) * Math.sin(theta);
                Vector offset = new Vector(x, y, z);
                points.add(center.clone().add(offset));
            }
        }
        return points;
    }

    public static List<Location> fibonacciSphere(Location center, double radius, int points) {
        ArrayList<Location> locs = new ArrayList<Location>();
        if (points < 1) {
            return locs;
        }
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        for (int i = 0; i < points; ++i) {
            double y = points == 1 ? 0.0 : 1.0 - (double)i / (double)(points - 1) * 2.0;
            double radiusAtY = Math.sqrt(1.0 - y * y);
            double theta = phi * (double)i;
            double x = Math.cos(theta) * radiusAtY;
            double z = Math.sin(theta) * radiusAtY;
            Vector point = new Vector(x, y, z).multiply(radius);
            locs.add(center.clone().add(point));
        }
        return locs;
    }

    public static List<Location> magicCircle(Location center, float yaw, float pitch, Vector offset, double size, double rotationOffsetDegrees) {
        ArrayList<Location> locs = new ArrayList<Location>();
        float newYaw = (float)((double)yaw + rotationOffsetDegrees);
        Location loc = center.clone().add(offset);
        double sizeMult = 5.0 / size;
        locs.addAll(ParticleUtils.circle(loc, 1.5 / sizeMult, 40.0, newYaw, -pitch + 90.0f));
        locs.addAll(ParticleUtils.circle(loc, 4.45 / sizeMult, 10.0, newYaw, -pitch + 90.0f));
        locs.addAll(ParticleUtils.regularPolygon(loc, 4, 3.0 / sizeMult, 10, newYaw, -pitch + 180.0f, 0.0f));
        locs.addAll(ParticleUtils.regularPolygon(loc, 4, 3.0 / sizeMult, 10, newYaw, -pitch + 180.0f, 60.0f));
        List<Location> sphereCenters = ParticleUtils.regularPolygon(loc, 6, 4.0 / sizeMult, 1, newYaw, -pitch + 180.0f, 0.0f);
        for (Location sphereCenter : sphereCenters) {
            locs.addAll(ParticleUtils.fibonacciSphere(sphereCenter, 0.25 / sizeMult, 12));
        }
        return locs;
    }
}

