/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.util;

import de.tr7zw.nbtapi.NBT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.dom.Action;
import me.nagasonic.alkatraz.dom.Catch;
import me.nagasonic.alkatraz.dom.MinecraftVersion;
import me.nagasonic.alkatraz.dom.Pair;
import me.nagasonic.alkatraz.dom.Weighted;
import me.nagasonic.alkatraz.spells.Element;
import me.nagasonic.alkatraz.util.ParticleUtils;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Utils {
    public static final Particle DUST = Particle.valueOf((String)Utils.oldOrNew("REDSTONE", "DUST"));
    private static final Random random = new Random();
    static final Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public static Random getRandom() {
        return random;
    }

    public static ItemStack getBlank() {
        ItemStack blank = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = blank.getItemMeta();
        meta.setDisplayName("");
        blank.setItemMeta(meta);
        return blank;
    }

    public static boolean withinManhattanRange(Location l1, Location l2, double range) {
        return Math.abs(l1.getX() - l2.getX()) <= range && Math.abs(l1.getY() - l2.getY()) <= range && Math.abs(l1.getZ() - l2.getZ()) <= range;
    }

    public static int getManhattanDistance(Location l1, Location l2) {
        return Math.abs(l1.getBlockX() - l2.getBlockX()) + Math.abs(l1.getBlockY() - l2.getBlockY()) + Math.abs(l1.getBlockZ() - l2.getBlockZ());
    }

    public static int getManhattanDistance(int x1, int z1, int x2, int z2) {
        return Math.abs(x1 - x2) + Math.abs(z1 - z2);
    }

    public static Map<String, OfflinePlayer> getPlayersFromUUIDs(Collection<UUID> uuids) {
        HashMap<String, OfflinePlayer> players = new HashMap<String, OfflinePlayer>();
        for (UUID uuid : uuids) {
            OfflinePlayer player = Alkatraz.getInstance().getServer().getOfflinePlayer(uuid);
            players.put(player.getName(), player);
        }
        return players;
    }

    public static Map<String, Player> getOnlinePlayersFromUUIDs(Collection<UUID> uuids) {
        HashMap<String, Player> players = new HashMap<String, Player>();
        for (UUID uuid : uuids) {
            Player player = Alkatraz.getInstance().getServer().getPlayer(uuid);
            if (player == null) continue;
            players.put(player.getName(), player);
        }
        return players;
    }

    public static Color hexToRgb(String colorStr) {
        return Color.fromRGB((int)Integer.valueOf(colorStr.substring(1, 3), 16), (int)Integer.valueOf(colorStr.substring(3, 5), 16), (int)Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    public static String rgbToHex(int r, int g, int b) {
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public static int randomAverage(double chance) {
        boolean negative = chance < 0.0;
        int atLeast = negative ? (int)Math.ceil(chance) : (int)Math.floor(chance);
        double remainingChance = chance - (double)atLeast;
        if (Utils.getRandom().nextDouble() <= Math.abs(remainingChance)) {
            atLeast += negative ? -1 : 1;
        }
        return atLeast;
    }

    public static Collection<Player> selectPlayers(CommandSender source, String selector) throws IllegalArgumentException {
        HashSet<Player> targets = new HashSet<Player>();
        if (selector.startsWith("@")) {
            for (Entity part : Bukkit.selectEntities((CommandSender)source, (String)selector)) {
                if (!(part instanceof Player)) continue;
                targets.add((Player)part);
            }
        } else {
            Player target = Alkatraz.getInstance().getServer().getPlayer(selector);
            if (target != null) {
                targets.add(target);
            }
        }
        return targets;
    }

    public static double round6Decimals(double d) {
        return (double)Math.round(d * 1000000.0) / 1000000.0;
    }

    public static double roundToMultiple(double number, double multiple) {
        return multiple * (double)Math.round(number / multiple);
    }

    public static List<String> chat(List<String> messages) {
        ArrayList<String> chat = new ArrayList<String>();
        for (String message : messages) {
            chat.add(Utils.chat(message));
        }
        return chat;
    }

    public static String chat(String message) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        return Utils.vanillaChat(message);
    }

    public static String vanillaChat(String message) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        char COLOR_CHAR = '\u00a7';
        Matcher matcher = hexPattern.matcher(message);
        StringBuilder buffer = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, COLOR_CHAR + "x" + COLOR_CHAR + group.charAt(0) + COLOR_CHAR + group.charAt(1) + COLOR_CHAR + group.charAt(2) + COLOR_CHAR + group.charAt(3) + COLOR_CHAR + group.charAt(4) + COLOR_CHAR + group.charAt(5));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.appendTail(buffer).toString());
    }

    public static <T> Map<Integer, List<T>> paginate(int pageSize, List<T> allEntries) {
        HashMap<Integer, List<T>> pages = new HashMap<Integer, List<T>>();
        int maxPages = (int)Math.ceil((double)allEntries.size() / (double)pageSize);
        for (int pageNumber = 0; pageNumber < maxPages; ++pageNumber) {
            pages.put(pageNumber, allEntries.subList(Math.min(pageNumber * pageSize, allEntries.size()), Math.min((pageNumber + 1) * pageSize, allEntries.size())));
        }
        return pages;
    }

    public static void sendMessage(CommandSender whomst, String message) {
        if (!StringUtils.isEmpty((CharSequence)message)) {
            if (message.startsWith("ACTIONBAR") && whomst instanceof Player) {
                Player p = (Player)whomst;
                Utils.sendActionBar(p, message.replaceFirst("ACTIONBAR", ""));
            } else if (message.startsWith("TITLE") && whomst instanceof Player) {
                Player p = (Player)whomst;
                String title = message.replaceFirst("TITLE", "");
                String subtitle = "";
                int titleDuration = 40;
                int fadeDuration = 5;
                String subString = StringUtils.substringBetween((String)message, (String)"TITLE(", (String)")");
                if (subString != null) {
                    String[] args = subString.split(";");
                    if (args.length > 0) {
                        title = args[0];
                    }
                    if (args.length > 1) {
                        subtitle = args[1];
                    }
                    if (args.length > 2) {
                        titleDuration = Catch.catchOrElse(() -> Integer.parseInt(args[2]), 100);
                    }
                    if (args.length > 3) {
                        fadeDuration = Catch.catchOrElse(() -> Integer.parseInt(args[2]), 10);
                    }
                }
                Utils.sendTitle(p, title, subtitle, titleDuration, fadeDuration);
            } else {
                whomst.sendMessage(Utils.chat(message));
            }
        }
    }

    public static void sendActionBar(Player whomst, String message) {
        if (!StringUtils.isEmpty((CharSequence)ChatColor.stripColor((String)Utils.chat(message)))) {
            whomst.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Utils.chat(message)));
        }
    }

    public static void sendTitle(Player whomst, String title, String subtitle, int duration, int fade) {
        if (!StringUtils.isEmpty((CharSequence)title)) {
            whomst.sendTitle(Utils.chat(title), Utils.chat(subtitle), fade, duration, fade);
        }
    }

    public static <T extends Weighted> List<T> weightedSelection(Collection<T> entries, int rolls, double luck, double fortune) {
        double totalWeight = 0.0;
        ArrayList<Weighted> selectedEntries = new ArrayList<Weighted>();
        if (entries.isEmpty()) {
            return selectedEntries;
        }
        ArrayList<Pair<Weighted, Double>> totalEntries = new ArrayList<Pair<Weighted, Double>>();
        for (Weighted entry : entries) {
            totalEntries.add(new Pair<Weighted, Double>(entry, totalWeight += entry.getWeight(luck, fortune)));
        }
        block1: for (int i = 0; i < rolls; ++i) {
            double random = Utils.getRandom().nextDouble() * totalWeight;
            for (Pair pair : totalEntries) {
                if (!((Double)pair.getTwo() >= random)) continue;
                selectedEntries.add((Weighted)pair.getOne());
                continue block1;
            }
        }
        return selectedEntries;
    }

    public static <T> T thisorDefault(T input, T def) {
        return input == null ? def : input;
    }

    public static <T> T random(Collection<T> coll) {
        int num = (int)(Math.random() * (double)coll.size());
        for (T t : coll) {
            if (--num >= 0) continue;
            return t;
        }
        throw new AssertionError();
    }

    public static void repeat(int times, Action<Integer> what) {
        for (int i = 0; i < times; ++i) {
            what.act(i);
        }
    }

    public static ScheduledExecutorService threadPool(String name, int timeoutMs, boolean daemon, int count) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(count, Utils.threadFactory(name, daemon));
        if (timeoutMs > 0) {
            executor.setKeepAliveTime(timeoutMs, TimeUnit.MILLISECONDS);
            executor.allowCoreThreadTimeOut(true);
        }
        return executor;
    }

    public static ThreadFactory threadFactory(String name, boolean daemon) {
        return r -> {
            Thread thread = new Thread(r);
            thread.setName("Alkatraz-Async-" + name + "-Thread");
            thread.setDaemon(daemon);
            return thread;
        };
    }

    public static Material materialFromString(String item) {
        ItemStack def = new ItemStack(Material.BARRIER);
        try {
            def.setType(Material.valueOf((String)item));
            return def.getType();
        }
        catch (IllegalArgumentException ignored) {
            Alkatraz.logWarning("ItemStack/Material " + item + " did not lead to an item stack or proper material type. Defaulted to BARRIER");
            return def.getType();
        }
    }

    public static boolean hasNewMappings() {
        return MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5);
    }

    public static String oldOrNew(String o, String n) {
        return Utils.hasNewMappings() ? n : o;
    }

    public static double getExp(int circle) {
        return switch (circle) {
            case 0 -> 1.0;
            case 1 -> 2.0;
            case 2 -> 4.0;
            case 3 -> 7.0;
            case 4 -> 14.0;
            case 5 -> 26.0;
            case 6 -> 50.0;
            case 7 -> 94.0;
            case 8 -> 179.0;
            case 9 -> 340.0;
            default -> 0.0;
        };
    }

    public static double getEntityAffinity(Element element, LivingEntity entity) {
        String name = element == Element.NONE ? "magic" : element.name().toLowerCase();
        if (NBT.get((Entity)entity, nbt -> nbt.getDouble(name + "_affinity")) != null) {
            return NBT.get((Entity)entity, nbt -> nbt.getDouble(name + "_affinity"));
        }
        return 0.0;
    }

    public static double getEntityResistance(Element element, LivingEntity entity) {
        String name = element == Element.NONE ? "magic" : element.name().toLowerCase();
        if (NBT.get((Entity)entity, nbt -> nbt.getDouble(name + "_resistance")) != null) {
            return NBT.get((Entity)entity, nbt -> nbt.getDouble(name + "_resistance"));
        }
        return 0.0;
    }

    public static List<Block> blocksInRadius(Location loc, double radius) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (double i = radius / 0.5; i > 0.0; i -= 0.5) {
            List<Location> locs = ParticleUtils.basicSphere(loc, radius, 10.0, 10.0);
            for (Location l : locs) {
                if (blocks.contains(l.getBlock())) continue;
                blocks.add(l.getBlock());
            }
            radius -= 0.5;
        }
        return blocks;
    }

    public static boolean notAir(ItemStack item) {
        return item != null && item.getType() != Material.AIR && item.getAmount() != 0;
    }
}

