/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.config;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.Config;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private static final Map<String, Config> configs = new HashMap<String, Config>();
    private static final Map<String, YamlConfiguration> defaultConfigs = new HashMap<String, YamlConfiguration>();
    private static final Collection<String> reloadedConfigs = new HashSet<String>();
    private static final Collection<String> fetchedConfigs = new HashSet<String>();

    public Map<String, Config> getConfigs() {
        return configs;
    }

    public static Map<String, YamlConfiguration> getDefaultConfigs() {
        return defaultConfigs;
    }

    public static Config getConfig(String name) {
        if (!configs.containsKey(name)) {
            configs.put(name, new Config(name));
            configs.get(name).reload();
        }
        return configs.get(name);
    }

    public static YamlConfiguration getDefault(String name) {
        try {
            if (!fetchedConfigs.contains(name) && !defaultConfigs.containsKey(name)) {
                fetchedConfigs.add(name);
                defaultConfigs.put(name, ConfigManager.fetchDefaultConfiguration(name));
            }
        }
        catch (FileNotFoundException e) {
            Alkatraz.logSevere("Default config " + name + " was called, but doesn't exist in plugin!");
            return null;
        }
        return defaultConfigs.get(name);
    }

    public static Config saveConfig(String name) {
        return ConfigManager.getConfig(name).save();
    }

    public static Config reloadConfig(String name) {
        return ConfigManager.getConfig(name).reload();
    }

    public static boolean doesPathExist(YamlConfiguration config, String root, String key) {
        ConfigurationSection section = config.getConfigurationSection(root);
        return section != null && section.getKeys(false).contains(key);
    }

    public static YamlConfiguration fetchDefaultConfiguration(String name) throws FileNotFoundException {
        InputStream customClassStream = ((Object)((Object)Alkatraz.getInstance())).getClass().getResourceAsStream("/" + name);
        if (customClassStream == null) {
            throw new FileNotFoundException("Config " + name + " does not exist");
        }
        InputStreamReader strR = new InputStreamReader(customClassStream);
        return YamlConfiguration.loadConfiguration((Reader)strR);
    }
}

