/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.gui;

import de.tr7zw.nbtapi.NBT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.playerdata.PlayerData;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.spells.SpellRegistry;
import me.nagasonic.alkatraz.util.ColorFormat;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpellsGUI
implements Listener {
    private static Map<Integer, List<Spell>> guiPages = new HashMap<Integer, List<Spell>>();

    public static void openGUI(Player player, OfflinePlayer target) {
        Collection<Spell> spells = SpellRegistry.getAllSpells().values();
        int i = 1;
        int p = 1;
        int pageNumbers = (int)Math.ceil((double)spells.size() / 36.0) + 2;
        ArrayList<Spell> pageSpells = new ArrayList<Spell>();
        for (Spell spell : spells) {
            if (i < 36) {
                pageSpells.add(spell);
                ++i;
                continue;
            }
            guiPages.put(p, pageSpells);
            i = 1;
            ++p;
            pageSpells.clear();
        }
        guiPages.put(p, pageSpells);
        SpellsGUI.createGui(1, player, target, pageNumbers);
    }

    private static void createGui(int page, Player p, OfflinePlayer target, int totalPages) {
        ArrayList<String> lore;
        ItemMeta meta;
        int i;
        PlayerData data = target.isOnline() ? DataManager.getPlayerData(target) : DataManager.getConfigData(target);
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)"Spells");
        for (i = 0; i < 9; ++i) {
            gui.setItem(i, Utils.getBlank());
        }
        for (i = 45; i < 54; ++i) {
            gui.setItem(i, Utils.getBlank());
        }
        if (page < totalPages) {
            ItemStack next = new ItemStack(Material.ARROW);
            meta = next.getItemMeta();
            meta.setDisplayName(ColorFormat.format("&fNext Page"));
            lore = new ArrayList<String>();
            lore.add(ColorFormat.format("&ePage " + (page + 1)));
            meta.setLore(lore);
            next.setItemMeta(meta);
            NBT.modify((ItemStack)next, nbt -> {
                nbt.setInteger("page", Integer.valueOf(page + 1));
                nbt.setString("player", p.getUniqueId().toString());
                nbt.setString("target", target.getUniqueId().toString());
                nbt.setInteger("total_pages", Integer.valueOf(totalPages));
            });
            gui.setItem(53, next);
        }
        if (page > 1) {
            ItemStack prev = new ItemStack(Material.ARROW);
            meta = prev.getItemMeta();
            meta.setDisplayName(ColorFormat.format("&fPrevious Page"));
            lore = new ArrayList();
            lore.add(ColorFormat.format("&ePage " + (page - 1)));
            meta.setLore(lore);
            prev.setItemMeta(meta);
            NBT.modify((ItemStack)prev, nbt -> {
                nbt.setInteger("page", Integer.valueOf(page - 1));
                nbt.setString("player", p.getUniqueId().toString());
                nbt.setString("target", target.getUniqueId().toString());
                nbt.setInteger("total_pages", Integer.valueOf(totalPages));
            });
            gui.setItem(45, prev);
        }
        List<Spell> spells = guiPages.get(page);
        int s = 0;
        for (int i2 = 9; i2 < 45; ++i2) {
            ItemStack item;
            if (s >= spells.size()) continue;
            Spell spell = spells.get(s);
            if (data.hasDiscovered(spell) || target.getPlayer().hasPermission("alkatraz.allspells")) {
                item = new ItemStack(spell.getGuiItem());
                meta = item.getItemMeta();
                meta.setDisplayName(ColorFormat.format(spell.getDisplayName()));
                lore = new ArrayList<String>();
                lore.add(ColorFormat.format(spell.getDescription()));
                lore.add("");
                lore.add(ColorFormat.format("&bCode: " + spell.getCode()));
                lore.add(ColorFormat.format("&bMana Cost: " + spell.getCost()));
                lore.add(ColorFormat.format("&bCast Time: " + spell.getCastTime() + "s"));
                lore.add(ColorFormat.format("&bElement: " + spell.getElement().getName()));
                lore.add(ColorFormat.format("&bMastery: " + data.getSpellMastery(spell) + "/" + spell.getMaxMastery()));
                lore.add("");
                lore.add(ColorFormat.format("&eCircle: " + spell.getLevel()));
                meta.setLore(lore);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                item.setItemMeta(meta);
            } else {
                item = new ItemStack(Material.GRAY_DYE);
                meta = item.getItemMeta();
                meta.setDisplayName(ColorFormat.format("&8???"));
                lore = new ArrayList();
                lore.add(ColorFormat.format("&7&oCircle: " + spell.getLevel()));
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            gui.setItem(i2, item);
            ++s;
        }
        p.openInventory(gui);
    }

    @EventHandler
    private void onInventoryClick(InventoryClickEvent e) {
        if (e.getView().getTitle().equals("Spells")) {
            e.setCancelled(true);
            ItemStack item = e.getCurrentItem();
            if (item != null && item.getType() != Material.AIR && item.getAmount() > 0) {
                ItemMeta meta = item.getItemMeta();
                if (meta.getDisplayName().equals(ColorFormat.format("&fNext Page"))) {
                    int newPage = (Integer)NBT.get((ItemStack)item, nbt -> nbt.getInteger("page"));
                    Player p = Bukkit.getPlayer((UUID)UUID.fromString((String)NBT.get((ItemStack)item, nbt -> nbt.getString("player"))));
                    OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString((String)NBT.get((ItemStack)item, nbt -> nbt.getString("target"))));
                    int totalPages = (Integer)NBT.get((ItemStack)item, nbt -> nbt.getInteger("total_pages"));
                    SpellsGUI.createGui(newPage, p, target, totalPages);
                } else if (meta.getDisplayName().equals(ColorFormat.format("&fPrevious Page"))) {
                    int newPage = (Integer)NBT.get((ItemStack)item, nbt -> nbt.getInteger("page"));
                    Player p = Bukkit.getPlayer((UUID)UUID.fromString((String)NBT.get((ItemStack)item, nbt -> nbt.getString("player"))));
                    OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString((String)NBT.get((ItemStack)item, nbt -> nbt.getString("target"))));
                    int totalPages = (Integer)NBT.get((ItemStack)item, nbt -> nbt.getInteger("total_pages"));
                    SpellsGUI.createGui(newPage, p, target, totalPages);
                }
            }
        }
    }
}

