/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.items.wands;

import de.tr7zw.nbtapi.NBT;
import java.util.HashMap;
import java.util.Map;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.dom.Permission;
import me.nagasonic.alkatraz.items.wands.Wand;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.playerdata.PlayerData;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.spells.SpellRegistry;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class WandListeners
implements Listener {
    private static final Map<String, Integer> level = new HashMap<String, Integer>();
    private static final Map<String, Float> exp = new HashMap<String, Float>();
    private static final Map<String, Integer> changedExp = new HashMap<String, Integer>();

    @EventHandler
    private void onClick(PlayerInteractEvent e) {
        if (e.getItem() != null && e.getItem().getType() != Material.AIR && e.getItem().getAmount() != 0 && Wand.isWand(e.getItem()) && !DataManager.getPlayerData((OfflinePlayer)e.getPlayer()).isCasting()) {
            String code = (String)NBT.get((ItemStack)e.getItem(), nbt -> nbt.getString("cast_code"));
            if (e.getAction().isRightClick()) {
                NBT.modify((ItemStack)e.getItem(), nbt -> nbt.setString("cast_code", code + "R"));
            } else if (e.getAction().isLeftClick()) {
                NBT.modify((ItemStack)e.getItem(), nbt -> nbt.setString("cast_code", code + "L"));
            }
            String code2 = (String)NBT.get((ItemStack)e.getItem(), nbt -> nbt.getString("cast_code"));
            String message = code2.replace("R", "\u25c6");
            message = message.replace("L", "\u25c8");
            message = message.replace("S", "\u2756");
            Utils.sendActionBar(e.getPlayer(), message);
            if (code2.length() >= 5) {
                Spell spell = SpellRegistry.getSpell(code2);
                if (spell != null && (DataManager.getPlayerData((OfflinePlayer)e.getPlayer()).hasDiscovered(spell) || Permission.hasPermission((Permissible)e.getPlayer(), Permission.ALL_SPELLS))) {
                    spell.cast(e.getPlayer(), e.getItem());
                }
                NBT.modify((ItemStack)e.getItem(), nbt -> nbt.setString("cast_code", ""));
            }
        }
    }

    @EventHandler
    private void onAttack(EntityDamageByEntityEvent e) {
        Player p;
        ItemStack wand;
        Entity entity = e.getDamager();
        if (entity instanceof Player && (wand = (p = (Player)entity).getItemInHand()).getType() != Material.AIR && wand.getAmount() != 0 && Wand.isWand(wand) && !DataManager.getPlayerData((OfflinePlayer)p).isCasting()) {
            String code = (String)NBT.get((ItemStack)wand, nbt -> nbt.getString("cast_code"));
            NBT.modify((ItemStack)wand, nbt -> nbt.setString("cast_code", code + "L"));
            String code2 = (String)NBT.get((ItemStack)wand, nbt -> nbt.getString("cast_code"));
            String message = code2.replace("R", "\u25c6");
            message = message.replace("L", "\u25c8");
            message = message.replace("S", "\u2756");
            Utils.sendActionBar(p, message);
            if (code2.length() >= 5) {
                Spell spell = SpellRegistry.getSpell(code2);
                if (spell != null && (DataManager.getPlayerData((OfflinePlayer)p).hasDiscovered(spell) || Permission.hasPermission((Permissible)p, Permission.ALL_SPELLS))) {
                    spell.cast(p, wand);
                }
                NBT.modify((ItemStack)wand, nbt -> nbt.setString("cast_code", ""));
            }
        }
    }

    @EventHandler
    private void onClickEntity(PlayerInteractEntityEvent e) {
        ItemStack wand = e.getPlayer().getInventory().getItem(e.getHand());
        Player p = e.getPlayer();
        if (wand.getType() != Material.AIR && wand.getAmount() != 0 && Wand.isWand(wand)) {
            e.setCancelled(true);
            if (!DataManager.getPlayerData((OfflinePlayer)p).isCasting()) {
                String code = (String)NBT.get((ItemStack)wand, nbt -> nbt.getString("cast_code"));
                NBT.modify((ItemStack)wand, nbt -> nbt.setString("cast_code", code + "R"));
                String code2 = (String)NBT.get((ItemStack)wand, nbt -> nbt.getString("cast_code"));
                String message = code2.replace("R", "\u25c6");
                message = message.replace("L", "\u25c8");
                message = message.replace("S", "\u2756");
                Utils.sendActionBar(p, message);
                if (code2.length() >= 5) {
                    Spell spell = SpellRegistry.getSpell(code2);
                    if (spell != null && (DataManager.getPlayerData((OfflinePlayer)p).hasDiscovered(spell) || Permission.hasPermission((Permissible)p, Permission.ALL_SPELLS))) {
                        spell.cast(p, wand);
                    }
                    NBT.modify((ItemStack)wand, nbt -> nbt.setString("cast_code", ""));
                }
            }
        }
    }

    @EventHandler
    private void onSwap(PlayerSwapHandItemsEvent e) {
        ItemStack wand = e.getOffHandItem();
        Player p = e.getPlayer();
        if (wand != null && wand.getType() != Material.AIR && wand.getAmount() != 0 && Wand.isWand(wand)) {
            e.setCancelled(true);
            if (!DataManager.getPlayerData((OfflinePlayer)p).isCasting()) {
                String code = (String)NBT.get((ItemStack)wand, nbt -> nbt.getString("cast_code"));
                NBT.modify((ItemStack)wand, nbt -> nbt.setString("cast_code", code + "S"));
                String code2 = (String)NBT.get((ItemStack)wand, nbt -> nbt.getString("cast_code"));
                String message = code2.replace("R", "\u25c6");
                message = message.replace("L", "\u25c8");
                message = message.replace("S", "\u2756");
                Utils.sendActionBar(p, message);
                if (code2.length() >= 5) {
                    Spell spell = SpellRegistry.getSpell(code2);
                    if (spell != null && (DataManager.getPlayerData((OfflinePlayer)p).hasDiscovered(spell) || Permission.hasPermission((Permissible)p, Permission.ALL_SPELLS))) {
                        spell.cast(p, wand);
                    }
                    NBT.modify((ItemStack)wand, nbt -> nbt.setString("cast_code", ""));
                }
                p.setItemInHand(wand);
            }
        }
    }

    @EventHandler
    private void onClickAtEntity(PlayerInteractAtEntityEvent e) {
        ItemStack wand = e.getPlayer().getInventory().getItem(e.getHand());
        if (wand.getType() != Material.AIR && wand.getAmount() != 0 && Wand.isWand(wand)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    private void onHandSwitch(PlayerItemHeldEvent e) {
        ItemStack wand = e.getPlayer().getInventory().getItem(e.getPreviousSlot());
        if (wand != null && wand.getType() != Material.AIR && wand.getAmount() != 0 && Wand.isWand(wand)) {
            NBT.modify((ItemStack)wand, nbt -> nbt.setString("cast_code", ""));
        }
    }

    @EventHandler
    private void onWand(PlayerItemHeldEvent e) {
        Player p = e.getPlayer();
        ItemStack prev = p.getInventory().getItem(e.getPreviousSlot());
        ItemStack curr = p.getInventory().getItem(e.getNewSlot());
        if (prev != null && prev.getType() != Material.AIR && prev.getAmount() != 0 && Wand.isWand(prev)) {
            WandListeners.switchFrom(p);
        }
        if (curr != null && curr.getType() != Material.AIR && curr.getAmount() != 0 && Wand.isWand(curr)) {
            WandListeners.switchTo(p);
        }
    }

    @EventHandler
    private void onInventoryClick(InventoryClickEvent e) throws InterruptedException {
        if (e.getClickedInventory() == e.getWhoClicked().getInventory()) {
            Player p = (Player)e.getWhoClicked();
            if (e.getAction() == InventoryAction.SWAP_WITH_CURSOR) {
                if (e.getSlot() == p.getInventory().getHeldItemSlot()) {
                    ItemStack curr;
                    ItemStack cursor = e.getCursor();
                    if (cursor != null && cursor.getType() != Material.AIR && cursor.getAmount() != 0 && Wand.isWand(cursor)) {
                        WandListeners.switchTo(p);
                    }
                    if ((curr = e.getCurrentItem()) != null && curr.getType() != Material.AIR && curr.getAmount() != 0 && Wand.isWand(curr)) {
                        WandListeners.switchFrom(p);
                    }
                }
            } else if (e.getAction() == InventoryAction.HOTBAR_SWAP) {
                if (e.getSlot() == p.getInventory().getHeldItemSlot()) {
                    ItemStack swapped = e.getCurrentItem();
                    ItemStack swappedWith = p.getInventory().getItem(e.getHotbarButton());
                    if (swapped != null) {
                        if (swapped.getType() != Material.AIR && swapped.getAmount() != 0) {
                            if (Wand.isWand(swapped)) {
                                if (swappedWith == null) {
                                    WandListeners.switchFrom(p);
                                } else if (!Wand.isWand(swappedWith)) {
                                    WandListeners.switchFrom(p);
                                }
                            } else if (swappedWith != null && Wand.isWand(swappedWith)) {
                                WandListeners.switchTo(p);
                            }
                        } else if (swappedWith != null && Wand.isWand(swappedWith)) {
                            WandListeners.switchTo(p);
                        }
                    } else if (swappedWith != null && Wand.isWand(swappedWith)) {
                        WandListeners.switchTo(p);
                    }
                }
            } else if (e.getAction() == InventoryAction.PICKUP_ALL || e.getAction().equals((Object)InventoryAction.PICKUP_HALF) || e.getAction().equals((Object)InventoryAction.PICKUP_ONE) || e.getAction().equals((Object)InventoryAction.PICKUP_SOME)) {
                ItemStack curr = e.getCurrentItem();
                if (curr != null && curr.getType() != Material.AIR && curr.getAmount() != 0 && Wand.isWand(curr) && e.getSlot() == p.getInventory().getHeldItemSlot()) {
                    WandListeners.switchFrom(p);
                }
            } else if (e.getAction() == InventoryAction.PLACE_ALL || e.getAction().equals((Object)InventoryAction.PLACE_ONE) || e.getAction().equals((Object)InventoryAction.PLACE_SOME)) {
                ItemStack cursor = e.getCursor();
                if (cursor != null && cursor.getType() != Material.AIR && cursor.getAmount() != 0 && Wand.isWand(cursor) && e.getSlot() == p.getInventory().getHeldItemSlot()) {
                    WandListeners.switchTo(p);
                }
            } else if (e.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                ItemStack curr;
                if (e.getSlot() >= 9) {
                    int mainSlot = p.getInventory().getHeldItemSlot();
                    if (p.getInventory().getItem(mainSlot) == null) {
                        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Alkatraz.getInstance(), () -> {
                            ItemStack wand;
                            if (mainSlot == p.getInventory().getHeldItemSlot() && p.getInventory().getItem(mainSlot) != null && (wand = p.getInventory().getItem(mainSlot)) != null && wand.getType() != Material.AIR && wand.getAmount() != 0 && Wand.isWand(wand)) {
                                WandListeners.switchTo(p);
                            }
                        }, 1L);
                    }
                } else if (e.getSlot() < 9 && (curr = e.getCurrentItem()) != null && curr.getType() != Material.AIR && curr.getAmount() != 0 && Wand.isWand(curr)) {
                    WandListeners.switchFrom(p);
                }
            }
        }
    }

    @EventHandler
    private void onDrop(PlayerDropItemEvent e) {
        Player p = e.getPlayer();
        ItemStack dropped = e.getItemDrop().getItemStack();
        ItemStack hand = p.getItemInHand();
        if (dropped.getType() != Material.AIR && dropped.getAmount() != 0) {
            if (hand.getAmount() != 0 && hand.getType() != Material.AIR) {
                if (!Wand.isWand(hand)) {
                    WandListeners.switchFrom(p);
                }
            } else if (Wand.isWand(dropped)) {
                WandListeners.switchFrom(p);
            }
        }
    }

    @EventHandler
    private void onPickup(PlayerPickupItemEvent e) {
        ItemStack item = e.getItem().getItemStack();
        Player p = e.getPlayer();
        if (item.getType() != Material.AIR && item.getAmount() != 0 && Wand.isWand(item)) {
            for (int i = 0; i <= p.getInventory().getHeldItemSlot(); ++i) {
                Alkatraz.logFine("" + i);
                ItemStack s = p.getInventory().getItem(i);
                if (s == null || s.getAmount() != 0 && s.getType() != Material.AIR) continue;
                WandListeners.switchTo(p);
                break;
            }
        }
    }

    @EventHandler
    private void onExp(PlayerExpChangeEvent e) {
        Player p = e.getPlayer();
        if (!changedExp.containsKey(p.getUniqueId().toString())) {
            changedExp.put(p.getUniqueId().toString(), e.getAmount());
        } else {
            int current = changedExp.get(p.getUniqueId().toString());
            changedExp.replace(p.getUniqueId().toString(), current + e.getAmount());
        }
        Alkatraz.logFine(String.valueOf(changedExp.get(p.getUniqueId().toString())));
    }

    @EventHandler
    private void onQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        ItemStack wand = p.getInventory().getItem(p.getInventory().getHeldItemSlot());
        if (wand != null && wand.getType() != Material.AIR && wand.getAmount() != 0 && Wand.isWand(wand)) {
            WandListeners.switchFrom(p);
        }
    }

    @EventHandler
    private void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        ItemStack wand = p.getInventory().getItem(p.getInventory().getHeldItemSlot());
        if (wand != null && wand.getType() != Material.AIR && wand.getAmount() != 0 && Wand.isWand(wand)) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Alkatraz.getInstance(), () -> WandListeners.switchTo(p), 1L);
        }
    }

    public static void resetExperience(Player p) {
        level.remove(p.getUniqueId().toString());
        exp.remove(p.getUniqueId().toString());
    }

    public static void switchTo(Player p) {
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
        if (!level.containsKey(p.getUniqueId().toString())) {
            level.put(p.getUniqueId().toString(), p.getLevel());
        } else {
            level.replace(p.getUniqueId().toString(), p.getLevel());
        }
        if (!exp.containsKey(p.getUniqueId().toString())) {
            exp.put(p.getUniqueId().toString(), Float.valueOf(p.getExp()));
        } else {
            exp.replace(p.getUniqueId().toString(), Float.valueOf(p.getExp()));
        }
        p.setLevel((int)data.getMana());
        p.setExp(Float.parseFloat(String.valueOf(data.getMana() / data.getMaxMana() - 0.01)));
    }

    public static void switchFrom(Player p) {
        if (level.containsKey(p.getUniqueId().toString())) {
            p.setLevel(level.get(p.getUniqueId().toString()).intValue());
        }
        if (exp.containsKey(p.getUniqueId().toString())) {
            p.setExp(exp.get(p.getUniqueId().toString()).floatValue());
        }
        if (changedExp.containsKey(p.getUniqueId().toString())) {
            p.giveExp(changedExp.get(p.getUniqueId().toString()).intValue());
            changedExp.remove(p.getUniqueId().toString());
        }
    }
}

