/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.playerdata;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.Configs;
import me.nagasonic.alkatraz.items.wands.Wand;
import me.nagasonic.alkatraz.playerdata.PlayerData;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.spells.SpellRegistry;
import me.nagasonic.alkatraz.spells.implementation.MagicMissile;
import me.nagasonic.alkatraz.util.ColorFormat;
import me.nagasonic.alkatraz.util.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DataManager
implements Listener {
    private static Map<String, PlayerData> playerData = new HashMap<String, PlayerData>();

    public static PlayerData getPlayerData(OfflinePlayer p) {
        if (!playerData.containsKey(p.getUniqueId().toString())) {
            PlayerData d = new PlayerData();
            playerData.put(p.getUniqueId().toString(), d);
            return d;
        }
        return playerData.get(p.getUniqueId().toString());
    }

    public static PlayerData getConfigData(OfflinePlayer p) {
        File stats;
        PlayerData data = new PlayerData();
        File f = new File(DataManager.getFolderPath(p) + "/general.yml");
        if (f.exists()) {
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
            data.setMaxMana(cfg.getDouble("stats.max_mana"));
            data.setMana(cfg.getDouble("stats.mana"));
            data.setCircle(cfg.getInt("stats.circle"));
            data.setManaRegeneration(cfg.getDouble("stats.mana_regeneration"));
            data.setExperience(cfg.getDouble("stats.experience"));
            data.setMagicAffinity(cfg.getDouble("stats.magic_affinity"));
            data.setMagicResistance(cfg.getDouble("stats.magic_resistance"));
            data.setFireAffinity(cfg.getDouble("stats.fire_affinity"));
            data.setFireResistance(cfg.getDouble("stats.fire_resistance"));
            data.setAirAffinity(cfg.getDouble("stats.air_affinity"));
            data.setAirResistance(cfg.getDouble("stats.air_resistance"));
            data.setEarthAffinity(cfg.getDouble("stats.earth_affinity"));
            data.setEarthResistance(cfg.getDouble("stats.earth_resistance"));
            data.setWaterAffinity(cfg.getDouble("stats.water_affinity"));
            data.setWaterResistance(cfg.getDouble("stats.water_resistance"));
            data.setLightAffinity(cfg.getDouble("stats.light_affinity"));
            data.setLightResistance(cfg.getDouble("stats.light_resistance"));
            data.setDarkAffinity(cfg.getDouble("stats.dark_affinity"));
            data.setDarkResistance(cfg.getDouble("stats.dark_resistance"));
            for (Spell spell : SpellRegistry.getAllSpells().values()) {
                if (!cfg.getStringList("discovered_spells").contains(spell.getType().toLowerCase())) continue;
                data.setDiscovered(spell, true);
            }
        } else {
            data.setMaxMana(100.0);
            data.setMana(100.0);
            data.setCircle(0);
            data.setManaRegeneration(1.0);
            data.setExperience(0.0);
            data.setMagicAffinity(1.0);
            data.setMagicResistance(0.0);
            data.setFireAffinity(0.0);
            data.setFireResistance(0.0);
            data.setAirAffinity(0.0);
            data.setAirResistance(0.0);
            data.setEarthAffinity(0.0);
            data.setEarthResistance(0.0);
            data.setWaterAffinity(0.0);
            data.setWaterResistance(0.0);
            data.setLightAffinity(0.0);
            data.setLightResistance(0.0);
            data.setDarkAffinity(0.0);
            data.setDarkResistance(0.0);
            data.setDiscovered(SpellRegistry.getSpell(MagicMissile.class), true);
        }
        File masteries = new File(DataManager.getFolderPath(p) + "/mastery.yml");
        if (masteries.exists()) {
            YamlConfiguration mcfg = YamlConfiguration.loadConfiguration((File)masteries);
            for (Spell spell : SpellRegistry.getAllSpells().values()) {
                if (!mcfg.contains("spell_mastery." + spell.getType().toLowerCase())) continue;
                data.setSpellMastery(spell, mcfg.getInt("spell_mastery." + spell.getType().toLowerCase()));
            }
        }
        if ((stats = new File(DataManager.getFolderPath(p) + "/stats.yml")).exists()) {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)stats);
            data.setStatPoints(yamlConfiguration.getInt("stat_points"));
            data.setStatResetTokens(yamlConfiguration.getInt("reset_tokens"));
            data.setFireStatPoints(yamlConfiguration.getInt("fire_points"));
            data.setWaterStatPoints(yamlConfiguration.getInt("water_points"));
            data.setAirStatPoints(yamlConfiguration.getInt("air_points"));
            data.setEarthStatPoints(yamlConfiguration.getInt("earth_points"));
            data.setLightStatPoints(yamlConfiguration.getInt("light_points"));
            data.setDarkStatPoints(yamlConfiguration.getInt("dark_points"));
        } else {
            data.setStatPoints((Integer)Configs.DEFAULT_STAT_POINTS.get());
            data.setStatResetTokens((Integer)Configs.DEFAULT_RESET_TOKENS.get());
            data.setFireStatPoints(0);
            data.setWaterStatPoints(0);
            data.setAirStatPoints(0);
            data.setEarthStatPoints(0);
            data.setLightStatPoints(0);
            data.setDarkStatPoints(0);
        }
        return data;
    }

    public static void setPlayerData(Player p, PlayerData data) {
        playerData.put(p.getUniqueId().toString(), data);
    }

    public static String getFolderPath(OfflinePlayer p) {
        return Bukkit.getPluginsFolder().getAbsolutePath() + "/Alkatraz/playerdata/" + p.getUniqueId();
    }

    @EventHandler
    private void onJoin(PlayerJoinEvent e) {
        PlayerData data = DataManager.getConfigData((OfflinePlayer)e.getPlayer());
        DataManager.setPlayerData(e.getPlayer(), data);
    }

    @EventHandler
    private void onQuit(PlayerQuitEvent e) {
        DataManager.savePlayerData((OfflinePlayer)e.getPlayer(), DataManager.getPlayerData((OfflinePlayer)e.getPlayer()));
        DataManager.setPlayerData(e.getPlayer(), null);
    }

    public static void addMana(Player p, double amount) {
        ItemStack item;
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
        data.setMana(data.getMana() + amount);
        if (data.getMana() > data.getMaxMana()) {
            data.setMana(data.getMaxMana());
        }
        if ((item = p.getItemInHand()).getType() != Material.AIR && item.getAmount() != 0 && Wand.isWand(item)) {
            p.setLevel((int)data.getMana());
            p.setExp(Float.parseFloat(String.valueOf(data.getMana() / data.getMaxMana() - 0.01)));
        }
    }

    public static Long requiredExperience(int circle) {
        long casts = Math.round(150.0 * Math.pow(Math.pow(5.0, 0.125), circle - 1));
        long xpPerCast = Math.round(2.0 * Math.pow(1.9, circle - 1));
        long deltaXP = casts * xpPerCast;
        return deltaXP;
    }

    public static void subMana(Player p, double amount) {
        ItemStack item;
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
        data.setMana(data.getMana() - amount);
        if (data.getMana() < 0.0) {
            data.setMana(0.0);
        }
        if ((item = p.getItemInHand()).getType() != Material.AIR && item.getAmount() != 0 && Wand.isWand(p.getItemInHand())) {
            p.setLevel((int)data.getMana());
            p.setExp(Float.parseFloat(String.valueOf(data.getMana() / data.getMaxMana() - 0.01)));
        }
    }

    public static void addManaPerSecond() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
                if (!(data.getMana() < data.getMaxMana())) continue;
                DataManager.addMana(p, data.getManaRegeneration());
            }
        }, 0L, 20L);
    }

    public static void addSpellMastery(OfflinePlayer p, Spell spell, int mastery) {
        PlayerData data;
        PlayerData playerData = data = p.isOnline() ? DataManager.getPlayerData(p) : DataManager.getConfigData(p);
        if (data.getSpellMastery(spell) == -1 && mastery > 0) {
            data.setSpellMastery(spell, 0);
        }
        if (data.getSpellMastery(spell) + mastery < 0) {
            data.setSpellMastery(spell, 0);
        } else if (data.getSpellMastery(spell) + mastery > spell.getMaxMastery()) {
            data.setSpellMastery(spell, spell.getMaxMastery());
        } else {
            data.setSpellMastery(spell, data.getSpellMastery(spell) + mastery);
        }
        if (p.isOnline()) {
            Map<Spell, BossBar> masteryBars = data.getMasteryBars();
            if (masteryBars.containsKey(spell)) {
                BossBar bar = masteryBars.get(spell);
                bar.removePlayer(p.getPlayer());
                bar.setTitle(ColorFormat.format(spell.getDisplayName() + " Mastery: " + data.getSpellMastery(spell) + "/" + spell.getMaxMastery()));
                if (data.getSpellMastery(spell) / spell.getMaxMastery() > 1) {
                    bar.setProgress(1.0);
                } else if (data.getSpellMastery(spell) / spell.getMaxMastery() < 0) {
                    bar.setProgress(0.0);
                } else {
                    bar.setProgress((double)data.getSpellMastery(spell) / (double)spell.getMaxMastery());
                }
                bar.addPlayer(p.getPlayer());
                masteryBars.replace(spell, bar);
                data.setMasteryBars(masteryBars);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Alkatraz.getInstance(), () -> {
                    if (bar.getProgress() == data.getMasteryBars().get(spell).getProgress()) {
                        bar.removePlayer(p.getPlayer());
                    }
                }, 100L);
            } else {
                BossBar bar = Bukkit.createBossBar((String)ColorFormat.format(spell.getDisplayName() + ": " + data.getSpellMastery(spell) + "/" + spell.getMaxMastery()), (BarColor)spell.getMasteryBarColor(), (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                if (data.getSpellMastery(spell) / spell.getMaxMastery() > 1) {
                    bar.setProgress(1.0);
                } else if (data.getSpellMastery(spell) / spell.getMaxMastery() < 0) {
                    bar.setProgress(0.0);
                } else {
                    bar.setProgress((double)data.getSpellMastery(spell) / (double)spell.getMaxMastery());
                }
                bar.addPlayer(p.getPlayer());
                masteryBars.put(spell, bar);
                data.setMasteryBars(masteryBars);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Alkatraz.getInstance(), () -> {
                    if (bar.getProgress() == data.getMasteryBars().get(spell).getProgress()) {
                        bar.removePlayer(p.getPlayer());
                    }
                }, 100L);
            }
        }
        if (!p.isOnline()) {
            DataManager.savePlayerData(p, data);
        }
    }

    public static void addExperience(OfflinePlayer p, double exp) {
        PlayerData data = p.isOnline() ? DataManager.getPlayerData(p) : DataManager.getConfigData(p);
        data.setExperience(data.getExperience() + exp);
        if (p.isOnline()) {
            String max;
            BossBar bar = data.getExpBar();
            String string = max = data.getCircle() < 9 ? String.valueOf(DataManager.requiredExperience(data.getCircle() + 1)) : "MAX";
            if (bar == null) {
                BossBar newbar = Bukkit.createBossBar((String)ColorFormat.format("&bMagic Experience: " + data.getExperience() + "/" + max), (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                if (data.getCircle() < 9) {
                    if (data.getExperience() / (double)DataManager.requiredExperience(data.getCircle() + 1).longValue() > 1.0) {
                        newbar.setProgress(1.0);
                    } else if (data.getExperience() / (double)DataManager.requiredExperience(data.getCircle() + 1).longValue() < 0.0) {
                        newbar.setProgress(0.0);
                    } else {
                        newbar.setProgress(data.getExperience() / (double)DataManager.requiredExperience(data.getCircle() + 1).longValue());
                    }
                } else {
                    newbar.setProgress(1.0);
                }
                newbar.addPlayer(p.getPlayer());
                data.setExpBar(newbar);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Alkatraz.getInstance(), () -> {
                    if (newbar.getProgress() == data.getExpBar().getProgress()) {
                        newbar.removePlayer(p.getPlayer());
                    }
                }, 100L);
            } else {
                bar.removePlayer(p.getPlayer());
                bar.setTitle(ColorFormat.format("&bMagic Experience: " + data.getExperience() + "/" + max));
                if (data.getCircle() < 9) {
                    if (data.getExperience() / (double)DataManager.requiredExperience(data.getCircle() + 1).longValue() > 1.0) {
                        bar.setProgress(1.0);
                    } else if (data.getExperience() / (double)DataManager.requiredExperience(data.getCircle() + 1).longValue() < 0.0) {
                        bar.setProgress(0.0);
                    } else {
                        bar.setProgress(data.getExperience() / (double)DataManager.requiredExperience(data.getCircle() + 1).longValue());
                    }
                } else {
                    bar.setProgress(1.0);
                }
                bar.addPlayer(p.getPlayer());
                data.setExpBar(bar);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Alkatraz.getInstance(), () -> {
                    if (bar.getProgress() == data.getExpBar().getProgress()) {
                        bar.removePlayer(p.getPlayer());
                    }
                }, 100L);
            }
        }
        if (data.getCircle() < 9 && data.getExperience() >= (double)DataManager.requiredExperience(data.getCircle() + 1).longValue()) {
            double experience = data.getExperience();
            data.setExperience(0.0);
            DataManager.addCircle(p.getPlayer(), 1);
            if (p.isOnline()) {
                p.getPlayer().sendMessage(new String[]{ColorFormat.format("&e&lCIRCLE UP!"), ColorFormat.format("&bReached the " + StringUtils.toOrdinal(data.getCircle()) + " circle."), ColorFormat.format("&bYou are now able to use spells up to the " + StringUtils.toOrdinal(data.getCircle()) + " rank.")});
            }
            DataManager.addExperience(p, experience - (double)DataManager.requiredExperience(data.getCircle()).longValue());
        }
        if (!p.isOnline()) {
            DataManager.savePlayerData(p, data);
        }
    }

    public static void addCircle(@NotNull Player p, int circle) {
        PlayerData data = p.isOnline() ? DataManager.getPlayerData((OfflinePlayer)p) : DataManager.getConfigData((OfflinePlayer)p);
        int pcircle = data.getCircle();
        data.setMaxMana(data.getMaxMana() + (double)(DataManager.getMaxMana(circle + data.getCircle()) - DataManager.getMaxMana(pcircle)));
        data.setManaRegeneration(data.getManaRegeneration() + (DataManager.getManaRegen(circle) - DataManager.getManaRegen(data.getCircle())));
        data.setCircle(pcircle + circle);
        if (!p.isOnline()) {
            DataManager.savePlayerData((OfflinePlayer)p, data);
        }
    }

    private static double getManaRegen(int circle) {
        return switch (circle) {
            case 0 -> 1.0;
            case 1 -> 2.0;
            case 2 -> 2.5;
            case 3 -> 3.0;
            case 4 -> 5.0;
            case 6 -> 7.5;
            case 7 -> 10.0;
            case 8 -> 12.5;
            case 9 -> 15.0;
            default -> 0.0;
        };
    }

    private static int getMaxMana(int circle) {
        return switch (circle) {
            case 0 -> 100;
            case 1 -> 200;
            case 2 -> 400;
            case 3 -> 800;
            case 4 -> 1250;
            case 5 -> 2000;
            case 6 -> 2750;
            case 7 -> 4000;
            case 8 -> 7500;
            case 9 -> 10000;
            default -> 0;
        };
    }

    public static void savePlayerData(OfflinePlayer p, PlayerData data) {
        File general = new File(DataManager.getFolderPath(p) + "/general.yml");
        YamlConfiguration gcfg = YamlConfiguration.loadConfiguration((File)general);
        gcfg.set("stats.max_mana", (Object)data.getMaxMana());
        gcfg.set("stats.mana", (Object)data.getMana());
        gcfg.set("stats.circle", (Object)data.getCircle());
        gcfg.set("stats.mana_regeneration", (Object)data.getManaRegeneration());
        gcfg.set("stats.experience", (Object)data.getExperience());
        gcfg.set("stats.magic_affinity", (Object)data.getMagicAffinity());
        gcfg.set("stats.magic_resistance", (Object)data.getMagicResistance());
        gcfg.set("stats.fire_affinity", (Object)data.getFireAffinity());
        gcfg.set("stats.fire_resistance", (Object)data.getFireResistance());
        gcfg.set("stats.air_affinity", (Object)data.getAirAffinity());
        gcfg.set("stats.air_resistance", (Object)data.getAirResistance());
        gcfg.set("stats.earth_affinity", (Object)data.getEarthAffinity());
        gcfg.set("stats.earth_resistance", (Object)data.getEarthResistance());
        gcfg.set("stats.water_affinity", (Object)data.getWaterAffinity());
        gcfg.set("stats.water_resistance", (Object)data.getWaterResistance());
        gcfg.set("stats.light_affinity", (Object)data.getLightAffinity());
        gcfg.set("stats.light_resistance", (Object)data.getLightResistance());
        gcfg.set("stats.dark_affinity", (Object)data.getDarkAffinity());
        gcfg.set("stats.dark_resistance", (Object)data.getDarkResistance());
        for (Spell spell : SpellRegistry.getAllSpells().values()) {
            if (!data.hasDiscovered(spell)) continue;
            gcfg.getStringList("discovered_spells").add(spell.getType().toLowerCase());
        }
        File masteries = new File(DataManager.getFolderPath(p) + "/mastery.yml");
        YamlConfiguration mcfg = YamlConfiguration.loadConfiguration((File)masteries);
        for (Spell spell : SpellRegistry.getAllSpells().values()) {
            if (data.getSpellMastery(spell) < 0) continue;
            mcfg.set("spell_mastery." + spell.getType().toLowerCase(), (Object)data.getSpellMastery(spell));
        }
        File stats = new File(DataManager.getFolderPath(p) + "/stats.yml");
        YamlConfiguration scfg = YamlConfiguration.loadConfiguration((File)stats);
        scfg.set("stat_points", (Object)data.getStatPoints());
        scfg.set("reset_tokens", (Object)data.getStatResetTokens());
        scfg.set("fire_points", (Object)data.getFireStatPoints());
        scfg.set("air_points", (Object)data.getAirStatPoints());
        scfg.set("water_points", (Object)data.getWaterStatPoints());
        scfg.set("earth_points", (Object)data.getEarthStatPoints());
        scfg.set("light_points", (Object)data.getLightStatPoints());
        scfg.set("dark_points", (Object)data.getDarkStatPoints());
        try {
            gcfg.save(general);
            mcfg.save(masteries);
            scfg.save(stats);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void saveAll() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            DataManager.savePlayerData((OfflinePlayer)p, DataManager.getPlayerData((OfflinePlayer)p));
        }
    }
}

