/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells.implementation;

import de.tr7zw.nbtapi.NBT;
import java.util.List;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.config.Configs;
import me.nagasonic.alkatraz.dom.Ground;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.util.ParticleUtils;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EarthThrow
extends Spell
implements Listener {
    private double baseDamage;
    private FallingBlock block;
    private double power;
    private Player caster;

    public EarthThrow(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        Alkatraz.getInstance().save("spells/earth_throw.yml");
        YamlConfiguration spellConfig = ConfigManager.getConfig("spells/earth_throw.yml").get();
        this.loadCommonConfig(spellConfig);
        this.baseDamage = spellConfig.getDouble("base_damage");
        Alkatraz.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Alkatraz.getInstance());
    }

    @Override
    public void castAction(Player p, ItemStack wand) {
        if (!p.isDead()) {
            this.caster = p;
            Location loc = p.getEyeLocation();
            Vector direction = loc.getDirection();
            if (p.isOnGround()) {
                BlockData data = Bukkit.createBlockData((Material)Ground.getGround(p.getLocation().getBlock().getBiome()));
                FallingBlock b = loc.getWorld().spawnFallingBlock(loc, data);
                b.setHurtEntities(true);
                b.setMaxDamage((int)this.baseDamage);
                b.setVelocity(direction.multiply(1).setY(0.3));
                this.block = b;
                this.power = (Double)NBT.get((ItemStack)wand, nbt -> nbt.getDouble("magic_power"));
            }
        }
    }

    @Override
    public int circleAction(Player p) {
        int d = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
            Location playerLoc = p.getEyeLocation();
            float yaw = playerLoc.getYaw();
            float pitch = playerLoc.getPitch();
            Vector forward = playerLoc.getDirection().normalize().multiply(1.5);
            List<Location> magicCirclePoints = ParticleUtils.magicCircle(playerLoc, yaw, pitch, forward, 2.0, 0.0);
            for (int i = 0; i < 100; ++i) {
                for (Location loc : magicCirclePoints) {
                    loc.getWorld().spawnParticle(Utils.DUST, loc, 0, (Object)new Particle.DustOptions(Color.fromRGB((int)78, (int)47, (int)0), 0.4f));
                }
            }
        }, 0L, ((Long)Configs.CIRCLE_TICKS.get()).longValue());
        return d;
    }

    @EventHandler
    private void onLand(EntityChangeBlockEvent e) {
        FallingBlock b;
        if (e.getEntity() instanceof FallingBlock && (b = (FallingBlock)e.getEntity()).equals(this.block)) {
            e.getBlock().setType(Material.AIR);
            Location loc = e.getBlock().getLocation();
            List<Location> locs = ParticleUtils.circle(loc, 3.0, 1.0, 0.0f, 0.0f);
            for (Location l : locs) {
                l.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, l, 5);
            }
            for (LivingEntity le : loc.getNearbyLivingEntities(3.0)) {
                le.damage(this.calcDamage(this.baseDamage * this.power, le, this.caster));
                Vector direction = le.getLocation().toVector().subtract(loc.toVector());
                direction.normalize().multiply(1);
                direction.setY(1.25);
                le.setVelocity(direction);
            }
        }
    }

    @EventHandler
    private void onDrop(EntityDropItemEvent e) {
        FallingBlock b;
        if (e.getEntity() instanceof FallingBlock && (b = (FallingBlock)e.getEntity()).equals(this.block)) {
            e.setCancelled(true);
            Location loc = b.getLocation();
            b.remove();
            List<Location> locs = ParticleUtils.circle(loc, 3.0, 1.0, 0.0f, 0.0f);
            for (Location l : locs) {
                l.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, l, 5);
            }
            for (LivingEntity le : loc.getNearbyLivingEntities(3.0)) {
                le.damage(this.calcDamage(this.baseDamage * this.power, le, this.caster));
                Vector direction = le.getLocation().toVector().subtract(loc.toVector());
                direction.normalize().multiply(1);
                direction.setY(1.25);
                le.setVelocity(direction);
            }
        }
    }
}

