/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells.implementation;

import de.tr7zw.nbtapi.NBT;
import java.util.List;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.config.Configs;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.util.ParticleUtils;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class FireBlast
extends Spell
implements Listener {
    private LargeFireball fireblast;
    private double baseDamage;
    private Player caster;
    private double power;

    public FireBlast(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        Alkatraz.getInstance().save("spells/fire_blast.yml");
        YamlConfiguration spellConfig = ConfigManager.getConfig("spells/fire_blast.yml").get();
        this.loadCommonConfig(spellConfig);
        this.baseDamage = spellConfig.getDouble("base_damage");
        Alkatraz.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Alkatraz.getInstance());
    }

    @Override
    public void castAction(Player p, ItemStack wand) {
        if (!p.isDead()) {
            this.caster = p;
            this.fireblast = (LargeFireball)p.launchProjectile(LargeFireball.class, p.getLocation().getDirection().multiply(0.5));
            this.power = (Double)NBT.get((ItemStack)wand, nbt -> nbt.getDouble("magic_power"));
        }
    }

    @Override
    public int circleAction(Player p) {
        int d = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
            Location playerLoc = p.getEyeLocation();
            float yaw = playerLoc.getYaw();
            float pitch = playerLoc.getPitch();
            Vector forward = playerLoc.getDirection().normalize().multiply(1.5);
            List<Location> magicCirclePoints = ParticleUtils.magicCircle(playerLoc, yaw, pitch, forward, 3.0, 0.0);
            for (int i = 0; i < 100; ++i) {
                for (Location loc : magicCirclePoints) {
                    loc.getWorld().spawnParticle(Utils.DUST, loc, 0, (Object)new Particle.DustOptions(Color.RED, 0.4f));
                }
            }
        }, 0L, ((Long)Configs.CIRCLE_TICKS.get()).longValue());
        return d;
    }

    @EventHandler
    private void onDamage(EntityDamageByEntityEvent e) {
        if (e != null && e.getDamager() == this.fireblast) {
            e.setDamage(this.calcDamage(this.baseDamage * this.power, (LivingEntity)e.getEntity(), this.caster));
        }
    }

    @EventHandler
    private void onHit(ProjectileHitEvent e) {
        if (e != null && e.getEntity() == this.fireblast) {
            Location loc = e.getHitBlock() != null ? e.getHitBlock().getLocation() : e.getHitEntity().getLocation();
            Alkatraz.logFine(loc.toString());
            List<Block> blocks = Utils.blocksInRadius(loc, 2.0);
            for (Block block : blocks) {
                if (block.getType() != Material.AIR) continue;
                block.setType(Material.FIRE);
            }
        }
    }
}

