/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells.implementation;

import de.tr7zw.nbtapi.NBT;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.config.Configs;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.util.ParticleUtils;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class LesserHeal
extends Spell {
    private double baseHeal;
    private double maxHeal;
    private int taskID;

    public LesserHeal(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        Alkatraz.getInstance().save("spells/lesser_heal.yml");
        YamlConfiguration spellConfig = ConfigManager.getConfig("spells/lesser_heal.yml").get();
        this.loadCommonConfig(spellConfig);
        this.baseHeal = spellConfig.getDouble("base_heal");
        this.maxHeal = spellConfig.getDouble("max_heal");
    }

    @Override
    public void castAction(Player p, ItemStack wand) {
        if (!p.isDead()) {
            if (p.isSneaking() || p.getTargetEntity(20) == null || !(p.getTargetEntity(20) instanceof Player)) {
                double wandPower = (Double)NBT.get((ItemStack)wand, nbt -> nbt.getDouble("magic_power"));
                double heal = this.baseHeal * wandPower * (1.0 + DataManager.getPlayerData((OfflinePlayer)p).getLightAffinity() / 100.0);
                if (heal > this.maxHeal) {
                    heal = this.maxHeal;
                }
                p.setHealth(p.getHealth() + heal);
                AtomicInteger l = new AtomicInteger(0);
                List<Location> locs = ParticleUtils.createHelix(p.getLocation(), 2, 0.5, 2.0, 10);
                this.taskID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
                    if (l.get() < locs.size()) {
                        Location a = null;
                        try {
                            a = (Location)locs.get(l.get());
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        if (a != null) {
                            a.getWorld().spawnParticle(Particle.TOTEM, a, 1, 0.0, 0.0, 0.0, 0.0);
                            l.addAndGet(1);
                        }
                    } else {
                        this.stopCast();
                    }
                }, 0L, 1L);
            } else {
                Player target = (Player)p.getTargetEntity(20);
                double wandPower = (Double)NBT.get((ItemStack)wand, nbt -> nbt.getDouble("magic_power"));
                double heal = this.baseHeal * wandPower * (1.0 + DataManager.getPlayerData((OfflinePlayer)p).getLightAffinity() / 100.0);
                if (heal > this.maxHeal) {
                    heal = this.maxHeal;
                }
                target.setHealth(target.getHealth() + heal);
                AtomicInteger l = new AtomicInteger(0);
                List<Location> locs = ParticleUtils.createHelix(target.getLocation(), 2, 0.5, 2.0, 10);
                this.taskID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
                    if (l.get() < locs.size()) {
                        Location a = null;
                        try {
                            a = (Location)locs.get(l.get());
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        if (a != null) {
                            a.getWorld().spawnParticle(Particle.TOTEM, a, 1, 0.0, 0.0, 0.0, 0.0);
                            l.addAndGet(1);
                        }
                    } else {
                        this.stopCast();
                    }
                }, 0L, 1L);
            }
        }
    }

    private void stopCast() {
        Bukkit.getServer().getScheduler().cancelTask(this.taskID);
    }

    @Override
    public int circleAction(Player p) {
        int d = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
            if (p.isSneaking() || p.getTargetEntity(20) == null || !(p.getTargetEntity(20) instanceof Player)) {
                Location playerLoc = p.getLocation();
                float yaw = playerLoc.getYaw();
                float pitch = 0.0f;
                List<Location> magicCirclePoints = ParticleUtils.circle(playerLoc, 1.0, 20.0, yaw, pitch);
                magicCirclePoints.add(playerLoc);
                for (int i = 0; i < magicCirclePoints.size(); ++i) {
                    for (Location loc1 : magicCirclePoints) {
                        loc1.getWorld().spawnParticle(Utils.DUST, loc1, 1, (Object)new Particle.DustOptions(Color.YELLOW, 0.4f));
                    }
                }
            } else {
                Location playerLoc = p.getTargetEntity(20).getLocation();
                float yaw = playerLoc.getYaw();
                float pitch = 0.0f;
                Vector forward = playerLoc.getDirection().normalize().multiply(1.5);
                Location loc = playerLoc.clone().add(forward);
                List<Location> magicCirclePoints = ParticleUtils.circle(loc, 1.0, 20.0, yaw, -pitch + 90.0f);
                magicCirclePoints.add(loc);
                for (int i = 0; i < magicCirclePoints.size(); ++i) {
                    for (Location loc1 : magicCirclePoints) {
                        loc1.getWorld().spawnParticle(Utils.DUST, loc1, 1, (Object)new Particle.DustOptions(Color.YELLOW, 0.4f));
                    }
                }
            }
        }, 0L, ((Long)Configs.CIRCLE_TICKS.get()).longValue());
        return d;
    }
}

