/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells.implementation;

import de.tr7zw.nbtapi.NBT;
import java.util.Iterator;
import java.util.List;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.config.Configs;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.util.ParticleUtils;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MagicMissile
extends Spell {
    private double baseDamage;

    public MagicMissile(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        Alkatraz.getInstance().save("spells/magic_missile.yml");
        YamlConfiguration spellConfig = ConfigManager.getConfig("spells/magic_missile.yml").get();
        this.loadCommonConfig(spellConfig);
        this.baseDamage = spellConfig.getDouble("base_damage");
    }

    @Override
    public void castAction(Player p, ItemStack wand) {
        if (!p.isDead()) {
            Location loc;
            Block b;
            Location loc1 = p.getEyeLocation();
            Vector direction = p.getEyeLocation().getDirection();
            Location loc2 = p.getEyeLocation().add(direction.multiply(20));
            List<Location> locs = ParticleUtils.line(0.5, loc1, loc2);
            locs.remove(0);
            locs.add(loc2);
            Iterator<Location> iterator = locs.iterator();
            while (iterator.hasNext() && ((b = (loc = iterator.next()).getBlock()).isPassable() || b.isLiquid() || !b.isCollidable() || !b.isSolid())) {
                p.spawnParticle(Particle.REDSTONE, loc, 50, (Object)new Particle.DustOptions(Color.AQUA, 0.5f));
                for (Entity entity : loc.getNearbyEntities(1.0, 1.0, 1.0)) {
                    if (entity.isDead() || entity == p) continue;
                    LivingEntity le = (LivingEntity)entity;
                    double wandPower = (Double)NBT.get((ItemStack)wand, nbt -> nbt.getDouble("power"));
                    le.damage(this.calcDamage(wandPower * this.baseDamage, le, p));
                    Vector unitVector = entity.getLocation().toVector().subtract(p.getLocation().toVector()).normalize();
                    entity.setVelocity(unitVector.multiply(1));
                }
            }
        }
    }

    @Override
    public int circleAction(Player p) {
        int d = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
            Location playerLoc = p.getEyeLocation();
            float yaw = playerLoc.getYaw();
            float pitch = playerLoc.getPitch();
            Vector forward = playerLoc.getDirection().normalize().multiply(1.5);
            Location loc = playerLoc.clone().add(forward);
            List<Location> magicCirclePoints = ParticleUtils.circle(loc, 1.0, 20.0, yaw, -pitch + 90.0f);
            magicCirclePoints.add(loc);
            for (int i = 0; i < magicCirclePoints.size(); ++i) {
                for (Location loc1 : magicCirclePoints) {
                    loc1.getWorld().spawnParticle(Utils.DUST, loc1, 0, (Object)new Particle.DustOptions(Color.AQUA, 0.4f));
                }
            }
        }, 0L, ((Long)Configs.CIRCLE_TICKS.get()).longValue());
        return d;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }
}

