/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells.implementation;

import de.tr7zw.nbtapi.NBT;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.config.Configs;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.util.ParticleUtils;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class WaterSphere
extends Spell {
    private double baseDamage;
    private int taskID;

    public WaterSphere(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        Alkatraz.getInstance().save("spells/water_sphere.yml");
        YamlConfiguration spellConfig = ConfigManager.getConfig("spells/water_sphere.yml").get();
        this.loadCommonConfig(spellConfig);
        this.baseDamage = spellConfig.getDouble("base_damage");
    }

    @Override
    public void castAction(Player p, ItemStack wand) {
        if (!p.isDead()) {
            AtomicInteger l = new AtomicInteger(0);
            List<Location> lineLocs = ParticleUtils.line(2.0, p.getEyeLocation(), p.getEyeLocation().add(p.getEyeLocation().getDirection().multiply(40)));
            this.taskID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
                if (l.get() < lineLocs.size()) {
                    Location a = null;
                    try {
                        a = (Location)lineLocs.get(l.get());
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (a != null) {
                        List<Location> locs = ParticleUtils.fibonacciSphere(a, 0.75, 48);
                        for (Location loc : locs) {
                            loc.getWorld().spawnParticle(Particle.WATER_DROP, loc, 2);
                            Block b = loc.getBlock();
                            if (b.getType() == Material.AIR || b.getType() != Material.FARMLAND) continue;
                            Farmland farm = (Farmland)b.getBlockData();
                            farm.setMoisture(farm.getMaximumMoisture());
                        }
                        for (Entity entity : a.getNearbyEntities(1.0, 1.0, 1.0)) {
                            if (entity.isDead() || entity == p || !(entity instanceof LivingEntity)) continue;
                            LivingEntity le = (LivingEntity)entity;
                            double wandPower = (Double)NBT.get((ItemStack)wand, nbt -> nbt.getDouble("magic_power"));
                            le.damage(this.calcDamage(wandPower * this.baseDamage, le, p));
                            Vector unitVector = entity.getLocation().toVector().subtract(p.getLocation().toVector()).normalize();
                            entity.setVelocity(unitVector.multiply(0.1));
                        }
                        l.addAndGet(1);
                    }
                } else {
                    this.stopCast();
                }
            }, 0L, 2L);
        }
    }

    private void stopCast() {
        Bukkit.getServer().getScheduler().cancelTask(this.taskID);
    }

    @Override
    public int circleAction(Player p) {
        int d = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
            Location playerLoc = p.getEyeLocation();
            float yaw = playerLoc.getYaw();
            float pitch = playerLoc.getPitch();
            Vector forward = playerLoc.getDirection().normalize().multiply(1.5);
            List<Location> magicCirclePoints = ParticleUtils.magicCircle(playerLoc, yaw, pitch, forward, 2.0, 0.0);
            for (int i = 0; i < 100; ++i) {
                for (Location loc : magicCirclePoints) {
                    loc.getWorld().spawnParticle(Utils.DUST, loc, 0, (Object)new Particle.DustOptions(Color.BLUE, 0.4f));
                }
            }
        }, 0L, ((Long)Configs.CIRCLE_TICKS.get()).longValue());
        return d;
    }
}

