/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.regex.Pattern;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.ChatColor;

public class StringUtils {
    private static final TreeMap<Integer, String> romanNumeralsMap = new TreeMap();
    static final Pattern hexPattern;

    public static String toPascalCase(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return s;
        }
        String allLowercase = s.toLowerCase(Locale.US);
        char c = allLowercase.charAt(0);
        return allLowercase.replaceFirst("" + c, "" + Character.toUpperCase(c));
    }

    public static String toRoman(int number) {
        if (number < 0) {
            return "-" + StringUtils.toRoman(-number);
        }
        if (number == 0) {
            return "0";
        }
        if (number == 1) {
            return "I";
        }
        int l = romanNumeralsMap.floorKey(number);
        if (number == l) {
            return romanNumeralsMap.get(number);
        }
        return romanNumeralsMap.get(l) + StringUtils.toRoman(number - l);
    }

    public static Double parseDouble(String s) throws NumberFormatException {
        return Double.parseDouble(s.replace(",", "."));
    }

    public static Float parseFloat(String s) throws NumberFormatException {
        return Float.valueOf(Float.parseFloat(s.replace(",", ".")));
    }

    public static String toTimeStamp(long ticks, long base) {
        if (ticks == 0L) {
            return "0:00";
        }
        if (ticks < 0L) {
            return "\u221e";
        }
        int hours = (int)Math.floor((double)ticks / (3600.0 * (double)base));
        String hrs = "" + hours;
        int minutes = (int)Math.floor((double)(ticks %= base * 3600L) / (60.0 * (double)base));
        String mins = (hours > 0 ? "0" : "") + minutes;
        int seconds = (int)Math.floor((double)(ticks %= base * 60L) / (double)base);
        String secs = (seconds > 9 ? "" : "0") + seconds;
        return hours > 0 ? String.format("%s:%s:%s", hrs, mins, secs) : String.format("%s:%s", mins, secs);
    }

    public static String toTimeStamp2(long ticks, long base) {
        return StringUtils.toTimeStamp2(ticks, base, true);
    }

    public static String toTimeStamp2(long ticks, long base, boolean decimal) {
        double seconds;
        if (ticks < 0L) {
            return "\u221e";
        }
        int days = (int)Math.floor((double)ticks / (86400.0 * (double)base));
        int hours = (int)Math.floor((double)(ticks %= base * 86400L) / (3600.0 * (double)base));
        int minutes = (int)Math.floor((double)(ticks %= base * 3600L) / (60.0 * (double)base));
        double d = seconds = decimal ? (double)ticks / (double)base : (double)((int)Math.floor((double)(ticks %= base * 60L) / (double)base));
        String format = days > 0 ? "%days%d, %hours%d" : (hours > 0 ? "%hours%h, %minutes%m" : (minutes > 0 ? "%minutes%m, %seconds%s" : "%seconds%s"));
        return format.replace("%days%", "" + days).replace("%hours%", "" + hours).replace("%minutes%", "" + minutes).replace("%seconds%", String.format("%." + (decimal ? 1 : 0) + "f", seconds));
    }

    public static List<String> separateStringIntoLines(String string, int maxLength) {
        String[] byNewLines;
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : byNewLines = string.split("/n")) {
            String[] words = line.split(" ");
            StringBuilder sentence = new StringBuilder(words[0]);
            for (String word : Arrays.copyOfRange(words, 1, words.length)) {
                String rawWord = net.md_5.bungee.api.ChatColor.stripColor((String)Utils.chat(word.replaceAll(hexPattern.pattern(), "")));
                String rawSentence = net.md_5.bungee.api.ChatColor.stripColor((String)Utils.chat(sentence.toString().replaceAll(hexPattern.pattern(), "")));
                if (rawSentence.length() + rawWord.length() > maxLength) {
                    lines.add(sentence.toString());
                    String previousSentence = sentence.toString();
                    sentence = new StringBuilder(Utils.vanillaChat(ChatColor.getLastColors((String)Utils.vanillaChat(previousSentence)))).append(word);
                    continue;
                }
                sentence.append(" ").append(word);
            }
            lines.add(sentence.toString());
        }
        return lines;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String trimTrailingZeroes(String s) {
        return !s.contains(".") ? s : s.replaceAll("0*$", "").replaceAll("\\.$", "");
    }

    public static String toOrdinal(int number) {
        int abs = Math.abs(number);
        int mod100 = abs % 100;
        if (mod100 >= 11 && mod100 <= 13) {
            return number + "th";
        }
        return switch (abs % 10) {
            case 1 -> number + "st";
            case 2 -> number + "nd";
            case 3 -> number + "rd";
            default -> number + "th";
        };
    }

    static {
        romanNumeralsMap.put(1000, "M");
        romanNumeralsMap.put(900, "CM");
        romanNumeralsMap.put(500, "D");
        romanNumeralsMap.put(400, "CD");
        romanNumeralsMap.put(100, "C");
        romanNumeralsMap.put(90, "XC");
        romanNumeralsMap.put(50, "L");
        romanNumeralsMap.put(40, "XL");
        romanNumeralsMap.put(10, "X");
        romanNumeralsMap.put(9, "IX");
        romanNumeralsMap.put(5, "V");
        romanNumeralsMap.put(4, "IV");
        romanNumeralsMap.put(1, "I");
        hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
    }
}

