/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Consumer;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private static void getVersion(Consumer<String> consumer) {
        try {
            URL url = new URL("https://api.modrinth.com/v3/project/Alkatraz/version");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            JsonArray jsonArray = (JsonArray)new Gson().fromJson((Reader)reader, JsonArray.class);
            JsonObject jsonObject = jsonArray.get(0).getAsJsonObject();
            String tag_name = jsonObject.get("version_number").getAsString();
            consumer.accept(tag_name);
        }
        catch (IOException e) {
            if (Alkatraz.getPluginConfig().getBoolean("debug")) {
                Alkatraz.getInstance().getLogger().info("Checking for updates failed:" + e.getMessage());
            }
            Alkatraz.getInstance().getLogger().info("Checking for updates failed");
        }
    }

    public static void checkUpdate() {
        UpdateChecker.getVersion(v -> {
            if (!Alkatraz.getInstance().getDescription().getVersion().equals(v)) {
                Bukkit.getScheduler().runTask((Plugin)Alkatraz.getInstance(), () -> {
                    Alkatraz.logWarning("There is a new version of Alkatraz available: " + v);
                    Alkatraz.logWarning("Please don't forget to look at the change log, the update may have important changes that require additional steps to work.");
                    Alkatraz.logWarning("");
                });
                Bukkit.getPluginManager().registerEvents(new Listener((String)v){
                    private final Collection<UUID> messagedOperators = new HashSet<UUID>();
                    final /* synthetic */ String val$v;
                    {
                        this.val$v = string;
                    }

                    @EventHandler
                    public void onOperatorJoin(PlayerJoinEvent e) {
                        if (!e.getPlayer().isOp() || this.messagedOperators.contains(e.getPlayer().getUniqueId())) {
                            return;
                        }
                        this.messagedOperators.add(e.getPlayer().getUniqueId());
                        e.getPlayer().sendMessage(new String[]{Utils.chat("&dA new version of Alkatraz is available: " + this.val$v), Utils.chat("&dI recommend you take a look at the update notes"), Utils.chat("&dto see the importance of this update."), Utils.chat("&5")});
                    }
                }, (Plugin)Alkatraz.getInstance());
            }
        });
    }
}

