/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.nagasonic.alkatraz.commands.AlkatrazCommand;
import me.nagasonic.alkatraz.commands.SpellsCommand;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.config.ConfigUpdater;
import me.nagasonic.alkatraz.gui.SpellsGUI;
import me.nagasonic.alkatraz.items.wands.Wand;
import me.nagasonic.alkatraz.items.wands.WandListeners;
import me.nagasonic.alkatraz.items.wands.WandRegistry;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.spells.SpellRegistry;
import me.nagasonic.alkatraz.util.UpdateChecker;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Alkatraz
extends JavaPlugin {
    private static Alkatraz instance;
    private static YamlConfiguration pluginConfig;

    public Alkatraz() {
        instance = this;
    }

    public void onLoad() {
        pluginConfig = this.saveAndUpdateConfig("config.yml");
        this.saveConfig("playerdata/playerdata.yml");
        this.saveConfig("spells/magic_missile.yml");
        this.saveConfig("spells/fireball.yml");
        this.saveConfig("spells/water_sphere.yml");
        this.saveConfig("wands/wooden_wand.yml");
        String lang = pluginConfig.getString("language", "en-us");
    }

    public void onEnable() {
        if (pluginConfig.getBoolean("check_updates")) {
            UpdateChecker.checkUpdate();
        }
        WandRegistry.registerWands();
        SpellRegistry.registerSpells();
        this.registerListener(new WandListeners());
        this.registerListener(new DataManager());
        this.registerListener(new SpellsGUI());
        this.getCommand("spells").setExecutor((CommandExecutor)new SpellsCommand());
        this.getCommand("alkatraz").setExecutor((CommandExecutor)new AlkatrazCommand());
        this.getCommand("alkatraz").setTabCompleter((TabCompleter)new AlkatrazCommand());
        DataManager.addManaPerSecond();
    }

    public void onDisable() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            ItemStack wand = p.getInventory().getItem(p.getInventory().getHeldItemSlot());
            if (wand == null || wand.getType() == Material.AIR || wand.getAmount() == 0 || !Wand.isWand(wand)) continue;
            WandListeners.switchFrom(p);
        }
        DataManager.saveAll();
    }

    public static Alkatraz getInstance() {
        return instance;
    }

    public static void logInfo(String message) {
        instance.getServer().getLogger().info("[Alkatraz] " + message);
    }

    public static void logWarning(String warning) {
        instance.getServer().getLogger().warning("[Alkatraz] " + warning);
    }

    public static void logFine(String warning) {
        instance.getServer().getLogger().fine("[Alkatraz] " + warning);
        Utils.sendMessage((CommandSender)instance.getServer().getConsoleSender(), "&a[Alkatraz] " + warning);
    }

    public static void logSevere(String help) {
        instance.getServer().getLogger().severe("[Alkatraz] " + help);
    }

    private void registerListener(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public YamlConfiguration saveConfig(String name) {
        this.save(name);
        return ConfigManager.saveConfig(name).get();
    }

    public void save(String name) {
        File file = new File(this.getDataFolder(), name);
        if (!file.exists()) {
            this.saveResource(name, false);
        }
    }

    private void updateConfig(String name) {
        File configFile = new File(this.getDataFolder(), name);
        try {
            ConfigUpdater.update((Plugin)instance, name, configFile, new ArrayList<String>());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateConfig(String name, List<String> excludedSections) {
        File configFile = new File(this.getDataFolder(), name);
        try {
            ConfigUpdater.update((Plugin)instance, name, configFile, excludedSections);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private YamlConfiguration saveAndUpdateConfig(String config) {
        this.save(config);
        this.updateConfig(config);
        return this.saveConfig(config);
    }

    private YamlConfiguration saveAndUpdateConfig(String config, List<String> excludedSections) {
        this.save(config);
        this.updateConfig(config, excludedSections);
        return this.saveConfig(config);
    }

    public static YamlConfiguration getPluginConfig() {
        return pluginConfig;
    }
}

