/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.commands;

import java.util.ArrayList;
import java.util.List;
import me.nagasonic.alkatraz.items.wands.Wand;
import me.nagasonic.alkatraz.items.wands.WandRegistry;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.playerdata.PlayerData;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.spells.SpellRegistry;
import me.nagasonic.alkatraz.util.ColorFormat;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlkatrazCommand
implements CommandExecutor,
TabCompleter {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        Player p;
        if (args.length == 0) {
            sender.sendMessage(ColorFormat.format("&cPlease add an argument. e.g /alkatraz reload"));
            return true;
        }
        if (args[0].equals("discoverspell")) {
            Player p2;
            if (!sender.hasPermission("alkatraz.command.discoverspell")) {
                sender.sendMessage(ColorFormat.format("&cYou do not have permission to use this command."));
                return true;
            }
            if (args.length < 2 || args.length > 3) {
                sender.sendMessage(ColorFormat.format("&cThere are too many/few arguments: /alkatraz discoverspell <spell> <player>"));
                return true;
            }
            Spell spell = SpellRegistry.getSpellFromName(args[1]);
            if (spell == null) {
                sender.sendMessage(ColorFormat.format("&cThere is no spell named " + args[1]));
                return true;
            }
            Player player = p2 = args.length == 3 ? Bukkit.getPlayer((String)args[2]) : (Player)sender;
            if (p2 == null) {
                sender.sendMessage(ColorFormat.format("&cCouldn't find a player named " + args[2] + ". Make sure they are online."));
                return true;
            }
            PlayerData data = DataManager.getPlayerData((OfflinePlayer)p2);
            data.setDiscovered(spell, true);
            return true;
        }
        if (args[0].equals("undiscoverspell")) {
            Player p3;
            if (!sender.hasPermission("alkatraz.command.undiscoverspell")) {
                sender.sendMessage(ColorFormat.format("&cYou do not have permission to use this command."));
                return true;
            }
            if (args.length < 2 || args.length > 3) {
                sender.sendMessage(ColorFormat.format("&cThere are too many/few arguments: /alkatraz discoverspell <spell> <player>"));
                return true;
            }
            Spell spell = SpellRegistry.getSpellFromName(args[1]);
            if (spell == null) {
                sender.sendMessage(ColorFormat.format("&cThere is no spell named " + args[1]));
                return true;
            }
            Player player = p3 = args.length == 3 ? Bukkit.getPlayer((String)args[2]) : (Player)sender;
            if (p3 == null) {
                sender.sendMessage(ColorFormat.format("&cCouldn't find a player named " + args[2] + ". Make sure they are online."));
                return true;
            }
            PlayerData data = DataManager.getPlayerData((OfflinePlayer)p3);
            data.setDiscovered(spell, false);
            return true;
        }
        if (!args[0].equals("give")) return true;
        if (!sender.hasPermission("alkatraz.command.give")) {
            sender.sendMessage(ColorFormat.format("&cYou do not have permission to use this command."));
            return true;
        }
        if (args.length < 2 || args.length > 3) {
            sender.sendMessage(ColorFormat.format("&cThere are too many/few arguments: /alkatraz give <item> <player>"));
            return true;
        }
        Wand wand = WandRegistry.getWand(args[1].toUpperCase());
        Player player = p = args.length == 3 ? Bukkit.getPlayer((String)args[2]) : (Player)sender;
        if (p == null) {
            sender.sendMessage(ColorFormat.format("&cCouldn't find a player named " + args[2] + ". Make sure they are online."));
            return true;
        }
        p.getInventory().addItem(new ItemStack[]{wand.getItem()});
        sender.sendMessage(ColorFormat.format("&aGave " + wand.getName() + " to " + p.getName()));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            if (sender.hasPermission("discoverspell")) {
                list.add("discoverspell");
            }
            if (sender.hasPermission("undiscoverspell")) {
                list.add("undiscoverspell");
            }
            if (sender.hasPermission("give")) {
                list.add("give");
            }
            return list;
        }
        if (args.length == 2) {
            if (args[0].equals("discoverspell") && sender.hasPermission("alkatraz.command.discoverspell")) {
                ArrayList<String> list = new ArrayList<String>();
                for (Spell spell : SpellRegistry.getAllSpells().values()) {
                    list.add(ColorFormat.format(spell.getDisplayName().toLowerCase().replace(" ", "_")));
                }
                return list;
            }
            if (args[0].equals("undiscoverspell") && sender.hasPermission("alkatraz.command.undiscoverspell")) {
                ArrayList<String> list = new ArrayList<String>();
                for (Spell spell : SpellRegistry.getAllSpells().values()) {
                    list.add(ColorFormat.format(spell.getDisplayName().toLowerCase().replace(" ", "_")));
                }
                return list;
            }
            if (args[0].equals("give") && sender.hasPermission("alkatraz.command.give")) {
                ArrayList<String> list = new ArrayList<String>();
                for (Wand wand : WandRegistry.getAllWands().values()) {
                    list.add(ColorFormat.format(wand.getName().toLowerCase().replace(" ", "_")));
                }
                return list;
            }
        } else if (args.length == 3) {
            if (args[0].equals("discoverspell") && sender.hasPermission("alkatraz.command.discoverspell")) {
                ArrayList<String> list = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    list.add(p.getName());
                }
                return list;
            }
            if (args[0].equals("undiscoverspell") && sender.hasPermission("alkatraz.command.undiscoverspell")) {
                ArrayList<String> list = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    list.add(p.getName());
                }
                return list;
            }
            if (args[0].equals("give") && sender.hasPermission("alkatraz.command.give")) {
                ArrayList<String> list = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    list.add(p.getName());
                }
                return list;
            }
        }
        return List.of();
    }
}

