/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.items.wands;

import de.tr7zw.nbtapi.NBT;
import java.util.ArrayList;
import java.util.List;
import me.nagasonic.alkatraz.util.ColorFormat;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Wand
implements Listener {
    protected final String type;
    protected Material material;
    protected String name;
    protected List<String> lore;
    protected double power;
    protected double castTime;
    protected double fireDamage;
    protected double airDamage;
    protected double earthDamage;
    protected double waterDamage;
    protected double lightDamage;
    protected double darkDamage;

    public Wand(String type) {
        this.type = type;
    }

    public abstract void loadConfiguration();

    public void loadCommonConfig(YamlConfiguration wandConfig) {
        this.name = wandConfig.getString("item_name");
        this.material = Utils.materialFromString(wandConfig.getString("material"));
        this.lore = wandConfig.getStringList("lore");
        this.power = wandConfig.getDouble("power");
        this.castTime = wandConfig.getDouble("cast_time");
        this.fireDamage = wandConfig.getDouble("fire_damage");
        this.airDamage = wandConfig.getDouble("air_damage");
        this.earthDamage = wandConfig.getDouble("earth_damage");
        this.waterDamage = wandConfig.getDouble("water_damage");
        this.lightDamage = wandConfig.getDouble("light_damage");
        this.darkDamage = wandConfig.getDouble("dark_damage");
    }

    public ItemStack getItem() {
        ItemStack item = new ItemStack(this.getMaterial());
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.addAll(this.getFormmattedLore());
        lore.addAll(this.createAttributeLore());
        meta.setLore(lore);
        meta.setDisplayName(ColorFormat.format(this.getName()));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        this.setNBT(item);
        return item;
    }

    public List<String> getFormmattedLore() {
        List<String> lore = this.getLore();
        ArrayList<String> formattedLore = new ArrayList<String>();
        for (String str : lore) {
            formattedLore.add(ColorFormat.format(str));
        }
        return formattedLore;
    }

    private List<String> createAttributeLore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ColorFormat.format("&9Magic Power: " + this.getPower()));
        lore.add(ColorFormat.format("&9Casting Time: " + this.getCastTime()));
        if (this.getFireDamage() != 0.0) {
            lore.add(ColorFormat.format("&cFire Damage: " + this.getFireDamage()));
        }
        if (this.getAirDamage() != 0.0) {
            lore.add(ColorFormat.format("&fAir Damage: " + this.getAirDamage()));
        }
        if (this.getEarthDamage() != 0.0) {
            lore.add(ColorFormat.format("&2Earth Damage: " + this.getEarthDamage()));
        }
        if (this.getWaterDamage() != 0.0) {
            lore.add(ColorFormat.format("&bWater Damage: " + this.getWaterDamage()));
        }
        if (this.getLightDamage() != 0.0) {
            lore.add(ColorFormat.format("&eLight Damage: " + this.getLightDamage()));
        }
        if (this.getDarkDamage() != 0.0) {
            lore.add(ColorFormat.format("&8Dark Damage: " + this.getDarkDamage()));
        }
        return lore;
    }

    private void setNBT(ItemStack item) {
        NBT.modify((ItemStack)item, nbt -> {
            nbt.setBoolean("wand", Boolean.valueOf(true));
            nbt.setString("cast_code", "");
            nbt.setDouble("magic_power", Double.valueOf(this.getPower()));
            nbt.setDouble("casting_time", Double.valueOf(this.getCastTime()));
            if (this.getFireDamage() != 0.0) {
                nbt.setDouble("fire_damage", Double.valueOf(this.getFireDamage()));
            }
            if (this.getAirDamage() != 0.0) {
                nbt.setDouble("air_damage", Double.valueOf(this.getAirDamage()));
            }
            if (this.getEarthDamage() != 0.0) {
                nbt.setDouble("earth_damage", Double.valueOf(this.getEarthDamage()));
            }
            if (this.getWaterDamage() != 0.0) {
                nbt.setDouble("water_damage", Double.valueOf(this.getWaterDamage()));
            }
            if (this.getLightDamage() != 0.0) {
                nbt.setDouble("light_damage", Double.valueOf(this.getLightDamage()));
            }
            if (this.getDarkDamage() != 0.0) {
                nbt.setDouble("dark_damage", Double.valueOf(this.getDarkDamage()));
            }
        });
    }

    public String getType() {
        return this.type;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public double getPower() {
        return this.power;
    }

    public double getCastTime() {
        return this.castTime;
    }

    public double getFireDamage() {
        return this.fireDamage;
    }

    public double getAirDamage() {
        return this.airDamage;
    }

    public double getEarthDamage() {
        return this.earthDamage;
    }

    public double getWaterDamage() {
        return this.waterDamage;
    }

    public double getLightDamage() {
        return this.lightDamage;
    }

    public double getDarkDamage() {
        return this.darkDamage;
    }

    public static boolean isWand(ItemStack item) {
        return (Boolean)NBT.get((ItemStack)item, nbt -> nbt.getBoolean("wand"));
    }
}

