/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.playerdata;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.items.wands.Wand;
import me.nagasonic.alkatraz.playerdata.PlayerData;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.spells.SpellRegistry;
import me.nagasonic.alkatraz.spells.implementation.MagicMissile;
import me.nagasonic.alkatraz.util.ColorFormat;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DataManager
implements Listener {
    private static Map<String, PlayerData> playerData = new HashMap<String, PlayerData>();

    public static PlayerData getPlayerData(OfflinePlayer p) {
        if (!playerData.containsKey(p.getUniqueId().toString())) {
            PlayerData d = new PlayerData();
            playerData.put(p.getUniqueId().toString(), d);
            return d;
        }
        return playerData.get(p.getUniqueId().toString());
    }

    public static PlayerData getConfigData(OfflinePlayer p) {
        PlayerData data = new PlayerData();
        File f = new File(DataManager.getFolderPath(p) + "/general.yml");
        if (f.exists()) {
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
            data.setMaxMana(cfg.getDouble("stats.max_mana"));
            data.setMana(cfg.getDouble("stats.mana"));
            data.setCircle(cfg.getInt("stats.circle"));
            data.setMagicLevel(cfg.getDouble("stats.magic_level"));
            data.setMagicDamage(cfg.getDouble("stats.magic_damage"));
            data.setMagicResistance(cfg.getDouble("stats.magic_resistance"));
            data.setFireAffinity(cfg.getDouble("stats.fire_affinity"));
            data.setFireResistance(cfg.getDouble("stats.fire_resistance"));
            data.setAirAffinity(cfg.getDouble("stats.air_affinity"));
            data.setAirResistance(cfg.getDouble("stats.air_resistance"));
            data.setEarthAffinity(cfg.getDouble("stats.earth_affinity"));
            data.setEarthResistance(cfg.getDouble("stats.earth_resistance"));
            data.setWaterAffinity(cfg.getDouble("stats.water_affinity"));
            data.setWaterResistance(cfg.getDouble("stats.water_resistance"));
            data.setLightAffinity(cfg.getDouble("stats.light_affinity"));
            data.setLightResistance(cfg.getDouble("stats.light_resistance"));
            data.setDarkAffinity(cfg.getDouble("stats.dark_affinity"));
            data.setDarkResistance(cfg.getDouble("stats.dark_resistance"));
            for (Spell spell : SpellRegistry.getAllSpells().values()) {
                if (!cfg.getStringList("discovered_spells").contains(spell.getType().toLowerCase())) continue;
                data.setDiscovered(spell, true);
            }
            data.setDiscovered(SpellRegistry.getSpell(MagicMissile.class), true);
        } else {
            data.setMaxMana(100.0);
            data.setMana(100.0);
            data.setCircle(0);
            data.setMagicLevel(1.0);
            data.setMagicDamage(1.0);
            data.setMagicResistance(0.0);
            data.setFireAffinity(0.0);
            data.setFireResistance(0.0);
            data.setAirAffinity(0.0);
            data.setAirResistance(0.0);
            data.setEarthAffinity(0.0);
            data.setEarthResistance(0.0);
            data.setWaterAffinity(0.0);
            data.setWaterResistance(0.0);
            data.setLightAffinity(0.0);
            data.setLightResistance(0.0);
            data.setDarkAffinity(0.0);
            data.setDarkResistance(0.0);
            data.setDiscovered(SpellRegistry.getSpell(MagicMissile.class), true);
        }
        File masteries = new File(DataManager.getFolderPath(p) + "/mastery.yml");
        if (masteries.exists()) {
            YamlConfiguration mcfg = YamlConfiguration.loadConfiguration((File)masteries);
            for (Spell spell : SpellRegistry.getAllSpells().values()) {
                if (!mcfg.contains("spell_mastery." + spell.getType().toLowerCase())) continue;
                data.setSpellMastery(spell, mcfg.getInt("spell_mastery." + spell.getType().toLowerCase()));
            }
        }
        return data;
    }

    public static void setPlayerData(Player p, PlayerData data) {
        playerData.put(p.getUniqueId().toString(), data);
    }

    public static String getFolderPath(OfflinePlayer p) {
        return Bukkit.getPluginsFolder().getAbsolutePath() + "/Alkatraz/playerdata/" + p.getUniqueId();
    }

    @EventHandler
    private void onJoin(PlayerJoinEvent e) {
        PlayerData data = DataManager.getConfigData((OfflinePlayer)e.getPlayer());
        DataManager.setPlayerData(e.getPlayer(), data);
    }

    @EventHandler
    private void onQuit(PlayerQuitEvent e) {
        DataManager.savePlayerData(e.getPlayer());
        DataManager.setPlayerData(e.getPlayer(), null);
    }

    public static void addMana(Player p, double amount) {
        ItemStack item;
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
        data.setMana(data.getMana() + amount);
        if (data.getMana() > data.getMaxMana()) {
            data.setMana(data.getMaxMana());
        }
        if ((item = p.getItemInHand()).getType() != Material.AIR && item.getAmount() != 0 && Wand.isWand(item)) {
            p.setLevel((int)data.getMana());
            p.setExp(Float.parseFloat(String.valueOf(data.getMana() / data.getMaxMana() - 0.01)));
        }
    }

    public static void subMana(Player p, double amount) {
        ItemStack item;
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
        data.setMana(data.getMana() - amount);
        if (data.getMana() < 0.0) {
            data.setMana(0.0);
        }
        if ((item = p.getItemInHand()).getType() != Material.AIR && item.getAmount() != 0 && Wand.isWand(p.getItemInHand())) {
            p.setLevel((int)data.getMana());
            p.setExp(Float.parseFloat(String.valueOf(data.getMana() / data.getMaxMana() - 0.01)));
        }
    }

    public static void addManaPerSecond() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Alkatraz.getInstance(), () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
                if (!(data.getMana() < data.getMaxMana())) continue;
                DataManager.addMana(p, 1.0);
            }
        }, 0L, 20L);
    }

    public static void addSpellMastery(Player p, Spell spell, int mastery) {
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
        if (data.getSpellMastery(spell) == -1 && mastery > 0) {
            data.setSpellMastery(spell, 0);
        }
        data.setSpellMastery(spell, data.getSpellMastery(spell) + mastery);
        Map<Spell, BossBar> masteryBars = data.getMasteryBars();
        if (masteryBars.containsKey(spell)) {
            BossBar bar = masteryBars.get(spell);
            bar.removePlayer(p);
            bar.setTitle(ColorFormat.format(spell.getDisplayName() + ": " + data.getSpellMastery(spell) + "/" + spell.getMaxMastery()));
            bar.setProgress((double)data.getSpellMastery(spell) / (double)spell.getMaxMastery());
            bar.addPlayer(p);
            masteryBars.replace(spell, bar);
            data.setMasteryBars(masteryBars);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Alkatraz.getInstance(), () -> {
                if (bar.getProgress() == data.getMasteryBars().get(spell).getProgress()) {
                    bar.removePlayer(p);
                }
            }, 100L);
        } else {
            BossBar bar = Bukkit.createBossBar((String)ColorFormat.format(spell.getDisplayName() + ": " + data.getSpellMastery(spell) + "/" + spell.getMaxMastery()), (BarColor)spell.getMasteryBarColor(), (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            bar.setProgress((double)data.getSpellMastery(spell) / (double)spell.getMaxMastery());
            bar.addPlayer(p);
            masteryBars.put(spell, bar);
            data.setMasteryBars(masteryBars);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Alkatraz.getInstance(), () -> {
                if (bar.getProgress() == data.getMasteryBars().get(spell).getProgress()) {
                    bar.removePlayer(p);
                }
            }, 100L);
        }
    }

    public static void savePlayerData(Player p) {
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
        File general = new File(DataManager.getFolderPath((OfflinePlayer)p) + "/general.yml");
        YamlConfiguration gcfg = YamlConfiguration.loadConfiguration((File)general);
        gcfg.set("stats.max_mana", (Object)data.getMaxMana());
        gcfg.set("stats.mana", (Object)data.getMana());
        gcfg.set("stats.circle", (Object)data.getCircle());
        gcfg.set("stats.magic_level", (Object)data.getMagicLevel());
        gcfg.set("stats.magic_damage", (Object)data.getMagicDamage());
        gcfg.set("stats.magic_resistance", (Object)data.getMagicResistance());
        gcfg.set("stats.fire_affinity", (Object)data.getFireAffinity());
        gcfg.set("stats.fire_resistance", (Object)data.getFireResistance());
        gcfg.set("stats.air_affinity", (Object)data.getAirAffinity());
        gcfg.set("stats.air_resistance", (Object)data.getAirResistance());
        gcfg.set("stats.earth_affinity", (Object)data.getEarthAffinity());
        gcfg.set("stats.earth_resistance", (Object)data.getEarthResistance());
        gcfg.set("stats.water_affinity", (Object)data.getWaterAffinity());
        gcfg.set("stats.water_resistance", (Object)data.getWaterResistance());
        gcfg.set("stats.light_affinity", (Object)data.getLightAffinity());
        gcfg.set("stats.light_resistance", (Object)data.getLightResistance());
        gcfg.set("stats.dark_affinity", (Object)data.getDarkAffinity());
        gcfg.set("stats.dark_resistance", (Object)data.getDarkResistance());
        for (Spell spell : SpellRegistry.getAllSpells().values()) {
            if (!data.hasDiscovered(spell)) continue;
            gcfg.getStringList("discovered_spells").add(spell.getType().toLowerCase());
        }
        File masteries = new File(DataManager.getFolderPath((OfflinePlayer)p) + "/mastery.yml");
        YamlConfiguration mcfg = YamlConfiguration.loadConfiguration((File)masteries);
        for (Spell spell : SpellRegistry.getAllSpells().values()) {
            if (data.getSpellMastery(spell) < 0) continue;
            mcfg.set("spell_mastery." + spell.getType().toLowerCase(), (Object)data.getSpellMastery(spell));
        }
        try {
            gcfg.save(general);
            mcfg.save(masteries);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void saveAll() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            DataManager.savePlayerData(p);
        }
    }
}

