/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells;

import de.tr7zw.nbtapi.NBT;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.playerdata.PlayerData;
import me.nagasonic.alkatraz.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class Spell {
    protected final String type;
    protected String displayName;
    protected String description;
    protected String element;
    protected String code;
    protected BarColor masteryBarColor;
    protected Material guiItem;
    protected int cost;
    protected double castTime;
    protected int level;
    protected boolean enabled;
    protected int maxMastery;

    public Spell(String type) {
        this.type = type;
    }

    public abstract void loadConfiguration();

    public abstract void castAction(Player var1, ItemStack var2);

    public abstract void circleAction(Player var1);

    public void cast(Player p, ItemStack wand) {
        Float castTime = this.getFullCastTime(wand, this.getCastTime());
        PlayerData data = DataManager.getPlayerData((OfflinePlayer)p);
        if (data.getMana() >= (double)this.getCost()) {
            if (!p.isDead()) {
                data.setCasting(true);
                DataManager.subMana(p, this.getCost());
                Utils.sendActionBar(p, "Casted: " + this.getDisplayName());
                this.circleAction(p);
                Long finalCastTime = castTime.longValue();
                if (data.getSpellMastery(this) >= this.getMaxMastery()) {
                    finalCastTime = (long)((double)castTime.floatValue() * 1.25);
                }
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Alkatraz.getInstance(), () -> this.castAction(p, wand), finalCastTime.longValue());
                if (data.getSpellMastery(this) < this.getMaxMastery()) {
                    DataManager.addSpellMastery(p, this, 1);
                }
            }
        } else {
            Utils.sendActionBar(p, "&cNot Enough Mana");
        }
    }

    public void loadCommonConfig(YamlConfiguration spellConfig) {
        this.displayName = spellConfig.getString("display_name");
        this.description = spellConfig.getString("description");
        this.element = spellConfig.getString("element");
        this.code = spellConfig.getString("code");
        this.castTime = spellConfig.getDouble("cast_time");
        this.cost = spellConfig.getInt("mana_cost");
        this.level = spellConfig.getInt("level");
        this.enabled = spellConfig.getBoolean("enabled");
        this.maxMastery = spellConfig.getInt("maximum_mastery");
        this.masteryBarColor = BarColor.valueOf((String)spellConfig.getString("mastery_bar_color"));
        this.guiItem = Material.valueOf((String)spellConfig.getString("gui_item"));
    }

    public String getType() {
        return this.type;
    }

    public String getElement() {
        return this.element;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCode() {
        return this.code;
    }

    public int getCost() {
        return this.cost;
    }

    public double getCastTime() {
        return this.castTime;
    }

    public int getMaxMastery() {
        return this.maxMastery;
    }

    public int getLevel() {
        return this.level;
    }

    public BarColor getMasteryBarColor() {
        return this.masteryBarColor;
    }

    public Material getGuiItem() {
        return this.guiItem;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Float getFullCastTime(ItemStack wand, Double spellCastTime) {
        Double wandCastTime = (Double)NBT.get((ItemStack)wand, nbt -> nbt.getDouble("casting_time"));
        Float wCastTime = Float.valueOf(wandCastTime.floatValue());
        return Float.valueOf(wCastTime.floatValue() * spellCastTime.floatValue());
    }
}

