/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.spells.implementation.Fireball;
import me.nagasonic.alkatraz.spells.implementation.MagicMissile;
import me.nagasonic.alkatraz.spells.implementation.WaterSphere;
import org.bukkit.configuration.file.YamlConfiguration;

public class SpellRegistry {
    private static Map<Class<?>, Spell> allSpells = Collections.unmodifiableMap(new HashMap());
    private static Map<String, Spell> allSpellsByCode = Collections.unmodifiableMap(new HashMap());

    public static void registerSpells() {
        SpellRegistry.registerIfEnabled("magic_missile", new MagicMissile("MAGIC_MISSILE"));
        SpellRegistry.registerIfEnabled("fireball", new Fireball("FIREBALL"));
        SpellRegistry.registerIfEnabled("water_sphere", new WaterSphere("WATER_SPHERE"));
    }

    private static void registerIfEnabled(String key, Spell spell) {
        YamlConfiguration spellConfig = ConfigManager.getConfig("spells/" + key + ".yml").get();
        if (spellConfig.getBoolean("enabled")) {
            SpellRegistry.registerSpell(spell);
        }
    }

    public static Map<Class<?>, Spell> getAllSpells() {
        return allSpells;
    }

    public static Map<String, Spell> getAllSpellsByCode() {
        return allSpellsByCode;
    }

    public static <T extends Spell> Spell getSpell(Class<T> spell) {
        if (!allSpells.containsKey(spell)) {
            throw new IllegalArgumentException("Spell " + spell.getSimpleName() + " was not registered for usage");
        }
        return allSpells.get(spell);
    }

    public static Spell getSpell(String code) {
        return allSpellsByCode.get(code);
    }

    public static Spell getSpellFromName(String name) {
        for (Spell spell : allSpells.values()) {
            if (!spell.getDisplayName().toLowerCase().replace(" ", "_").equals(name)) continue;
            return spell;
        }
        return null;
    }

    public static void registerSpell(Spell spell) {
        HashMap spells = new HashMap(allSpells);
        spells.put(spell.getClass(), spell);
        allSpells = Collections.unmodifiableMap(spells);
        spell.loadConfiguration();
        HashMap<String, Spell> spellsByCode = new HashMap<String, Spell>(allSpellsByCode);
        spellsByCode.put(spell.getCode(), spell);
        allSpellsByCode = Collections.unmodifiableMap(spellsByCode);
    }

    public static boolean isRegistered(Class<? extends Spell> spell) {
        return allSpells.containsKey(spell);
    }

    public static void reload() {
        allSpells = Collections.unmodifiableMap(new HashMap());
        SpellRegistry.registerSpells();
    }
}

