/*
 * Decompiled with CFR 0.152.
 */
package me.nagasonic.alkatraz.spells.implementation;

import de.tr7zw.nbtapi.NBT;
import java.util.List;
import me.nagasonic.alkatraz.Alkatraz;
import me.nagasonic.alkatraz.config.ConfigManager;
import me.nagasonic.alkatraz.playerdata.DataManager;
import me.nagasonic.alkatraz.spells.Spell;
import me.nagasonic.alkatraz.util.ParticleUtils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class Fireball
extends Spell
implements Listener {
    private double baseDamage;

    public Fireball(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        Alkatraz.getInstance().save("spells/fireball.yml");
        YamlConfiguration spellConfig = ConfigManager.getConfig("spells/fireball.yml").get();
        this.loadCommonConfig(spellConfig);
        this.baseDamage = spellConfig.getDouble("base_damage");
    }

    @Override
    public void castAction(Player p, ItemStack wand) {
        if (!p.isDead()) {
            EntityDamageEvent e = ((org.bukkit.entity.Fireball)p.launchProjectile(org.bukkit.entity.Fireball.class, p.getLocation().getDirection().multiply(0.5))).getLastDamageCause();
            double wandPower = (Double)NBT.get((ItemStack)wand, nbt -> nbt.getDouble("power"));
            if (e != null) {
                e.setDamage(this.baseDamage * wandPower);
            }
        }
    }

    @Override
    public void circleAction(Player p) {
        Location playerLoc = p.getEyeLocation();
        float yaw = playerLoc.getYaw();
        float pitch = playerLoc.getPitch();
        Vector forward = playerLoc.getDirection().normalize().multiply(1.5);
        List<Location> magicCirclePoints = ParticleUtils.magicCircle(playerLoc, yaw, pitch, forward, 2.0, 0.0);
        for (int i = 0; i < 100; ++i) {
            for (Location loc : magicCirclePoints) {
                loc.getWorld().spawnParticle(Particle.REDSTONE, loc, 0, (Object)new Particle.DustOptions(Color.ORANGE, 0.4f));
            }
        }
        DataManager.getPlayerData((OfflinePlayer)p).setCasting(false);
    }
}

