/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.item;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.energeticsheep.item.ItemEnergeticShearsConfigCommon;
import org.jetbrains.annotations.Nullable;

public abstract class ItemEnergeticShearsCommon
extends ShearsItem {
    public ItemEnergeticShearsCommon(Item.Properties builder) {
        super(builder);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltipAdder, TooltipFlag flagIn) {
        super.appendHoverText(itemStack, context, display, tooltipAdder, flagIn);
        int capacity = this.getMaxEnergyStored(itemStack);
        if (capacity > 0) {
            int amount = this.getEnergyStored(itemStack);
            String line = String.format("%,d", amount) + " / " + String.format("%,d", capacity) + " " + IModHelpers.get().getL10NHelpers().localize(this.getEnergyUnitUnlocalized(), new Object[0]);
            tooltipAdder.accept((Component)Component.literal((String)line).withStyle(ChatFormatting.RED));
        }
    }

    protected String getEnergyUnitUnlocalized() {
        return "general.energeticsheep.energy_unit";
    }

    public abstract int getEnergyStored(ItemStack var1);

    public abstract void setEnergyStored(ItemStack var1, int var2, Player var3, InteractionHand var4);

    public abstract int getMaxEnergyStored(ItemStack var1);

    public abstract void consumeEnergy(ItemStack var1, int var2, Player var3, InteractionHand var4);

    protected abstract int moveEnergyFromEntityToItem(LivingEntity var1, ItemStack var2, int var3, Player var4, InteractionHand var5);

    @Nullable
    protected abstract List<ItemStack> getShearableDrops(Object var1, @Nullable Player var2, ItemStack var3, Level var4, BlockPos var5);

    protected boolean canShear(ItemStack itemStack) {
        return this.getEnergyStored(itemStack) > ItemEnergeticShearsConfigCommon.shearConsumption;
    }

    protected void consumeOnShear(ItemStack itemStack, Player player, InteractionHand hand) {
        this.consumeEnergy(itemStack, ItemEnergeticShearsConfigCommon.shearConsumption, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        if (player.level().isClientSide || player.isCreative() || !this.canShear(itemStack)) {
            return super.useOn(context);
        }
        Block block = player.level().getBlockState(pos).getBlock();
        List<ItemStack> drops = this.getShearableDrops(block, player, itemStack, player.level(), pos);
        if (drops != null) {
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                ItemEntity entityitem = new ItemEntity(player.level(), (double)pos.getX() + d, (double)pos.getY() + d1, (double)pos.getZ() + d2, stack);
                entityitem.setDefaultPickUpDelay();
                player.level().addFreshEntity((Entity)entityitem);
            }
            this.consumeOnShear(itemStack, player, context.getHand());
            player.setItemInHand(player.getUsedItemHand(), itemStack);
            player.awardStat(Stats.BLOCK_MINED.get((Object)block));
            player.level().setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public float getDestroySpeed(ItemStack itemStack, BlockState state) {
        float factor = this.canShear(itemStack) ? 1.5f : 0.1f;
        float superSpeed = super.getDestroySpeed(itemStack, state);
        if (superSpeed != 1.0f) {
            return superSpeed * factor;
        }
        return superSpeed;
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity entity, InteractionHand hand) {
        List<ItemStack> drops;
        if (entity.level().isClientSide) {
            return InteractionResult.PASS;
        }
        if (this.moveEnergyFromEntityToItem(entity, itemStack, ItemEnergeticShearsConfigCommon.usageTransferAmount, player, hand) > 0) {
            player.setItemInHand(hand, itemStack);
            entity.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.canShear(itemStack) && (drops = this.getShearableDrops(entity, player, itemStack, entity.level(), entity.getOnPos())) != null) {
            Random rand = new Random();
            if (!entity.level().isClientSide) {
                for (ItemStack stack : drops) {
                    ItemEntity ent = entity.spawnAtLocation((ServerLevel)entity.level(), stack, 1.0f);
                    ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                }
            }
            this.consumeOnShear(itemStack, player, hand);
            player.setItemInHand(hand, itemStack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack itemStack) {
        return Math.round((float)this.getEnergyStored(itemStack) * 13.0f / (float)this.getMaxEnergyStored(itemStack));
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)this.getBarWidth(stack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

