/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.RegistryEntriesCommon;
import org.cyclops.cyclopscore.helper.IModHelpersForge;
import org.cyclops.energeticsheep.item.ComponentEnergyStorage;
import org.cyclops.energeticsheep.item.ItemEnergeticShearsCommon;
import org.cyclops.energeticsheep.item.ItemEnergeticShearsConfigCommon;

public class ItemEnergeticShearsForge
extends ItemEnergeticShearsCommon {
    public ItemEnergeticShearsForge(Item.Properties builder) {
        super(builder);
    }

    public boolean mineBlock(ItemStack itemStack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.isClientSide) {
            this.consumeOnShear(itemStack, null, null);
        }
        Block block = state.getBlock();
        return !state.is(BlockTags.LEAVES) && block != Blocks.COBWEB && block != Blocks.GRASS_BLOCK && block != Blocks.FERN && block != Blocks.DEAD_BUSH && block != Blocks.VINE && block != Blocks.TRIPWIRE && !state.is(BlockTags.WOOL) ? super.mineBlock(itemStack, worldIn, state, pos, entityLiving) : true;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        InteractionResult result = ItemEnergeticShearsForge.transferEnergy(context.getPlayer(), context.getClickedPos(), context.getClickedFace(), context.getHand());
        if (result == null) {
            return super.onItemUseFirst(stack, context);
        }
        return result;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem();
    }

    @Nullable
    protected IEnergyStorage getEnergyStorage(ItemStack itemStack) {
        return ItemEnergeticShearsForge.getEnergyStorageInternal(itemStack);
    }

    protected static IEnergyStorage getEnergyStorageInternal(ItemStack itemStack) {
        return new ComponentEnergyStorage(itemStack, (DataComponentType<Integer>)((DataComponentType)RegistryEntriesCommon.COMPONENT_ENERGY_STORAGE.value()), ItemEnergeticShearsConfigCommon.capacity);
    }

    @Override
    public int getEnergyStored(ItemStack itemStack) {
        IEnergyStorage energyStorage = this.getEnergyStorage(itemStack);
        return energyStorage != null ? energyStorage.getEnergyStored() : 0;
    }

    @Override
    public void setEnergyStored(ItemStack itemStack, int energy, Player player, InteractionHand hand) {
        IEnergyStorage energyStorage = this.getEnergyStorage(itemStack);
        if (energyStorage != null) {
            energyStorage.receiveEnergy(energy, false);
        }
    }

    @Override
    public int getMaxEnergyStored(ItemStack itemStack) {
        IEnergyStorage energyStorage = this.getEnergyStorage(itemStack);
        return energyStorage != null ? energyStorage.getMaxEnergyStored() : 0;
    }

    @Override
    public void consumeEnergy(ItemStack itemStack, int amount, Player player, InteractionHand hand) {
        IEnergyStorage energyStorage = this.getEnergyStorage(itemStack);
        if (energyStorage != null) {
            energyStorage.extractEnergy(amount, false);
        }
    }

    @Override
    protected int moveEnergyFromEntityToItem(LivingEntity entity, ItemStack itemStack, int usageTransferAmount, Player player, InteractionHand hand) {
        LazyOptional energyCapability = entity.getCapability(ForgeCapabilities.ENERGY, null);
        if (energyCapability.isPresent()) {
            IEnergyStorage entityEnergy = (IEnergyStorage)energyCapability.orElse(null);
            IEnergyStorage itemEnergy = this.getEnergyStorage(itemStack);
            return entityEnergy.extractEnergy(itemEnergy.receiveEnergy(entityEnergy.extractEnergy(usageTransferAmount, true), false), false);
        }
        return 0;
    }

    @Override
    @Nullable
    protected List<ItemStack> getShearableDrops(Object maybeShearable, @Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        IForgeShearable shearable;
        if (maybeShearable instanceof IForgeShearable && (shearable = (IForgeShearable)maybeShearable).isShearable(item, level, pos)) {
            return shearable.onSheared(player, item, level, pos, 0);
        }
        return null;
    }

    public static InteractionResult transferEnergy(Player player, BlockPos pos, Direction side, InteractionHand hand) {
        Level worldIn = player.level();
        if (!player.isCrouching()) {
            return IModHelpersForge.get().getCapabilityHelpers().getCapability((BlockGetter)worldIn, pos, side, ForgeCapabilities.ENERGY).map(energyTarget -> {
                ItemStack itemStack = player.getItemInHand(hand);
                return Optional.of(ItemEnergeticShearsForge.getEnergyStorageInternal(itemStack)).map(energyItem -> energyTarget.receiveEnergy(energyItem.extractEnergy(energyTarget.receiveEnergy(energyItem.extractEnergy(ItemEnergeticShearsConfigCommon.usageTransferAmount, true), true), worldIn.isClientSide), worldIn.isClientSide) > 0 ? InteractionResult.SUCCESS : InteractionResult.FAIL).orElse(null);
            }).orElse(null);
        }
        return null;
    }
}

