/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.entity;

import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1315;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import org.cyclops.energeticsheep.entity.EntityEnergeticSheepCommon;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class EntityEnergeticSheepFabric
extends EntityEnergeticSheepCommon {
    @javax.annotation.Nullable
    private EnergyStorage energyStorage;

    public EntityEnergeticSheepFabric(class_1299<? extends EntityEnergeticSheepCommon> type, class_1937 world) {
        super(type, world);
    }

    @javax.annotation.Nullable
    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    protected void initializeEnergy(class_1767 color) {
        int capacity = EntityEnergeticSheepFabric.getCapacity(color);
        this.energyStorage = new SimpleEnergyStorage(capacity, capacity, capacity){

            protected void onFinalCommit() {
                super.onFinalCommit();
                EntityEnergeticSheepFabric.this.updateEnergy((int)this.getAmount());
            }
        };
    }

    @Override
    public int getCapacity() {
        return this.energyStorage != null ? (int)this.energyStorage.getCapacity() : 0;
    }

    @Override
    protected void restoreAllEnergy() {
        if (this.energyStorage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                this.energyStorage.insert(this.energyStorage.getCapacity(), (TransactionContext)transaction);
                transaction.commit();
            }
        }
    }

    @Override
    protected void consumeAllEnergy() {
        if (this.energyStorage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                this.energyStorage.extract(this.energyStorage.getCapacity(), (TransactionContext)transaction);
                transaction.commit();
            }
        }
    }

    @Override
    public void method_5652(class_11372 output) {
        super.method_5652(output);
        if (this.energyStorage != null) {
            output.method_71466("energy", this.energyStorage.getAmount());
        }
    }

    @Override
    public void method_5749(class_11368 input) {
        super.method_5749(input);
        try (Transaction transaction = Transaction.openOuter();){
            this.energyStorage.insert(((Long)input.method_71440("energy").orElseThrow()).longValue(), (TransactionContext)transaction);
            transaction.commit();
        }
    }

    @Override
    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, @Nullable class_1315 spawnDataIn) {
        class_1315 data = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn);
        try (Transaction transaction = Transaction.openOuter();){
            this.energyStorage.insert(this.energyStorage.getCapacity(), (TransactionContext)transaction);
            transaction.commit();
        }
        return data;
    }
}

