/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.item;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.energeticsheep.item.ItemEnergeticShearsConfigCommon;
import org.jetbrains.annotations.Nullable;

public abstract class ItemEnergeticShearsCommon
extends class_1820 {
    public ItemEnergeticShearsCommon(class_1792.class_1793 builder) {
        super(builder);
    }

    public void method_67187(class_1799 itemStack, class_1792.class_9635 context, class_10712 display, Consumer<class_2561> tooltipAdder, class_1836 flagIn) {
        super.method_67187(itemStack, context, display, tooltipAdder, flagIn);
        int capacity = this.getMaxEnergyStored(itemStack);
        if (capacity > 0) {
            int amount = this.getEnergyStored(itemStack);
            String line = String.format("%,d", amount) + " / " + String.format("%,d", capacity) + " " + IModHelpers.get().getL10NHelpers().localize(this.getEnergyUnitUnlocalized(), new Object[0]);
            tooltipAdder.accept((class_2561)class_2561.method_43470((String)line).method_27692(class_124.field_1061));
        }
    }

    protected String getEnergyUnitUnlocalized() {
        return "general.energeticsheep.energy_unit";
    }

    public abstract int getEnergyStored(class_1799 var1);

    public abstract void setEnergyStored(class_1799 var1, int var2, class_1657 var3, class_1268 var4);

    public abstract int getMaxEnergyStored(class_1799 var1);

    public abstract void consumeEnergy(class_1799 var1, int var2, class_1657 var3, class_1268 var4);

    protected abstract int moveEnergyFromEntityToItem(class_1309 var1, class_1799 var2, int var3, class_1657 var4, class_1268 var5);

    @Nullable
    protected abstract List<class_1799> getShearableDrops(Object var1, @Nullable class_1657 var2, class_1799 var3, class_1937 var4, class_2338 var5);

    protected boolean canShear(class_1799 itemStack) {
        return this.getEnergyStored(itemStack) > ItemEnergeticShearsConfigCommon.shearConsumption;
    }

    protected void consumeOnShear(class_1799 itemStack, class_1657 player, class_1268 hand) {
        this.consumeEnergy(itemStack, ItemEnergeticShearsConfigCommon.shearConsumption, player, hand);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1799 itemStack = context.method_8041();
        class_2338 pos = context.method_8037();
        if (player.method_37908().field_9236 || player.method_68878() || !this.canShear(itemStack)) {
            return super.method_7884(context);
        }
        class_2248 block = player.method_37908().method_8320(pos).method_26204();
        List<class_1799> drops = this.getShearableDrops(block, player, itemStack, player.method_37908(), pos);
        if (drops != null) {
            Random rand = new Random();
            for (class_1799 stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                class_1542 entityitem = new class_1542(player.method_37908(), (double)pos.method_10263() + d, (double)pos.method_10264() + d1, (double)pos.method_10260() + d2, stack);
                entityitem.method_6988();
                player.method_37908().method_8649((class_1297)entityitem);
            }
            this.consumeOnShear(itemStack, player, context.method_20287());
            player.method_6122(player.method_6058(), itemStack);
            player.method_7259(class_3468.field_15427.method_14956((Object)block));
            player.method_37908().method_8652(pos, class_2246.field_10124.method_9564(), 11);
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    public float method_58404(class_1799 itemStack, class_2680 state) {
        float factor = this.canShear(itemStack) ? 1.5f : 0.1f;
        float superSpeed = super.method_58404(itemStack, state);
        if (superSpeed != 1.0f) {
            return superSpeed * factor;
        }
        return superSpeed;
    }

    public class_1269 method_7847(class_1799 itemStack, class_1657 player, class_1309 entity, class_1268 hand) {
        List<class_1799> drops;
        if (entity.method_37908().field_9236) {
            return class_1269.field_5811;
        }
        if (this.moveEnergyFromEntityToItem(entity, itemStack, ItemEnergeticShearsConfigCommon.usageTransferAmount, player, hand) > 0) {
            player.method_6122(hand, itemStack);
            entity.method_5783(class_3417.field_14975, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (this.canShear(itemStack) && (drops = this.getShearableDrops(entity, player, itemStack, entity.method_37908(), entity.method_23312())) != null) {
            Random rand = new Random();
            if (!entity.method_37908().field_9236) {
                for (class_1799 stack : drops) {
                    class_1542 ent = entity.method_5699((class_3218)entity.method_37908(), stack, 1.0f);
                    ent.method_18799(ent.method_18798().method_1031((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                }
            }
            this.consumeOnShear(itemStack, player, hand);
            player.method_6122(hand, itemStack);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 itemStack) {
        return Math.round((float)this.getEnergyStored(itemStack) * 13.0f / (float)this.getMaxEnergyStored(itemStack));
    }

    public int method_31571(class_1799 stack) {
        return class_3532.method_15369((float)(Math.max(0.0f, (float)this.method_31569(stack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

