/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import org.cyclops.energeticsheep.EnergeticSheepNeoForge;
import org.cyclops.energeticsheep.entity.EntityEnergeticSheepCommon;
import org.cyclops.energeticsheep.entity.EntityEnergeticSheepConfigCommon;
import org.cyclops.energeticsheep.entity.EntityEnergeticSheepNeoForge;
import org.cyclops.energeticsheep.entity.layers.LayerEnergeticSheepCharge;

public class EntityEnergeticSheepConfigNeoForge
extends EntityEnergeticSheepConfigCommon<EnergeticSheepNeoForge, EntityEnergeticSheepNeoForge> {
    public EntityEnergeticSheepConfigNeoForge() {
        super(EnergeticSheepNeoForge._instance, EntityEnergeticSheepNeoForge::new);
        ((EnergeticSheepNeoForge)this.getMod()).getModEventBus().addListener(this::onEntityAttributesCreation);
        if (((EnergeticSheepNeoForge)this.getMod()).getModHelpers().getMinecraftHelpers().isClientSide()) {
            ((EnergeticSheepNeoForge)this.getMod()).getModEventBus().addListener(this::loadLayerDefinitions);
        }
        ((EnergeticSheepNeoForge)this.getMod()).getModEventBus().addListener(this::registerCapabilities);
        ((EnergeticSheepNeoForge)this.getMod()).getModEventBus().addListener(this::registerSpawnPlacements);
        NeoForge.EVENT_BUS.addListener(this::onLightning);
    }

    public void onEntityAttributesCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)this.getInstance(), Sheep.createAttributes().build());
    }

    public void loadLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(LayerEnergeticSheepCharge.MODEL_LAYER_FUR_SCALED, () -> LayerEnergeticSheepCharge.createFurLayer(1.05f));
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(Capabilities.EnergyStorage.ENTITY, (EntityType)this.getInstance(), (entity, context) -> entity.getEnergyStorage());
    }

    public void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)this.getInstance(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    public void onLightning(EntityStruckByLightningEvent event) {
        if (event.getEntity().getClass() == Sheep.class) {
            EntityEnergeticSheepCommon.onLightning((Sheep)event.getEntity());
            event.getLightning().remove(Entity.RemovalReason.KILLED);
        }
    }
}

