/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.energeticsheep.RegistryEntries;
import org.cyclops.energeticsheep.entity.EntityAIEatGrassFast;
import org.cyclops.energeticsheep.entity.EntityEnergeticSheepCommon;
import org.cyclops.energeticsheep.item.ItemEnergeticShearsCommon;

public class GameTestsCommon {
    public static final String TEMPLATE_EMPTY = "energeticsheep:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="energeticsheep:empty10")
    public void testSpawn(GameTestHelper helper) {
        EntityEnergeticSheepCommon entity = GameTestsCommon.SPAWN(helper);
        helper.succeedWhen(() -> {
            helper.assertEntitiesPresent(GameTestsCommon.SHEEP(), POS, 1, 3.0);
            helper.assertTrue(entity.getEnergyClient() > 500, (Component)Component.literal((String)"Sheep does not have enough energy"));
        });
    }

    @GameTest(template="energeticsheep:empty10")
    public void testShear(GameTestHelper helper) {
        EntityEnergeticSheepCommon entity = GameTestsCommon.SPAWN(helper);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)Items.SHEARS);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.succeedWhen(() -> {
            InteractionResult result = player.interactOn((Entity)entity, InteractionHand.MAIN_HAND);
            helper.assertItemEntityPresent(entity.getWoolByColor().get(entity.getColor()).asItem());
            helper.assertTrue(result == InteractionResult.SUCCESS || result == InteractionResult.SUCCESS_SERVER, (Component)Component.literal((String)"Interaction failed"));
        });
    }

    @GameTest(template="energeticsheep:empty10")
    public void testShearEnergetic(GameTestHelper helper) {
        EntityEnergeticSheepCommon entity = GameTestsCommon.SPAWN(helper);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ENERGETIC_SHEARS);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.succeedWhen(() -> {
            InteractionResult result = player.interactOn((Entity)entity, InteractionHand.MAIN_HAND);
            helper.assertItemEntityNotPresent(entity.getWoolByColor().get(entity.getColor()).asItem());
            helper.assertTrue(((ItemEnergeticShearsCommon)((Object)((Object)RegistryEntries.ITEM_ENERGETIC_SHEARS.value()))).getEnergyStored(player.getMainHandItem()) > 500, (Component)Component.literal((String)"Shears do not have enough energy"));
            helper.assertTrue(result.equals((Object)InteractionResult.SUCCESS), (Component)Component.literal((String)"Interaction failed"));
        });
    }

    @GameTest(template="energeticsheep:empty10")
    public void testEatGrass(GameTestHelper helper) {
        EntityAIEatGrassFast.EAT_CHANCE = 1;
        EntityEnergeticSheepCommon entity = GameTestsCommon.SPAWN(helper);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)Items.SHEARS);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.interactOn((Entity)entity, InteractionHand.MAIN_HAND);
        helper.setBlock(POS.below().east(), Blocks.GRASS_BLOCK);
        helper.setBlock(POS.below(), Blocks.GRASS_BLOCK);
        helper.setBlock(POS.below().west(), Blocks.GRASS_BLOCK);
        for (Direction direction : new Direction[]{Direction.NORTH, Direction.SOUTH}) {
            helper.setBlock(POS.below().relative(direction).east(), Blocks.GRASS_BLOCK);
            helper.setBlock(POS.below().relative(direction), Blocks.GRASS_BLOCK);
            helper.setBlock(POS.below().relative(direction).west(), Blocks.GRASS_BLOCK);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            helper.setBlock(POS.relative(direction), Blocks.ACACIA_FENCE);
        }
        helper.succeedWhen(() -> {
            helper.assertEntitiesPresent(GameTestsCommon.SHEEP(), POS, 1, 3.0);
            helper.assertTrue(entity.getEnergyClient() > 500, (Component)Component.literal((String)"Sheep does not have enough energy"));
        });
    }

    @GameTest(template="energeticsheep:empty10")
    public void testShearEnergeticLeavesWithPower(GameTestHelper helper) {
        if (this.isForge()) {
            helper.succeed();
            return;
        }
        helper.setBlock(POS, Blocks.ACACIA_LEAVES);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ENERGETIC_SHEARS);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        ((ItemEnergeticShearsCommon)((Object)RegistryEntries.ITEM_ENERGETIC_SHEARS.value())).setEnergyStored(itemStack, ((ItemEnergeticShearsCommon)((Object)RegistryEntries.ITEM_ENERGETIC_SHEARS.value())).getMaxEnergyStored(itemStack), player, player.getUsedItemHand());
        helper.succeedWhen(() -> {
            BlockState blockState = helper.getBlockState(POS);
            InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
            helper.assertFalse(interactionResult == InteractionResult.FAIL, (Component)Component.literal((String)"Interaction must succeed"));
            helper.assertTrue(itemStack.getItem().mineBlock(itemStack, (Level)helper.getLevel(), blockState, helper.absolutePos(POS), (LivingEntity)player), (Component)Component.literal((String)"Item can not mine block"));
            helper.assertTrue(player.hasCorrectToolForDrops(blockState), (Component)Component.literal((String)"Player must have correct tool"));
            blockState.getBlock().playerDestroy((Level)helper.getLevel(), player, helper.absolutePos(POS), blockState, null, itemStack);
            helper.assertItemEntityPresent(Items.ACACIA_LEAVES);
            helper.assertTrue(((ItemEnergeticShearsCommon)((Object)((Object)RegistryEntries.ITEM_ENERGETIC_SHEARS.value()))).getEnergyStored(player.getMainHandItem()) < ((ItemEnergeticShearsCommon)((Object)((Object)RegistryEntries.ITEM_ENERGETIC_SHEARS.value()))).getMaxEnergyStored(player.getMainHandItem()), (Component)Component.literal((String)"No energy was consumed from shears"));
        });
    }

    @GameTest(template="energeticsheep:empty10")
    public void testShearEnergeticLeavesNoPower(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.ACACIA_LEAVES);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ENERGETIC_SHEARS);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.succeedWhen(() -> {
            InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
            helper.assertFalse(interactionResult == InteractionResult.FAIL, (Component)Component.literal((String)"Interaction must fail"));
            helper.assertItemEntityNotPresent(Items.ACACIA_LEAVES);
            helper.assertTrue(((ItemEnergeticShearsCommon)((Object)((Object)RegistryEntries.ITEM_ENERGETIC_SHEARS.value()))).getEnergyStored(player.getMainHandItem()) == 0, (Component)Component.literal((String)"Energy must remain zero"));
        });
    }

    @GameTest(template="energeticsheep:empty10")
    public void testShearEnergeticWithPowerRegularSheep(GameTestHelper helper) {
        Sheep entity = GameTestsCommon.SPAWN_REGULAR(helper);
        entity.setColor(DyeColor.WHITE);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ENERGETIC_SHEARS);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        ((ItemEnergeticShearsCommon)((Object)RegistryEntries.ITEM_ENERGETIC_SHEARS.value())).setEnergyStored(itemStack, ((ItemEnergeticShearsCommon)((Object)RegistryEntries.ITEM_ENERGETIC_SHEARS.value())).getMaxEnergyStored(itemStack), player, player.getUsedItemHand());
        helper.succeedWhen(() -> {
            InteractionResult result = player.interactOn((Entity)entity, InteractionHand.MAIN_HAND);
            helper.assertItemEntityPresent(Items.WHITE_WOOL);
            helper.assertTrue(((ItemEnergeticShearsCommon)((Object)((Object)RegistryEntries.ITEM_ENERGETIC_SHEARS.value()))).getEnergyStored(player.getMainHandItem()) < ((ItemEnergeticShearsCommon)((Object)((Object)RegistryEntries.ITEM_ENERGETIC_SHEARS.value()))).getMaxEnergyStored(player.getMainHandItem()), (Component)Component.literal((String)"No energy was consumed from shears"));
            helper.assertTrue(result.equals((Object)InteractionResult.SUCCESS), (Component)Component.literal((String)"Interaction failed"));
        });
    }

    @GameTest(template="energeticsheep:empty10")
    public void testShearEnergeticNoPowerRegularSheep(GameTestHelper helper) {
        Sheep entity = GameTestsCommon.SPAWN_REGULAR(helper);
        entity.setColor(DyeColor.WHITE);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ENERGETIC_SHEARS);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.succeedWhen(() -> {
            InteractionResult result = player.interactOn((Entity)entity, InteractionHand.MAIN_HAND);
            helper.assertItemEntityNotPresent(Items.WHITE_WOOL);
            helper.assertTrue(((ItemEnergeticShearsCommon)((Object)((Object)RegistryEntries.ITEM_ENERGETIC_SHEARS.value()))).getEnergyStored(player.getMainHandItem()) == 0, (Component)Component.literal((String)"Shears do not have enough energy"));
            helper.assertTrue(result.equals((Object)InteractionResult.PASS), (Component)Component.literal((String)"Interaction did not pass"));
        });
    }

    protected static EntityEnergeticSheepCommon SPAWN(GameTestHelper helper) {
        EntityEnergeticSheepCommon entity = (EntityEnergeticSheepCommon)helper.spawn((EntityType)RegistryEntries.ENTITY_TYPE_ENERGETIC_SHEEP.value(), POS.above());
        entity.finalizeSpawn((ServerLevelAccessor)helper.getLevel(), helper.getLevel().getCurrentDifficultyAt(POS), EntitySpawnReason.NATURAL, null);
        return entity;
    }

    protected static Sheep SPAWN_REGULAR(GameTestHelper helper) {
        Sheep entity = (Sheep)helper.spawn(EntityType.SHEEP, POS.above());
        entity.finalizeSpawn((ServerLevelAccessor)helper.getLevel(), helper.getLevel().getCurrentDifficultyAt(POS), EntitySpawnReason.NATURAL, null);
        return entity;
    }

    protected static EntityType<EntityEnergeticSheepCommon> SHEEP() {
        return (EntityType)RegistryEntries.ENTITY_TYPE_ENERGETIC_SHEEP.value();
    }

    protected boolean isForge() {
        try {
            Class.forName("net.minecraftforge.common.MinecraftForge");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

